/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.windows;

import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.DefaultGraphicsScreen;
import jogamp.newt.ScreenImpl;
import jogamp.newt.windows.WindowsDisplay;

public class WindowsScreen
extends ScreenImpl {
    private int nativeModeIdx;

    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
        this.setScreenSize(this.getWidthImpl0(this.screen_idx), this.getHeightImpl0(this.screen_idx));
    }

    @Override
    protected void closeNativeImpl() {
    }

    private int[] getScreenModeIdx(int n) {
        int[] nArray = this.getScreenMode0(this.screen_idx, n);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (nArray.length < 8) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + nArray.length);
        }
        return nArray;
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        this.nativeModeIdx = 0;
        return this.getScreenModeNextImpl();
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        int[] nArray = this.getScreenModeIdx(this.nativeModeIdx);
        if (null != nArray && 0 < nArray.length) {
            ++this.nativeModeIdx;
            return nArray;
        }
        return null;
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        int[] nArray = this.getScreenModeIdx(-1);
        if (null != nArray && 0 < nArray.length) {
            return ScreenModeUtil.streamIn(nArray, 0);
        }
        return null;
    }

    @Override
    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        return this.setScreenMode0(this.screen_idx, screenMode.getMonitorMode().getSurfaceSize().getResolution().getWidth(), screenMode.getMonitorMode().getSurfaceSize().getResolution().getHeight(), screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel(), screenMode.getMonitorMode().getRefreshRate(), screenMode.getRotation());
    }

    private native int getWidthImpl0(int var1);

    private native int getHeightImpl0(int var1);

    private native int[] getScreenMode0(int var1, int var2);

    private native boolean setScreenMode0(int var1, int var2, int var3, int var4, int var5, int var6);

    static {
        WindowsDisplay.initSingleton();
    }
}

