package cs4621.lecture01;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;


public class Demo10 implements GLEventListener {
	
	public Demo10() {		
		// NOP
	}
	
	public static void main(String[] args) {	
		Demo10 app = new Demo10();
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		GLCanvas canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(app);
		
		JFrame frame = new JFrame("CS 4621 Demo 10: Drawing Fractals");
		frame.getContentPane().add(canvas, BorderLayout.CENTER);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(512, 512);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}	

	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0, 0, 0, 0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		sierpinski(gl, 8);
	}
	
	void triangle(GL2 gl)
	{
		gl.glBegin(GL2.GL_LINE_LOOP);
		
		gl.glVertex2d( 0.0,  1.0 / Math.sqrt(3.0));
		gl.glVertex2d( 0.5, -0.5 / Math.sqrt(3.0));
		gl.glVertex2d(-0.5, -0.5 / Math.sqrt(3.0));

		gl.glEnd();
	}

	void sierpinski(GL2 gl, int k)
	{
		if (k == 0)
			triangle(gl);
		else
		{
	        gl.glPushMatrix();
			gl.glTranslated(0.0, 0.5 / Math.sqrt(3.0), 0.0);
			gl.glScaled(0.5, 0.5, 0.5);
			sierpinski(gl, k-1);
			gl.glPopMatrix();

			gl.glPushMatrix();
			gl.glTranslated(0.25, -0.25 / Math.sqrt(3.0), 0.0);
			gl.glScaled(0.5, 0.5, 0.5);
			sierpinski(gl, k-1);
			gl.glPopMatrix();

			gl.glPushMatrix();
			gl.glTranslated(-0.25, -0.25 / Math.sqrt(3.0), 0.0);
			gl.glScaled(0.5, 0.5, 0.5);
			sierpinski(gl, k-1);
			gl.glPopMatrix();
		}
	}


	@Override
	public void reshape(GLAutoDrawable drawable, 
			int x, int y, int w, int h) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
		
		if (w == 0) w = 1;
		if (h == 0) h = 1;

		double aspect = w * 1.0 / h;

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		if (w > h)
			glu.gluOrtho2D(-aspect, aspect, -1, 1);
		else
			glu.gluOrtho2D(-1, 1, -1/aspect, 1/aspect);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}
}
