package cs4621.lecture01;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;


public class Demo09 implements GLEventListener {
	
	public Demo09() {		
		// NOP
	}
	
	public static void main(String[] args) {	
		Demo09 app = new Demo09();
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		GLCanvas canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(app);
		
		JFrame frame = new JFrame("CS 4621 Demo 9: Drawing hierarchical scene");
		frame.getContentPane().add(canvas, BorderLayout.CENTER);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(512, 512);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}	

	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(1, 1, 1, 1);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		scene(gl);		
	}
	
	void square(GL2 gl, double r, double g, double b)
	{
		gl.glColor3d(r, g, b);
		gl.glBegin(GL2.GL_QUADS);	
		gl.glVertex2d(-1, -1);
		gl.glVertex2d( 1, -1);
		gl.glVertex2d( 1,  1);
		gl.glVertex2d(-1,  1);
		gl.glEnd();

		gl.glColor3d(0,0,0);
		gl.glLineWidth(2.0f);
		gl.glBegin(GL2.GL_LINE_LOOP);
		gl.glVertex2d(-1, -1);
		gl.glVertex2d( 1, -1);
		gl.glVertex2d( 1,  1);
		gl.glVertex2d(-1,  1);
		gl.glEnd();
	}

	void circle(GL2 gl, double r, double g, double b)
	{
		gl.glColor3d(r, g, b);
		gl.glBegin(GL2.GL_TRIANGLE_FAN);
		gl.glVertex2d(0.0, 0.0);
		for(int i=0;i<256;i++)
		{
			double theta = 2 * Math.PI * i / 256;
			double y = Math.sin(theta);
			double x = Math.cos(theta);
			gl.glVertex2d(x,y);
		}
		gl.glVertex2d(1.0, 0.0);
		gl.glEnd();

		gl.glColor3d(0.0, 0.0, 0.0);
		gl.glLineWidth(2.0f);
		gl.glBegin(GL2.GL_LINE_LOOP);	
		for(int i=0;i<256;i++)
		{
			double theta = 2 * Math.PI * i / 256;
			double y = Math.sin(theta);
			double x = Math.cos(theta);
			gl.glVertex2d(x,y);
		}
		gl.glEnd();
	}

	void chair(GL2 gl)
	{
		gl.glPushMatrix();
		gl.glTranslated(0.1, 0.35, 0.0);
		gl.glScaled(0.1, 0.35, 1.0);
		square(gl, 0.0, 1.0, 1.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(0.3, 0.8, 0.0);
		gl.glScaled(0.3, 0.1, 1.0);
		square(gl, 0.0, 1.0, 1.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(0.7, 1.1, 0.0);
		gl.glScaled(0.1, 1.1, 1.0);
		square(gl, 0.0, 1.0, 1.0);
		gl.glPopMatrix();
	}

	void table(GL2 gl)
	{
		gl.glPushMatrix();
		gl.glTranslated(0.1, 0.55, 0.0);
		gl.glScaled(0.1, 0.55, 1.0);
		square(gl, 0.5, 0.5, 0.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(1.2, 1.2, 0.0);
		gl.glScaled(1.2, 0.1, 1.0);
		square(gl, 0.5, 0.5, 0.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(2.3, 0.55, 0.0);
		gl.glScaled(0.1, 0.55, 1.0);
		square(gl, 0.5, 0.5, 0.0);
		gl.glPopMatrix();
	}

	void tray(GL2 gl)
	{
		gl.glPushMatrix();
		gl.glTranslated(0.3, 0.3, 0.0);
		gl.glScaled(0.2, 0.2, 0.2);
		circle(gl, 1.0, 1.0, 0.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(0.6, 0.3, 0.0);
		gl.glScaled(0.2, 0.2, 0.2);
		circle(gl, 1.0, 0.0, 0.0);
		gl.glPopMatrix();

		gl.glPushMatrix();
		gl.glTranslated(0.45, 0.15, 0.0);
		gl.glScaled(0.45, 0.15, 1.0);
		square(gl, 0.0, 1.0, 0.0);
		gl.glPopMatrix();
	}

	void tableAndTray(GL2 gl)
	{
		table(gl);

		gl.glPushMatrix();
		gl.glTranslated(0.8, 1.3, 0.0);
		tray(gl);
		gl.glPopMatrix();
	}

	void floor(GL2 gl)
	{
		gl.glPushMatrix();
		gl.glTranslated(0.0, -1.05, 0.0);
		gl.glScaled(2.1, 0.05, 1.0);
		square(gl, 0.0, 0.0, 0.0);
		gl.glPopMatrix();
	}

	void scene(GL2 gl)
	{
		gl.glPushMatrix();
		gl.glTranslated(-1.7, -1.0, 0.0);
		tableAndTray(gl);
		gl.glPopMatrix();

		floor(gl);

		gl.glPushMatrix();
		gl.glTranslated(0.9, -1.0, 0.0);
		chair(gl);
		gl.glPopMatrix();
	}


	@Override
	public void reshape(GLAutoDrawable drawable, 
			int x, int y, int w, int h) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
		
		if (w == 0) w = 1;
		if (h == 0) h = 1;

		double aspect = w * 1.0 / h;

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		if (w > h)
			glu.gluOrtho2D(-3.0*aspect, 3.0*aspect, -3, 3);
		else
			glu.gluOrtho2D(-3, 3, -3.0/aspect, 3.0/aspect);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}
}
