package cs4621.lecture01;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


public class Demo08 extends JFrame implements GLEventListener, ChangeListener {	
	private static final long serialVersionUID = 1L;
	
	double translateX = 0;
	double translateY = 0;
	
	double angle = 0;
	
	double scaleX = 1;
	double scaleY = 1;	
	
	JSpinner translateXSpinner;
	JSpinner translateYSpinner;
	JSpinner angleSpinner;
	JSpinner scaleXSpinner;
	JSpinner scaleYSpinner;	
		
	JLabel glTranslateCommandLabel;
	JLabel glRotateCommandLabel;
	JLabel glScaleCommandLabel;
	
	GLCanvas canvas;
	
	JCheckBox firstCoordinateSystemCheckBox;
	JCheckBox secondCoordinateSystemCheckBox;
	JCheckBox thirdCoordinateSystemCheckBox;
	JCheckBox fourthCoordinateSystemCheckBox;
	
	GridBagConstraints constraint;
	
	public Demo08() {
		super("CS 4621 Demo 8: Composition");
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(this);
		canvas.setPreferredSize(new Dimension(600,600));
			
		getContentPane().add(canvas, BorderLayout.CENTER);
		
		JPanel rightPanel = new JPanel();		
		rightPanel.setLayout(new GridBagLayout());
		getContentPane().add(rightPanel, BorderLayout.LINE_END);
		
		createTranslationPanel(rightPanel);
		createRotationPanel(rightPanel);
		createScalingPanel(rightPanel);
		createCommandPanel(rightPanel);		
		createDisplayPanel(rightPanel);		
		createFillPanel(rightPanel);		
				
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);		
	}

	private void createFillPanel(JPanel rightPanel) {
		JPanel fillPanel = new JPanel();
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 5;
		constraint.weighty = 1;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.BOTH;
		rightPanel.add(fillPanel, constraint);
	}

	private void createDisplayPanel(JPanel rightPanel) {
		JPanel displayPanel = new JPanel();
		constraint = new GridBagConstraints();	
		constraint.gridx = 0;
		constraint.gridy = 4;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(displayPanel, constraint);
		
		displayPanel.setLayout(new GridBagLayout());			
		displayPanel.setBorder(BorderFactory.createTitledBorder("Display"));
		
		firstCoordinateSystemCheckBox = new JCheckBox("1st coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		firstCoordinateSystemCheckBox.setSelected(true);
		firstCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(firstCoordinateSystemCheckBox, constraint);
		
		secondCoordinateSystemCheckBox = new JCheckBox("2nd coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		secondCoordinateSystemCheckBox.setSelected(false);
		secondCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(secondCoordinateSystemCheckBox, constraint);
		
		thirdCoordinateSystemCheckBox = new JCheckBox("3rd coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 2;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		thirdCoordinateSystemCheckBox.setSelected(false);
		thirdCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(thirdCoordinateSystemCheckBox, constraint);
		
		fourthCoordinateSystemCheckBox = new JCheckBox("4th coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 3;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		fourthCoordinateSystemCheckBox.setSelected(false);
		fourthCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(fourthCoordinateSystemCheckBox, constraint);
	}

	private void createCommandPanel(JPanel rightPanel) {
		JPanel commandPanel = new JPanel();
		constraint = new GridBagConstraints();	
		constraint.gridx = 0;
		constraint.gridy = 3;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(commandPanel, constraint);
		
		commandPanel.setLayout(new GridBagLayout());			
		commandPanel.setBorder(BorderFactory.createTitledBorder("OpenGL Commands"));
		
		glTranslateCommandLabel = new JLabel("gl.glTranslated(0.0,0.0,0.0);");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		commandPanel.add(glTranslateCommandLabel, constraint);
					
		glRotateCommandLabel = new JLabel("gl.Rotated(0.0,0.0,0.0,1.0);");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		commandPanel.add(glRotateCommandLabel, constraint);
		
		glScaleCommandLabel = new JLabel("gl.glScaled(1.0,1.0,1.0);");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 2;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		commandPanel.add(glScaleCommandLabel, constraint);
		
		JLabel drawHouseLabel = new JLabel("drawHouse();");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 3;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.anchor = GridBagConstraints.WEST;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,5,5);
		commandPanel.add(drawHouseLabel, constraint);
	}
	
	private void createTranslationPanel(JPanel rightPanel) {
		JPanel controlPanel = new JPanel();
		GridBagConstraints constraint = new GridBagConstraints();
		constraint.anchor = GridBagConstraints.NORTH;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(controlPanel, constraint);		
		controlPanel.setLayout(new GridBagLayout());
		controlPanel.setBorder(BorderFactory.createTitledBorder("Translation"));
		controlPanel.setPreferredSize(new Dimension(200, 75));
				
		JLabel xLabel = new JLabel("x:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.insets = new Insets(0, 5, 0, 5);
		controlPanel.add(xLabel, constraint);		
		
		translateXSpinner = new JSpinner(new SpinnerNumberModel(new Double(0.0), new Double(-40), new Double(40), new Double(0.1)));
		constraint = new GridBagConstraints();
		constraint.gridx = 1;
		constraint.gridy = 0;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(0, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(translateXSpinner, constraint);
		translateXSpinner.addChangeListener(this);
		
		JLabel yLabel = new JLabel("y:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.insets = new Insets(3, 5, 0, 5);
		controlPanel.add(yLabel, constraint);
		
		translateYSpinner = new JSpinner(new SpinnerNumberModel(new Double(0.0), new Double(-40), new Double(40), new Double(0.1)));
		constraint.gridx = 1;
		constraint.gridy = 1;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(3, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(translateYSpinner, constraint);
		translateYSpinner.addChangeListener(this);
	}

	private void createRotationPanel(JPanel rightPanel) {
		JPanel controlPanel = new JPanel();
		GridBagConstraints constraint = new GridBagConstraints();
		constraint.anchor = GridBagConstraints.NORTH;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(controlPanel, constraint);		
		controlPanel.setLayout(new GridBagLayout());
		controlPanel.setBorder(BorderFactory.createTitledBorder("Rotation"));
		controlPanel.setPreferredSize(new Dimension(200, 75));
		
		
		JLabel angleLabel = new JLabel("Angle:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.insets = new Insets(0, 5, 0, 5);
		controlPanel.add(angleLabel, constraint);		
		
		angleSpinner = new JSpinner(new SpinnerNumberModel(new Double(0.0), new Double(-720.0), new Double(720.0), new Double(1)));
		constraint = new GridBagConstraints();
		constraint.gridx = 1;
		constraint.gridy = 0;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(0, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(angleSpinner, constraint);
		angleSpinner.addChangeListener(this);
	}
	
	private void createScalingPanel(JPanel rightPanel) {
		JPanel controlPanel = new JPanel();
		GridBagConstraints constraint = new GridBagConstraints();
		constraint.anchor = GridBagConstraints.NORTH;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.gridx = 0;
		constraint.gridy = 2;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(controlPanel, constraint);		
		controlPanel.setLayout(new GridBagLayout());
		controlPanel.setBorder(BorderFactory.createTitledBorder("Scaling"));
		controlPanel.setPreferredSize(new Dimension(200, 75));
				
		JLabel xLabel = new JLabel("x:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.insets = new Insets(0, 5, 0, 5);
		controlPanel.add(xLabel, constraint);		
		
		scaleXSpinner = new JSpinner(new SpinnerNumberModel(new Double(1.0), new Double(-40), new Double(40), new Double(0.1)));
		constraint = new GridBagConstraints();
		constraint.gridx = 1;
		constraint.gridy = 0;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(0, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(scaleXSpinner, constraint);
		scaleXSpinner.addChangeListener(this);
		
		JLabel yLabel = new JLabel("y:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.insets = new Insets(3, 5, 0, 5);
		controlPanel.add(yLabel, constraint);
		
		scaleYSpinner = new JSpinner(new SpinnerNumberModel(new Double(1.0), new Double(-40), new Double(40), new Double(0.1)));
		constraint.gridx = 1;
		constraint.gridy = 1;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(3, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(scaleYSpinner, constraint);
		scaleYSpinner.addChangeListener(this);
	}
	
	public void run()
	{		
		setSize(800, 600);
		setLocationRelativeTo(null);
		pack();
		setVisible(true);
	}
	
	public static void main(String[] args) {	
		new Demo08().run();
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}
	
	void drawHouse(GL2 gl)
	{
		gl.glLineWidth(2.0f);
		
		gl.glColor3f(1,1,0);

		gl.glBegin(GL2.GL_LINE_LOOP);
		gl.glVertex2f(0,0);
		gl.glVertex2f(2,0);
		gl.glVertex2f(2,2);
		gl.glVertex2f(0,2);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_STRIP);
		gl.glVertex2f(0,2); 
		gl.glVertex2f(1,3);
		gl.glVertex2f(2,2);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_STRIP);
		gl.glVertex2f(1.0f/3, 0);
		gl.glVertex2f(1.0f/3, 4.0f/3);
		gl.glVertex2f(3.0f/3, 4.0f/3);
		gl.glVertex2f(3.0f/3, 0);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_LOOP);
		gl.glVertex2f(1.25f, 0.5f);
		gl.glVertex2f(1.25f, 1);
		gl.glVertex2f(1.75f, 1);
		gl.glVertex2f(1.75f, 0.5f);
		gl.glEnd();
	}


	float[] firstLineColor = new float[] {0.3f, 0.3f, 0.3f};
	float[] firstXAxisColor = new float[] {0.3f, 0.3f, 0.3f};
	float[] firstYAxisColor = new float[] {0.3f, 0.3f, 0.3f};

	float[] secondLineColor = new float[] {0.6f, 0.3f, 0.6f};
	float[] secondXAxisColor = new float[] {0.6f, 0.3f, 0.6f};
	float[] secondYAxisColor = new float[] {0.6f, 0.3f, 0.6f};

	float[] thirdLineColor = new float[] {0.3f, 0.6f, 0.6f};
	float[] thirdXAxisColor = new float[] {0.3f, 0.6f, 0.6f};
	float[] thirdYAxisColor = new float[] {0.3f, 0.6f, 0.6f};

	float[] fourthLineColor = new float[] {0.5f, 0.5f, 1.0f};
	float[] fourthXAxisColor = new float[] {1.0f, 0.5f, 0.5f};
	float[] fourthYAxisColor = new float[] {0.5f, 1.0f, 0.5f};

	void drawCoordinateSystem(GL2 gl, float[] lineColor, float[] xAxisColor, float[] yAxisColor)
	{
		gl.glLineWidth(1.0f);

		gl.glColor3fv(lineColor, 0);
		gl.glBegin(GL2.GL_LINES);
		for(int x=-20;x<=20;x++)
		{
			gl.glVertex2f(x, -20);
			gl.glVertex2f(x, 20);
		}
		for(int y=-20;y<=20;y++)
		{
			gl.glVertex2f(-20, y);
			gl.glVertex2f(20, y);
		}
		gl.glEnd();

		gl.glPushMatrix();
		gl.glTranslated(-0.1, -0.1, 0);
		gl.glLineWidth(3.0f);
		gl.glColor3fv(xAxisColor,0);
		gl.glBegin(GL2.GL_LINES);
		gl.glVertex2f(0,0);
		gl.glVertex2f(1,0);
		gl.glEnd();

		gl.glLineWidth(3.0f);
		gl.glColor3fv(yAxisColor,0);
		gl.glBegin(GL2.GL_LINES);
		gl.glVertex2f(0,0);
		gl.glVertex2f(0,1);
		gl.glEnd();

		gl.glPopMatrix();

	}

	void draw(GL2 gl)
	{
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();

		gl.glScaled(0.2, 0.2, 1);

		if (firstCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, firstLineColor, firstXAxisColor, firstYAxisColor);		
		
		gl.glTranslated(translateX, translateY, 1.0f);
		if (secondCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, secondLineColor, secondXAxisColor, secondYAxisColor);		
		
		gl.glRotated(angle, 0.0, 0.0, 1.0);
		if (thirdCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, thirdLineColor, thirdXAxisColor, thirdYAxisColor);
		
		gl.glScaled(scaleX, scaleY, 1.0);
		if (fourthCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, fourthLineColor, fourthXAxisColor, fourthYAxisColor);
		
		drawHouse(gl);
	}


	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0, 0, 0, 0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		draw(gl);
		
		gl.glEnd();
	}

	@Override
	public void reshape(GLAutoDrawable drawable, 
			int x, int y, int w, int h) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
		
		if (w == 0) w = 1;
		if (h == 0) h = 1;

		double aspect = w * 1.0 / h;

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		if (w > h)
			glu.gluOrtho2D(-aspect, aspect, -1, 1);
		else
			glu.gluOrtho2D(-1, 1, -1/aspect, 1/aspect);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		translateX = (Double)translateXSpinner.getValue();
		translateY = (Double)translateYSpinner.getValue();		
		
		glTranslateCommandLabel.setText(
				"glTranslated(" + 
						String.format("%.1f", (Double)translateXSpinner.getValue()) + 
						"," + 
						String.format("%.1f", (Double)translateYSpinner.getValue()) + 
						",0.0);");
		
		angle = (Double)angleSpinner.getValue();				
		
		glRotateCommandLabel.setText(
				"glRotated(" + 
						String.format("%.1f", (Double)angleSpinner.getValue()) + 
						",0.0,0.0,1.0);");
		
		scaleX = (Double)scaleXSpinner.getValue();
		scaleY = (Double)scaleYSpinner.getValue();		
		
		glScaleCommandLabel.setText(
				"glScaled(" + 
						String.format("%.1f", (Double)scaleXSpinner.getValue()) + 
						"," + 
						String.format("%.1f", (Double)scaleYSpinner.getValue()) + 
						",1.0);");
		
		canvas.repaint();
	}
}
