package cs4621.lecture01;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


public class Demo07 extends JFrame implements GLEventListener, ChangeListener {	
	private static final long serialVersionUID = 1L;
	
	double angle = 0;	
	
	JSpinner angleSpinner;
	JLabel glRotateCommandLabel;
	GLCanvas canvas;
	JCheckBox oldCoordinateSystemCheckBox;
	JCheckBox newCoordinateSystemCheckBox;
	
	public Demo07() {
		super("CS 4621 Demo 7: Rotation");
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(this);
		canvas.setPreferredSize(new Dimension(600,600));
			
		getContentPane().add(canvas, BorderLayout.CENTER);
		
		JPanel rightPanel = new JPanel();		
		rightPanel.setLayout(new GridBagLayout());
		getContentPane().add(rightPanel, BorderLayout.LINE_END);
		
		JPanel controlPanel = new JPanel();
		GridBagConstraints constraint = new GridBagConstraints();
		constraint.anchor = GridBagConstraints.NORTH;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(controlPanel, constraint);		
		controlPanel.setLayout(new GridBagLayout());
		controlPanel.setBorder(BorderFactory.createTitledBorder("Controls"));
		controlPanel.setPreferredSize(new Dimension(200, 75));
		
		
		JLabel angleLabel = new JLabel("Angle:");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.insets = new Insets(0, 5, 0, 5);
		controlPanel.add(angleLabel, constraint);		
		
		angleSpinner = new JSpinner(new SpinnerNumberModel(new Double(0.0), new Double(-720.0), new Double(720.0), new Double(1)));
		constraint = new GridBagConstraints();
		constraint.gridx = 1;
		constraint.gridy = 0;
		constraint.weightx = 1.0f;
		constraint.insets = new Insets(0, 5, 0, 5);
		constraint.fill = GridBagConstraints.HORIZONTAL;
		controlPanel.add(angleSpinner, constraint);
		angleSpinner.addChangeListener(this);
				
		JPanel commandPanel = new JPanel();
		constraint = new GridBagConstraints();	
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(commandPanel, constraint);
		
		commandPanel.setLayout(new GridBagLayout());			
		commandPanel.setBorder(BorderFactory.createTitledBorder("OpenGL Commands"));			
					
		glRotateCommandLabel = new JLabel("gl.Rotated(0.0,0.0,0.0,1.0);");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		commandPanel.add(glRotateCommandLabel, constraint);				
		
		JLabel drawHouseLabel = new JLabel("drawHouse();");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.anchor = GridBagConstraints.WEST;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(5,5,5,5);
		commandPanel.add(drawHouseLabel, constraint);
		
		JPanel displayPanel = new JPanel();
		constraint = new GridBagConstraints();	
		constraint.gridx = 0;
		constraint.gridy = 2;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		rightPanel.add(displayPanel, constraint);
		
		displayPanel.setLayout(new GridBagLayout());			
		displayPanel.setBorder(BorderFactory.createTitledBorder("Display"));
		
		oldCoordinateSystemCheckBox = new JCheckBox("Old coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 0;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		oldCoordinateSystemCheckBox.setSelected(true);
		oldCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(oldCoordinateSystemCheckBox, constraint);
		
		newCoordinateSystemCheckBox = new JCheckBox("New coordinate system");
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 1;
		constraint.weighty = 0;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.HORIZONTAL;
		constraint.insets = new Insets(0,5,0,5);
		constraint.anchor = GridBagConstraints.WEST;
		newCoordinateSystemCheckBox.setSelected(false);
		newCoordinateSystemCheckBox.addChangeListener(this);
		displayPanel.add(newCoordinateSystemCheckBox, constraint);
		
		JPanel fillPanel = new JPanel();
		constraint = new GridBagConstraints();
		constraint.gridx = 0;
		constraint.gridy = 3;
		constraint.weighty = 1;
		constraint.weightx = 1;
		constraint.fill = GridBagConstraints.BOTH;
		rightPanel.add(fillPanel, constraint);		
				
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);		
	}
	
	public void run()
	{		
		setSize(800, 600);
		setLocationRelativeTo(null);
		pack();
		setVisible(true);
	}
	
	public static void main(String[] args) {	
		new Demo07().run();
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}
	
	void drawHouse(GL2 gl)
	{
		gl.glLineWidth(2.0f);
		
		gl.glColor3f(1,1,0);

		gl.glBegin(GL2.GL_LINE_LOOP);
		gl.glVertex2f(0,0);
		gl.glVertex2f(2,0);
		gl.glVertex2f(2,2);
		gl.glVertex2f(0,2);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_STRIP);
		gl.glVertex2f(0,2); 
		gl.glVertex2f(1,3);
		gl.glVertex2f(2,2);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_STRIP);
		gl.glVertex2f(1.0f/3, 0);
		gl.glVertex2f(1.0f/3, 4.0f/3);
		gl.glVertex2f(3.0f/3, 4.0f/3);
		gl.glVertex2f(3.0f/3, 0);
		gl.glEnd();

		gl.glBegin(GL2.GL_LINE_LOOP);
		gl.glVertex2f(1.25f, 0.5f);
		gl.glVertex2f(1.25f, 1);
		gl.glVertex2f(1.75f, 1);
		gl.glVertex2f(1.75f, 0.5f);
		gl.glEnd();
	}

	float[] oldLineColor = new float[] {0.3f, 0.9f, 0.9f};
	float[] oldXAxisColor = new float[] {0.3f, 0.9f, 0.9f};
	float[] oldYAxisColor = new float[] {0.3f, 0.9f, 0.9f};

	float[] lineColor = new float[] {0.5f, 0.5f, 1.0f};
	float[] xAxisColor = new float[] {1.0f, 0.5f, 0.5f};
	float[] yAxisColor = new float[] {0.5f, 1.0f, 0.5f};

	void drawCoordinateSystem(GL2 gl, float[] lineColor, float[] xAxisColor, float[] yAxisColor)
	{
		gl.glLineWidth(1.0f);

		gl.glColor3fv(lineColor, 0);
		gl.glBegin(GL2.GL_LINES);
		for(int x=-20;x<=20;x++)
		{
			gl.glVertex2f(x, -20);
			gl.glVertex2f(x, 20);
		}
		for(int y=-20;y<=20;y++)
		{
			gl.glVertex2f(-20, y);
			gl.glVertex2f(20, y);
		}
		gl.glEnd();

		gl.glPushMatrix();
		gl.glTranslated(-0.1, -0.1, 0);
		gl.glLineWidth(3.0f);
		gl.glColor3fv(xAxisColor,0);
		gl.glBegin(GL2.GL_LINES);
		gl.glVertex2f(0,0);
		gl.glVertex2f(1,0);
		gl.glEnd();

		gl.glLineWidth(3.0f);
		gl.glColor3fv(yAxisColor,0);
		gl.glBegin(GL2.GL_LINES);
		gl.glVertex2f(0,0);
		gl.glVertex2f(0,1);
		gl.glEnd();

		gl.glPopMatrix();

	}

	void draw(GL2 gl)
	{
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();

		gl.glScaled(0.2, 0.2, 1);

		if (oldCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, oldLineColor, oldXAxisColor, oldYAxisColor);
		
		gl.glRotated(angle, 0.0, 0.0, 1.0);
		if (newCoordinateSystemCheckBox.isSelected())
			drawCoordinateSystem(gl, lineColor, xAxisColor, yAxisColor);
		drawHouse(gl);
	}


	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0, 0, 0, 0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		draw(gl);
		
		gl.glEnd();
	}

	@Override
	public void reshape(GLAutoDrawable drawable, 
			int x, int y, int w, int h) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
		
		if (w == 0) w = 1;
		if (h == 0) h = 1;

		double aspect = w * 1.0 / h;

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		if (w > h)
			glu.gluOrtho2D(-aspect, aspect, -1, 1);
		else
			glu.gluOrtho2D(-1, 1, -1/aspect, 1/aspect);
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {		
		angle = (Double)angleSpinner.getValue();		
		canvas.repaint();
		
		glRotateCommandLabel.setText(
				"glRotated(" + 
						String.format("%.1f", (Double)angleSpinner.getValue()) + 
						",0.0,0.0,1.0);");
	}
}
