package cs4621.lecture01;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;


public class Demo02 implements GLEventListener {
	
	public Demo02() {		
		// NOP
	}
	
	public static void main(String[] args) {	
		Demo02 app = new Demo02();
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		GLCanvas canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(app);
		
		JFrame frame = new JFrame("CS 4621 Demo 2: glColor and glVertex");
		frame.getContentPane().add(canvas, BorderLayout.CENTER);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(512, 512);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}	

	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0, 0, 0, 0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		gl.glBegin(GL2.GL_TRIANGLES);
		{
			// Red
			gl.glColor3f(1.0f, 0.5f, 0.5f);
			gl.glVertex3f( 0.0f,  0.5f, 0.0f);
			gl.glVertex3f(-0.25f, 0.0f, 0.0f);
			gl.glVertex3f( 0.25f, 0.0f, 0.0f);

			// Green
			gl.glColor3f(0.5f, 1.0f, 0.5f);
			gl.glVertex3f( -0.25f,  0.0f, 0.0f);
			gl.glVertex3f( -0.5f,  -0.5f, 0.0f);
			gl.glVertex3f(  0.0f,  -0.5f, 0.0f);

			// Blue
			gl.glColor3f(0.5f, 0.5f, 1.0f);
			gl.glVertex3f( 0.25f,  0.0f, 0.0f);
			gl.glVertex3f( 0.0f,  -0.5f, 0.0f);
			gl.glVertex3f( 0.5f,  -0.5f, 0.0f);

		}
		gl.glEnd();
	}

	@Override
	public void reshape(GLAutoDrawable drawble, 
			int x, int y, int width, int height) {
		// NOP
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}
}
