package cs4621.lecture01;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;


public class Demo01 implements GLEventListener {
	
	public Demo01() {		
		// NOP
	}
	
	public static void main(String[] args) {	
		Demo01 app = new Demo01();
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		GLCanvas canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(app);
		
		JFrame frame = new JFrame("CS 4621 Demo 1: How to write a JOGL application.");
		frame.getContentPane().add(canvas, BorderLayout.CENTER);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(512, 512);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}

	@Override
	public void init(GLAutoDrawable drawable) {
		// NOP				
	}	

	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0, 0, 0, 0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		
		gl.glColor3d(1.0, 1.0, 1.0);
		gl.glBegin(GL2.GL_POLYGON);
		{
			 gl.glVertex3d(-0.5, -0.5, 0.0);
			 gl.glVertex3d( 0.5, -0.5, 0.0);
			 gl.glVertex3d( 0.5,  0.5, 0.0);
			 gl.glVertex3d(-0.5,  0.5, 0.0);
		}
		gl.glEnd();
	}

	@Override
	public void reshape(GLAutoDrawable drawble, 
			int x, int y, int width, int height) {
		// NOP
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}
}
