/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.NativeLibrary;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Platform {
    public static final boolean JAVA_SE;
    public static final boolean LITTLE_ENDIAN;
    public static final String OS;
    public static final String OS_VERSION;
    public static final String ARCH;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final String NEWLINE;
    private static final boolean is32Bit;
    private static final int pointerSizeInBits;
    private static final int pageSize;

    private Platform() {
    }

    private static boolean initArch() throws RuntimeException {
        if (32 == pointerSizeInBits || 64 == pointerSizeInBits) {
            return 32 == pointerSizeInBits;
        }
        String string = OS.toLowerCase();
        String string2 = ARCH.toLowerCase();
        if (string.startsWith("windows") && string2.equals("x86") || string.startsWith("windows") && string2.equals("arm") || string.startsWith("linux") && string2.equals("i386") || string.startsWith("linux") && string2.equals("x86") || string.startsWith("mac os") && string2.equals("ppc") || string.startsWith("mac os") && string2.equals("i386") || string.startsWith("darwin") && string2.equals("ppc") || string.startsWith("darwin") && string2.equals("i386") || string.startsWith("sunos") && string2.equals("sparc") || string.startsWith("sunos") && string2.equals("x86") || string.startsWith("freebsd") && string2.equals("i386") || string.startsWith("hp-ux") && string2.equals("pa_risc2.0")) {
            return true;
        }
        if (string.startsWith("windows") && string2.equals("amd64") || string.startsWith("linux") && string2.equals("amd64") || string.startsWith("linux") && string2.equals("x86_64") || string.startsWith("linux") && string2.equals("ia64") || string.startsWith("mac os") && string2.equals("x86_64") || string.startsWith("darwin") && string2.equals("x86_64") || string.startsWith("sunos") && string2.equals("sparcv9") || string.startsWith("sunos") && string2.equals("amd64")) {
            return false;
        }
        throw new RuntimeException("Please port CPU detection (32/64 bit) to your platform (" + string + "/" + string2 + ")");
    }

    private static boolean initIsJavaSE() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.runtime.name");
            }
        });
        if (string.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean initByteOrder() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static native int getPointerSizeInBitsImpl();

    private static native long getPageSizeImpl();

    public static boolean isJavaSE() {
        return JAVA_SE;
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOS() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static String getArch() {
        return ARCH;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static boolean is32Bit() {
        return is32Bit;
    }

    public static boolean is64Bit() {
        return !is32Bit;
    }

    public static int getPointerSizeInBits() {
        return pointerSizeInBits;
    }

    public static int getPointerSizeInBytes() {
        return pointerSizeInBits / 8;
    }

    public static int getPageSize() {
        return pageSize;
    }

    public static int getPageNumber(int n) {
        return (n + (pageSize - 1)) / pageSize;
    }

    public static int getPageAlignedSize(int n) {
        return Platform.getPageNumber(n) * pageSize;
    }

    static {
        OS = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        ARCH = System.getProperty("os.arch");
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        NEWLINE = System.getProperty("line.separator");
        JAVA_SE = Platform.initIsJavaSE();
        LITTLE_ENDIAN = Platform.initByteOrder();
        boolean bl = true;
        try {
            NativeLibrary.ensureNativeLibLoaded();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        if (bl) {
            pointerSizeInBits = Platform.getPointerSizeInBitsImpl();
            long l = Platform.getPageSizeImpl();
            if (Integer.MAX_VALUE < l) {
                throw new InternalError("PageSize exceeds integer value: " + l);
            }
            pageSize = (int)l;
        } else {
            pointerSizeInBits = -1;
            pageSize = -1;
        }
        is32Bit = Platform.initArch();
    }
}

