/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt;

import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Insets;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.util.Point;
import jogamp.newt.WindowImpl;
import jogamp.newt.awt.AWTCanvas;
import jogamp.newt.awt.AWTDisplay;
import jogamp.newt.awt.AWTScreen;

public class AWTWindow
extends WindowImpl {
    private boolean owningFrame;
    private Container container = null;
    private Frame frame = null;
    private AWTCanvas canvas;

    public AWTWindow() {
        this(null);
    }

    public static Class[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public AWTWindow(Container container) {
        this.title = "AWT NewtWindow";
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.container.requestFocus();
    }

    @Override
    protected void setTitleImpl(String string) {
        if (this.frame != null) {
            this.frame.setTitle(string);
        }
    }

    @Override
    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
        }
        if (null == this.container) {
            this.frame = new Frame();
            this.container = this.frame;
            this.owningFrame = true;
        } else {
            this.owningFrame = false;
            this.width = this.container.getWidth();
            this.height = this.container.getHeight();
            this.x = this.container.getX();
            this.y = this.container.getY();
        }
        if (null != this.frame) {
            this.frame.setTitle(this.getTitle());
        }
        this.container.setLayout(new BorderLayout());
        this.canvas = new AWTCanvas(this.capsRequested, this.capabilitiesChooser);
        this.addWindowListener(new LocalWindowListener());
        new AWTMouseAdapter(this).addTo(this.canvas);
        new AWTKeyAdapter(this).addTo(this.canvas);
        this.container.add((Component)this.canvas, "Center");
        this.container.setSize(this.width, this.height);
        this.container.setLocation(this.x, this.y);
        new AWTWindowAdapter(this).addTo(this.container);
        if (null != this.frame) {
            this.frame.setUndecorated(this.undecorated || this.fullscreen);
        }
        this.setWindowHandle(1L);
    }

    @Override
    protected void closeNativeImpl() {
        this.setWindowHandle(0L);
        if (null != this.container) {
            this.container.setVisible(false);
            this.container.remove(this.canvas);
            this.container.setEnabled(false);
            this.canvas.setEnabled(false);
        }
        if (this.owningFrame && null != this.frame) {
            this.frame.dispose();
            this.owningFrame = false;
            this.frame = null;
        }
    }

    @Override
    public boolean hasDeviceChanged() {
        boolean bl = this.canvas.hasDeviceChanged();
        if (bl) {
            this.config = this.canvas.getAWTGraphicsConfiguration();
            if (this.config == null) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + this);
            }
            this.updateDeviceData();
        }
        return bl;
    }

    @Override
    protected void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.container.setVisible(bl);
        this.reconfigureWindowImpl(n, n2, n3, n4, false, 0, 0);
        this.config = this.canvas.getAWTGraphicsConfiguration();
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.updateDeviceData();
        this.visibleChanged(bl);
    }

    private void updateDeviceData() {
        ((AWTScreen)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)this.config.getScreen());
        ((AWTDisplay)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)this.config.getScreen().getDevice());
        DisplayMode displayMode = ((AWTGraphicsDevice)this.config.getScreen().getDevice()).getGraphicsDevice().getDisplayMode();
        if (null != displayMode) {
            ((AWTScreen)this.getScreen()).setScreenSize(displayMode.getWidth(), displayMode.getHeight());
        }
    }

    @Override
    public javax.media.nativewindow.util.Insets getInsets() {
        int[] nArray = new int[]{0, 0, 0, 0};
        Insets insets = this.container.getInsets();
        nArray[0] = insets.top;
        nArray[1] = insets.left;
        nArray[2] = insets.bottom;
        nArray[3] = insets.right;
        return new javax.media.nativewindow.util.Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        if (n6 != 0 && null != this.frame) {
            if (!this.container.isDisplayable()) {
                this.frame.setUndecorated(this.isUndecorated());
            } else if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                System.err.println("AWTWindow can't undecorate already created frame");
            }
        }
        int n7 = n >= 0 ? n : this.x;
        int n8 = n >= 0 ? n2 : this.y;
        int n9 = n3 > 0 ? n3 : this.width;
        int n10 = n4 > 0 ? n4 : this.height;
        this.container.setLocation(n7, n8);
        Insets insets = this.container.getInsets();
        this.container.setSize(n9 + insets.left + insets.right, n10 + insets.top + insets.bottom);
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        java.awt.Point point = this.canvas.getLocationOnScreen();
        point.translate(n, n2);
        return new Point((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
    }

    @Override
    public Object getWrappedWindow() {
        return this.canvas;
    }

    class LocalWindowListener
    extends WindowAdapter {
        LocalWindowListener() {
        }

        @Override
        public void windowMoved(WindowEvent windowEvent) {
            if (null != AWTWindow.this.container) {
                AWTWindow.this.x = AWTWindow.this.container.getX();
                AWTWindow.this.y = AWTWindow.this.container.getY();
            }
        }

        @Override
        public void windowResized(WindowEvent windowEvent) {
            if (null != AWTWindow.this.canvas) {
                AWTWindow.this.width = AWTWindow.this.canvas.getWidth();
                AWTWindow.this.height = AWTWindow.this.canvas.getHeight();
            }
        }
    }
}

