/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.NewtVersion;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.JoglVersion;
import java.io.PrintStream;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import javax.media.opengl.FPSCounter;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import jogamp.newt.WindowImpl;
import jogamp.opengl.FPSCounterImpl;
import jogamp.opengl.GLDrawableHelper;

public class GLWindow
implements GLAutoDrawable,
Window,
NEWTEventConsumer,
FPSCounter {
    private WindowImpl window;
    private GLContext sharedContext = null;
    private int additionalCtxCreationFlags = 0;
    private GLDrawableFactory factory;
    private GLDrawable drawable;
    private GLContext context;
    private GLDrawableHelper helper = new GLDrawableHelper();
    private boolean sendReshape = false;
    private boolean sendDestroy = false;
    private FPSCounterImpl fpsCounter = new FPSCounterImpl();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();

    protected GLWindow(Window window) {
        this.resetFPSCounter();
        this.window = (WindowImpl)window;
        this.window.setHandleDestroyNotify(false);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                if (!GLWindow.this.window.isWindowLockedByOtherThread() && !GLWindow.this.helper.isExternalAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                GLWindow.this.sendReshape = true;
                if (!GLWindow.this.window.isWindowLockedByOtherThread() && !GLWindow.this.helper.isExternalAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            @Override
            public void windowDestroyNotify(WindowEvent windowEvent) {
                if (1 == GLWindow.this.getDefaultCloseOperation()) {
                    if (GLWindow.this.helper.isExternalAnimatorRunning()) {
                        GLAnimatorControl gLAnimatorControl = GLWindow.this.helper.getAnimator();
                        boolean bl = gLAnimatorControl.pause();
                        GLWindow.this.destroy();
                        if (bl) {
                            gLAnimatorControl.resume();
                        }
                    } else if (GLWindow.this.window.isWindowLockedByOtherThread()) {
                        GLWindow.this.sendDestroy = true;
                    } else {
                        GLWindow.this.destroy();
                    }
                }
            }
        });
        this.window.setLifecycleHook(new GLLifecycleHook());
    }

    public static GLWindow create(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow((CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Window window) {
        return new GLWindow(window);
    }

    public static GLWindow create(NativeWindow nativeWindow, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(nativeWindow, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public int getDefaultCloseOperation() {
        return this.window.getDefaultCloseOperation();
    }

    public int setDefaultCloseOperation(int n) {
        return this.window.setDefaultCloseOperation(n);
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        return this.window.setCapabilitiesChooser(capabilitiesChooser);
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        if (this.drawable == null) {
            return this.window.getChosenCapabilities();
        }
        return this.drawable.getChosenGLCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.window.getRequestedCapabilities();
    }

    public final Window getWindow() {
        return this.window;
    }

    public final NativeWindow getParent() {
        return this.window.getParent();
    }

    @Override
    public final Screen getScreen() {
        return this.window.getScreen();
    }

    @Override
    public final void setTitle(String string) {
        this.window.setTitle(string);
    }

    @Override
    public final String getTitle() {
        return this.window.getTitle();
    }

    @Override
    public final void setUndecorated(boolean bl) {
        this.window.setUndecorated(bl);
    }

    @Override
    public final boolean isUndecorated() {
        return this.window.isUndecorated();
    }

    @Override
    public final void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.window.setFocusAction(focusRunnable);
    }

    @Override
    public final void requestFocus() {
        this.window.requestFocus();
    }

    @Override
    public boolean hasFocus() {
        return this.window.hasFocus();
    }

    @Override
    public final Insets getInsets() {
        return this.window.getInsets();
    }

    @Override
    public final void setPosition(int n, int n2) {
        this.window.setPosition(n, n2);
    }

    @Override
    public final boolean setFullscreen(boolean bl) {
        return this.window.setFullscreen(bl);
    }

    @Override
    public final boolean isFullscreen() {
        return this.window.isFullscreen();
    }

    @Override
    public final boolean isVisible() {
        return this.window.isVisible();
    }

    public final String toString() {
        return "NEWT-GLWindow[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + "]";
    }

    @Override
    public final int reparentWindow(NativeWindow nativeWindow) {
        return this.window.reparentWindow(nativeWindow);
    }

    @Override
    public final int reparentWindow(NativeWindow nativeWindow, boolean bl) {
        return this.window.reparentWindow(nativeWindow, bl);
    }

    @Override
    public final void removeChild(NativeWindow nativeWindow) {
        this.window.removeChild(nativeWindow);
    }

    @Override
    public final void addChild(NativeWindow nativeWindow) {
        this.window.addChild(nativeWindow);
    }

    @Override
    public final void destroy() {
        this.window.destroy();
    }

    @Override
    public final void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    @Override
    public final void setSize(int n, int n2) {
        this.window.setSize(n, n2);
    }

    @Override
    public final boolean isValid() {
        return this.window.isValid();
    }

    @Override
    public final boolean isNativeValid() {
        return this.window.isNativeValid();
    }

    public Point getLocationOnScreen(Point point) {
        return this.window.getLocationOnScreen(point);
    }

    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    public void setSharedContext(GLContext gLContext) {
        this.sharedContext = gLContext;
    }

    public void setContext(GLContext gLContext) {
        this.context = gLContext;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        if (this.context == null) {
            return null;
        }
        return this.context.getGL();
    }

    public GL setGL(GL gL) {
        if (this.context != null) {
            this.context.setGL(gL);
            return gL;
        }
        return null;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(gLEventListener);
        }
    }

    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(n, gLEventListener);
        }
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.removeGLEventListener(gLEventListener);
        }
    }

    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        if (null != this.helper) {
            this.helper.setAnimator(gLAnimatorControl);
        }
    }

    public GLAnimatorControl getAnimator() {
        if (null != this.helper) {
            return this.helper.getAnimator();
        }
        return null;
    }

    public void invoke(boolean bl, GLRunnable gLRunnable) {
        if (null != this.helper) {
            this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
        }
    }

    public void display() {
        this.display(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(boolean bl) {
        if (null == this.window) {
            return;
        }
        if (this.sendDestroy || null != this.window && this.window.hasDeviceChanged() && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        if (null == this.context && this.isVisible() && 0 < this.getWidth() * this.getHeight()) {
            this.setVisible(true);
        }
        if (bl) {
            this.sendReshape = true;
        }
        if (this.isVisible() && null != this.context && 1 < this.lockSurface()) {
            try {
                this.helper.invokeGL(this.drawable, this.context, (Runnable)this.displayAction, (Runnable)this.initAction);
            }
            finally {
                this.unlockSurface();
            }
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        if (null != this.helper) {
            this.helper.setAutoSwapBufferMode(bl);
        }
    }

    public boolean getAutoSwapBufferMode() {
        if (null != this.helper) {
            return this.helper.getAutoSwapBufferMode();
        }
        return false;
    }

    public void swapBuffers() {
        if (this.drawable != null && this.context != null) {
            this.drawable.swapBuffers();
        }
    }

    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    public final NativeSurface getNativeSurface() {
        return null != this.drawable ? this.drawable.getNativeSurface() : null;
    }

    public final long getHandle() {
        return null != this.drawable ? this.drawable.getHandle() : 0L;
    }

    @Override
    public final int getX() {
        return this.window.getX();
    }

    @Override
    public final int getY() {
        return this.window.getY();
    }

    @Override
    public final int getWidth() {
        return this.window.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.window.getHeight();
    }

    public final GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public final void setRealized(boolean bl) {
    }

    public final boolean isRealized() {
        return null != this.drawable ? this.drawable.isRealized() : false;
    }

    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getChosenGLCapabilities();
    }

    public final GLProfile getGLProfile() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getGLProfile();
    }

    @Override
    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        return this.window.consumeEvent(nEWTEvent);
    }

    @Override
    public final void windowRepaint(int n, int n2, int n3, int n4) {
        this.window.windowRepaint(n, n2, n3, n4);
    }

    @Override
    public final void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        this.window.enqueueEvent(bl, nEWTEvent);
    }

    @Override
    public final void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        this.window.runOnEDTIfAvail(bl, runnable);
    }

    @Override
    public final SurfaceUpdatedListener getSurfaceUpdatedListener(int n) {
        return this.window.getSurfaceUpdatedListener(n);
    }

    @Override
    public final SurfaceUpdatedListener[] getSurfaceUpdatedListeners() {
        return this.window.getSurfaceUpdatedListeners();
    }

    @Override
    public final void removeAllSurfaceUpdatedListener() {
        this.window.removeAllSurfaceUpdatedListener();
    }

    @Override
    public final void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.window.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void sendWindowEvent(int n) {
        this.window.sendWindowEvent(n);
    }

    @Override
    public final WindowListener getWindowListener(int n) {
        return this.window.getWindowListener(n);
    }

    @Override
    public final WindowListener[] getWindowListeners() {
        return this.window.getWindowListeners();
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        this.window.removeWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(WindowListener windowListener) {
        this.window.addWindowListener(windowListener);
    }

    @Override
    public final void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        this.window.addWindowListener(n, windowListener);
    }

    @Override
    public final void addKeyListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    @Override
    public final void addKeyListener(int n, KeyListener keyListener) {
        this.window.addKeyListener(n, keyListener);
    }

    @Override
    public final void removeKeyListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    @Override
    public final KeyListener getKeyListener(int n) {
        return this.window.getKeyListener(n);
    }

    @Override
    public final KeyListener[] getKeyListeners() {
        return this.window.getKeyListeners();
    }

    @Override
    public final void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    @Override
    public final void addMouseListener(int n, MouseListener mouseListener) {
        this.window.addMouseListener(n, mouseListener);
    }

    @Override
    public final void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    @Override
    public final MouseListener getMouseListener(int n) {
        return this.window.getMouseListener(n);
    }

    @Override
    public final MouseListener[] getMouseListeners() {
        return this.window.getMouseListeners();
    }

    public final int lockSurface() {
        return this.window.lockSurface();
    }

    public final void unlockSurface() throws NativeWindowException {
        this.window.unlockSurface();
    }

    public final boolean isSurfaceLockedByOtherThread() {
        return this.window.isSurfaceLockedByOtherThread();
    }

    public final boolean isSurfaceLocked() {
        return this.window.isSurfaceLocked();
    }

    public final Thread getSurfaceLockOwner() {
        return this.window.getSurfaceLockOwner();
    }

    public final boolean surfaceSwap() {
        return this.window.surfaceSwap();
    }

    public final long getWindowHandle() {
        return this.window.getWindowHandle();
    }

    public final long getSurfaceHandle() {
        return this.window.getSurfaceHandle();
    }

    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.window.getGraphicsConfiguration();
    }

    public final long getDisplayHandle() {
        return this.window.getDisplayHandle();
    }

    public final int getScreenIndex() {
        return this.window.getScreenIndex();
    }

    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.window.surfaceUpdated(object, nativeSurface, l);
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(NativeWindowVersion.getInstance());
        System.err.println(JoglVersion.getInstance());
        System.err.println((Object)NewtVersion.getInstance());
        GLProfile gLProfile = GLProfile.getDefault();
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        List list = gLDrawableFactory.getAvailableCapabilities(null);
        for (int i = 0; i < list.size(); ++i) {
            System.err.println(list.get(i));
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(128, 128);
        gLWindow.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo((GL)gL, null));
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setVisible(true);
        gLWindow.destroy();
    }

    private class SwapBuffersAction
    implements Runnable {
        private SwapBuffersAction() {
        }

        @Override
        public final void run() {
            GLWindow.this.drawable.swapBuffers();
        }
    }

    private class DisplayAction
    implements Runnable {
        private DisplayAction() {
        }

        @Override
        public final void run() {
            if (GLWindow.this.sendReshape) {
                GLWindow.this.helper.reshape((GLAutoDrawable)GLWindow.this, 0, 0, GLWindow.this.getWidth(), GLWindow.this.getHeight());
                GLWindow.this.sendReshape = false;
            }
            GLWindow.this.helper.display((GLAutoDrawable)GLWindow.this);
            GLWindow.this.fpsCounter.tickFPS();
        }
    }

    private class InitAction
    implements Runnable {
        private InitAction() {
        }

        @Override
        public final void run() {
            GLWindow.this.helper.init((GLAutoDrawable)GLWindow.this);
            GLWindow.this.resetFPSCounter();
        }
    }

    protected class GLLifecycleHook
    implements WindowImpl.LifecycleHook {
        DisposeAction disposeAction = new DisposeAction();
        private GLAnimatorControl savedAnimator = null;

        protected GLLifecycleHook() {
        }

        @Override
        public synchronized void destroyActionPreLock() {
        }

        @Override
        public synchronized void destroyActionInLock() {
            String string;
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                string = "GLWindow.destroy() " + Thread.currentThread() + ", start";
                System.err.println(string);
            }
            if (GLWindow.this.window.isNativeValid() && null != GLWindow.this.drawable && GLWindow.this.drawable.isRealized()) {
                if (null != GLWindow.this.context && GLWindow.this.context.isCreated()) {
                    try {
                        GLWindow.this.helper.invokeGL(GLWindow.this.drawable, GLWindow.this.context, (Runnable)this.disposeAction, null);
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                    GLWindow.this.context.destroy();
                }
                GLWindow.this.drawable.setRealized(false);
            }
            GLWindow.this.context = null;
            GLWindow.this.drawable = null;
            string = GLWindow.this.getAnimator();
            if (null != string) {
                string.remove((GLAutoDrawable)GLWindow.this);
            }
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.destroy() " + Thread.currentThread() + ", fin");
            }
        }

        @Override
        public synchronized void resetCounter() {
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.resetCounter() " + Thread.currentThread());
            }
            GLWindow.this.resetFPSCounter();
        }

        @Override
        public synchronized void setVisibleActionPost(boolean bl, boolean bl2) {
            Object object;
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                object = "GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", start";
                System.err.println((String)object);
            }
            if (null == GLWindow.this.context && bl && 0L != GLWindow.this.window.getWindowHandle() && 0 < GLWindow.this.getWidth() * GLWindow.this.getHeight()) {
                object = GLWindow.this.window.getWrappedWindow() != null ? NativeWindowFactory.getNativeWindow((Object)GLWindow.this.window.getWrappedWindow(), (AbstractGraphicsConfiguration)GLWindow.this.window.getGraphicsConfiguration()) : GLWindow.this.window;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)object.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
                if (null == GLWindow.this.factory) {
                    GLWindow.this.factory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
                }
                if (null == GLWindow.this.drawable) {
                    GLWindow.this.drawable = GLWindow.this.factory.createGLDrawable((NativeSurface)object);
                }
                GLWindow.this.drawable.setRealized(true);
                GLWindow.this.context = GLWindow.this.drawable.createContext(GLWindow.this.sharedContext);
                GLWindow.this.context.setContextCreationFlags(GLWindow.this.additionalCtxCreationFlags);
            }
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                object = "GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", fin";
                System.err.println((String)object);
            }
        }

        @Override
        public synchronized boolean pauseRenderingAction() {
            boolean bl = false;
            this.savedAnimator = GLWindow.this.getAnimator();
            if (null != this.savedAnimator) {
                bl = this.savedAnimator.pause();
            }
            return bl;
        }

        @Override
        public synchronized void resumeRenderingAction() {
            if (null != this.savedAnimator && this.savedAnimator.isPaused()) {
                this.savedAnimator.resume();
            }
        }

        private class DisposeAction
        implements Runnable {
            private DisposeAction() {
            }

            @Override
            public final void run() {
                GLWindow.this.helper.dispose((GLAutoDrawable)GLWindow.this);
            }
        }
    }
}

