/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceState;
import java.awt.Color;
import java.awt.Graphics;

public class SPIMUtils {
    static final int NUM_REGISTERS = 32;
    static final int NUM_BITS = 5;
    static final BitWidth _WIDTH = BitWidth.create((int)32);
    static final BitWidth _DEPTH = BitWidth.create((int)5);
    static final int BOX_HEIGHT = 10;
    static final int BOX_WIDTH = 50;
    static final int COL_WIDTH = 65;
    static final int BOX_SEP = 10;
    static final int WIDTH = 240;
    static final int HEIGHT = 260;
    static final int CLK = 0;
    static final int OP = 1;
    static final int PC = 2;
    static final int ADDR = 3;
    static final int DOUT = 4;
    static final int DIN = 5;
    static final int STR = 6;
    static final int SEL = 7;
    static final int LD = 8;
    static final int IRQ_IN = 9;
    static final int PROG_CNTR = 32;
    static final int BADVADDR = 34;
    static final int STATUS = 35;
    static final int CAUSE = 36;
    static final int EPC = 37;
    static final int E_CODE_HW = 0;
    static final int E_CODE_SYS = 8;
    static final int E_CODE_OV = 12;
    static final int KEYBOARD_IRQ = 8;
    static final Value zero = Value.createKnown((BitWidth)_WIDTH, (int)0);
    static final Value xxxx = Value.createError((BitWidth)_WIDTH);
    static final Value zzzz = Value.createUnknown((BitWidth)_WIDTH);

    private SPIMUtils() {
    }

    static int boxX(int i) {
        if (i < 16) {
            return 25;
        }
        return 100;
    }

    static Value val(InstanceState s, int pin) {
        return s.getPort(pin);
    }

    static int addr(InstanceState s, int pin) {
        return s.getPort(pin).toIntValue();
    }

    static int boxY(int i) {
        return (i %= 16) * 10 + 10;
    }

    static int cp_x(int i) {
        return 5;
    }

    static int cp_y(int i) {
        return (i - 16) * 10;
    }

    static void drawBox(Graphics g, Bounds bounds, Color color, int i) {
        g.setColor(color);
        g.drawRect(bounds.getX() + SPIMUtils.boxX(i), bounds.getY() + SPIMUtils.boxY(i), 50, 10);
        g.setColor(Color.BLACK);
    }

    static void drawCPBox(Graphics g, Bounds bounds, Color color, int i) {
        g.setColor(color);
        g.drawRect(bounds.getX() + SPIMUtils.cp_x(i) + 50, bounds.getY() + SPIMUtils.cp_y(i), 50, 10);
        g.setColor(Color.BLACK);
    }
}

