/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;

public class SPIMData
implements InstanceData,
Cloneable {
    private static final int N_REGS = 38;
    private static final int NUM_BITS = 5;
    private static final BitWidth WIDTH = BitWidth.create((int)32);
    private static final BitWidth DEPTH = BitWidth.create((int)5);
    private static final Value zero = Value.createKnown((BitWidth)WIDTH, (int)0);
    private static final Value xxxx = Value.createError((BitWidth)WIDTH);
    private static final Value zzzz = Value.createUnknown((BitWidth)WIDTH);
    private Value lastClock;
    Value[] regs;

    public static SPIMData get(InstanceState state) {
        SPIMData ret = (SPIMData)state.getData();
        if (ret == null) {
            ret = new SPIMData(null, new Value[38]);
            state.setData((InstanceData)ret);
        }
        return ret;
    }

    private SPIMData(Value lastClock, Value[] regs) {
        this.lastClock = lastClock;
        this.regs = regs;
        this.regs[0] = zero;
        this.reset(zero);
    }

    public void reset(Value val) {
        for (int i = 1; i < 38; ++i) {
            this.regs[i] = val;
        }
    }

    public SPIMData clone() {
        try {
            return (SPIMData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean updateClock(Value newClock, Object trigger) {
        Value oldClock = this.lastClock;
        this.lastClock = newClock;
        if (trigger == null || trigger == StdAttr.TRIG_RISING) {
            return oldClock == Value.FALSE && newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_FALLING) {
            return oldClock == Value.TRUE && newClock == Value.FALSE;
        }
        if (trigger == StdAttr.TRIG_HIGH) {
            return newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_LOW) {
            return newClock == Value.FALSE;
        }
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }
}

