/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import edu.cornell.cs3410.ClockState;
import edu.cornell.cs3410.ProgramAssembler;
import edu.cornell.cs3410.SPIMData;
import edu.cornell.cs3410.SPIMUtils;
import edu.cornell.cs3410.Strings;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPIM
extends InstanceFactory {
    public static Fetch fetch;
    public static Decode decode;
    public static Execute execute;
    public static Memory memory;
    public static WriteBack wb;
    public static Staller staller;
    public static ExceptionUnit exceptionUnit;
    private static ClockState clockState;
    private static final Attribute<Integer> ATTR_BUFFER;
    private static Pattern pat1;
    private static HashMap<String, InstType> m;

    public SPIM() {
        super("SPIM", Strings.getter("MIPS Core with Exception Support"));
        this.setAttributes(new Attribute[]{ATTR_BUFFER, StdAttr.EDGE_TRIGGER}, new Object[]{32, StdAttr.TRIG_RISING});
        this.setOffsetBounds(Bounds.create((int)0, (int)0, (int)240, (int)260));
        this.setIconName("SPIM.gif");
        m = new HashMap();
        this.set_support_mips_inst(m);
        clockState = new ClockState();
        fetch = new Fetch();
        decode = new Decode();
        execute = new Execute();
        memory = new Memory();
        wb = new WriteBack();
        staller = new Staller();
        exceptionUnit = new ExceptionUnit();
        Port[] ps = new Port[]{new Port(0, 240, "input", 1), new Port(20, 260, "input", 32), new Port(40, 260, "output", 32), new Port(240, 20, "output", 24), new Port(240, 40, "output", 32), new Port(240, 60, "input", 32), new Port(240, 80, "output", 1), new Port(240, 100, "output", 4), new Port(240, 120, "output", 1), new Port(80, 260, "input", 1)};
        this.setPorts(ps);
    }

    public void propagate(InstanceState state) {
        SPIMData data = SPIMData.get(state);
        int op = state.getPort(1).toIntValue();
        boolean rising_triggered = clockState.updateClock(state.getPort(0), StdAttr.TRIG_RISING);
        boolean level_triggered = clockState.updateClock(state.getPort(0), StdAttr.TRIG_LOW);
        boolean allNOPs = false;
        if (rising_triggered) {
            String line = ProgramAssembler.disassemble(op, SPIM.fetch.PC);
            line = pat1.matcher(line).replaceAll(" ");
            line.replaceAll(",", " ");
            Instruction inst = new Instruction(line);
            SPIM.p("==========================");
            SPIM.p("+++++++Rising Edge++++++++");
            SPIM.p("fetched: " + Integer.toHexString(SPIM.fetch.PC) + " " + line);
            SPIM.pf("PC      %20x%20x%20x%20x%20x\n", SPIM.fetch.PC, SPIM.decode.PC, SPIM.execute.PC, SPIM.memory.PC, SPIM.wb.PC);
            SPIM.wb.inst = SPIM.memory.inst;
            SPIM.memory.inst = SPIM.execute.inst;
            SPIM.execute.inst = SPIM.decode.inst;
            SPIM.decode.inst = SPIM.fetch.inst;
            SPIM.wb.PC = SPIM.memory.PC;
            SPIM.memory.PC = SPIM.execute.PC;
            SPIM.execute.PC = SPIM.decode.PC;
            if (!SPIM.fetch.stall) {
                SPIM.decode.PC = SPIM.fetch.PC;
            }
            staller.step(fetch, decode, execute, memory);
            fetch.step(inst, data, decode);
            decode.step(data, memory, wb, fetch, execute);
            execute.step(data, fetch, decode);
            memory.step(state);
            this.print_mips_debug_info(fetch, decode, execute, memory, wb);
            state.setPort(2, Value.createKnown((BitWidth)BitWidth.create((int)32), (int)SPIM.fetch.PC), 1);
            if (state.getPort(9).toIntValue() == 1) {
                int cause = data.regs[36].toIntValue();
                data.regs[36] = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)(cause |= 0));
                int status = data.regs[35].toIntValue();
                data.regs[35] = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)(status |= 0x100));
            }
            int status = data.regs[35].toIntValue();
            data.regs[35] = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)(status |= 0x10));
            exceptionUnit.step(fetch, decode, execute, memory, wb, state, data);
        }
        if (state.getPort(0).toIntValue() == 0) {
            SPIM.p(".....falling edge.....");
            allNOPs = SPIM.fetch.inst.opcode == 0 && SPIM.decode.inst.opcode == 0 && SPIM.execute.inst.opcode == 0 && SPIM.memory.inst.opcode == 0;
            wb.step(data, allNOPs);
        }
        if (level_triggered) {
            decode.step_level(data, memory, wb, fetch, execute);
            memory.step_level(state);
        }
    }

    public void paintInstance(InstancePainter painter) {
        String s;
        int i;
        Graphics g = painter.getGraphics();
        Bounds bounds = painter.getBounds();
        Font font = g.getFont().deriveFont(9.0f);
        SPIMData data = SPIMData.get((InstanceState)painter);
        boolean showState = painter.getShowState();
        painter.drawBounds();
        painter.drawClock(0, Direction.EAST);
        painter.drawPort(1, "OP", Direction.SOUTH);
        painter.drawPort(2, "PC", Direction.SOUTH);
        painter.drawPort(3, "ADDR", Direction.WEST);
        painter.drawPort(4, "DOUT", Direction.WEST);
        painter.drawPort(5, "DIN", Direction.WEST);
        painter.drawPort(6, "STR", Direction.WEST);
        painter.drawPort(7, "SEL", Direction.WEST);
        painter.drawPort(8, "LD", Direction.WEST);
        painter.drawPort(9, "IRQ_IN", Direction.SOUTH);
        for (i = 0; i < 32; ++i) {
            SPIMUtils.drawBox(g, bounds, Color.GRAY, i);
        }
        for (i = 0; i < 32; ++i) {
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)("$" + i), (int)(bounds.getX() + SPIMUtils.boxX(i) - 1), (int)(bounds.getY() + SPIMUtils.boxY(i) + 4), (int)1, (int)0);
        }
        if (!painter.getShowState()) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(bounds.getX() + SPIMUtils.boxX(0) + 1, bounds.getY() + SPIMUtils.boxY(0) + 1, 49, 9);
        g.setColor(Color.BLACK);
        for (i = 0; i < 32; ++i) {
            s = data.regs[i].isFullyDefined() ? data.regs[i].toHexString() : "?";
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)s, (int)(bounds.getX() + SPIMUtils.boxX(i) + 25), (int)(bounds.getY() + SPIMUtils.boxY(i) + 4), (int)0, (int)0);
        }
        g.drawRect(bounds.getX() + bounds.getWidth() / 4 * 3 + 10, bounds.getY() + 10, bounds.getWidth() / 4 - 10, bounds.getHeight() / 2);
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"CPU + RAM CNTL", (int)(bounds.getX() + bounds.getWidth() / 4 * 3), (int)(bounds.getY() + bounds.getHeight() - 40));
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"BadVAddr ", (int)(bounds.getX() + SPIMUtils.cp_x(34) + 25), (int)(bounds.getY() + SPIMUtils.cp_y(34) + 5), (int)0, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"Status ", (int)(bounds.getX() + SPIMUtils.cp_x(35) + 25), (int)(bounds.getY() + SPIMUtils.cp_y(35) + 5), (int)0, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"Cause ", (int)(bounds.getX() + SPIMUtils.cp_x(36) + 25), (int)(bounds.getY() + SPIMUtils.cp_y(36) + 5), (int)0, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"EPC ", (int)(bounds.getX() + SPIMUtils.cp_x(37) + 25), (int)(bounds.getY() + SPIMUtils.cp_y(37) + 5), (int)0, (int)0);
        for (i = 34; i < 38; ++i) {
            s = data.regs[i].isFullyDefined() ? data.regs[i].toHexString() : "?";
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)s, (int)(bounds.getX() + SPIMUtils.cp_x(i) + 75), (int)(bounds.getY() + SPIMUtils.cp_y(i) + 4), (int)0, (int)0);
            SPIMUtils.drawCPBox(g, bounds, Color.GRAY, i);
        }
    }

    private static <printabletostring> void p(printabletostring ... args) {
        for (printabletostring pts : args) {
            System.out.print(pts);
        }
        System.out.println();
    }

    private static <printabletostring> void pf(String fmt, printabletostring ... args) {
        System.out.format(fmt, args);
    }

    private void print_mips_debug_info(Fetch f, Decode d, Execute e, Memory m, WriteBack w) {
        SPIM.pf("Inst    %20s%20s%20s%20s%20s\n", f.inst, d.inst, e.inst, m.inst, w.inst);
        SPIM.pf("flush   %20b%20b%20b%20b%20b\n", f.inst.flush, d.inst.flush, e.inst.flush, m.inst.flush, w.inst.flush);
        SPIM.pf("Rs      %20d%20d%20d%20d%20d\n", f.inst.rs, d.inst.rs, e.inst.rs, m.inst.rs, w.inst.rs);
        SPIM.pf("Rt      %20d%20d%20d%20d%20d\n", f.inst.rt, d.inst.rt, e.inst.rt, m.inst.rt, w.inst.rt);
        SPIM.pf("Rd      %20d%20d%20d%20d%20d\n", f.inst.rd, d.inst.rd, e.inst.rd, m.inst.rd, w.inst.rd);
        SPIM.pf("RsV(hex)%20x%20x%20x%20x%20x\n", f.inst.rsValue, d.inst.rsValue, e.inst.rsValue, m.inst.rsValue, w.inst.rsValue);
        SPIM.pf("RtV(hex)%20x%20x%20x%20x%20x\n", f.inst.rtValue, d.inst.rtValue, e.inst.rtValue, m.inst.rtValue, w.inst.rtValue);
        SPIM.pf("RdV(hex)%20x%20x%20x%20x%20x\n", f.inst.rdValue, d.inst.rdValue, e.inst.rdValue, m.inst.rdValue, w.inst.rdValue);
        SPIM.p("..........................");
    }

    private void set_support_mips_inst(HashMap<String, InstType> m) {
        m.put("add", new InstType(0, 31, 0));
        m.put("addi", new InstType(1, 34, 0));
        m.put("addiu", new InstType(1, 35, 0));
        m.put("addu", new InstType(0, 36, 0));
        m.put("and", new InstType(0, 37, 0));
        m.put("andi", new InstType(1, 38, 0));
        m.put("b", new InstType(3, 39, 0));
        m.put("bal", new InstType(4, 40, 0));
        m.put("beq", new InstType(5, 55, 0));
        m.put("bgez", new InstType(4, 58, 0));
        m.put("bgezal", new InstType(4, 59, 0));
        m.put("bgtz", new InstType(4, 64, 0));
        m.put("blez", new InstType(4, 67, 0));
        m.put("bltz", new InstType(4, 70, 0));
        m.put("bltzal", new InstType(4, 71, 0));
        m.put("bne", new InstType(5, 76, 0));
        m.put("break", new InstType(12, 79, 0));
        m.put("div", new InstType(6, 109, 0));
        m.put("divu", new InstType(6, 112, 0));
        m.put("eret", new InstType(8, 113, 0));
        m.put("j", new InstType(3, 115, 0));
        m.put("jal", new InstType(3, 116, 0));
        m.put("jalr", new InstType(9, 117, 0));
        m.put("jr", new InstType(10, 119, 0));
        m.put("lb", new InstType(2, 121, 0));
        m.put("lbu", new InstType(2, 122, 0));
        m.put("lh", new InstType(2, 125, 0));
        m.put("lhu", new InstType(2, 126, 0));
        m.put("ll", new InstType(2, 127, 0));
        m.put("lui", new InstType(11, 129, 0));
        m.put("lw", new InstType(2, 130, 0));
        m.put("mfc0", new InstType(7, 143, 0));
        m.put("movn", new InstType(0, 152, 0));
        m.put("movz", new InstType(0, 158, 0));
        m.put("mtc0", new InstType(7, 163, 0));
        m.put("mul", new InstType(0, 169, 0));
        m.put("nop", new InstType(8, 174, 0));
        m.put("nor", new InstType(0, 175, 0));
        m.put("or", new InstType(0, 176, 0));
        m.put("ori", new InstType(1, 177, 0));
        m.put("sb", new InstType(2, 185, 0));
        m.put("sh", new InstType(2, 192, 0));
        m.put("sll", new InstType(12, 193, 0));
        m.put("sllv", new InstType(13, 194, 0));
        m.put("slt", new InstType(0, 195, 0));
        m.put("slti", new InstType(1, 196, 0));
        m.put("sltiu", new InstType(1, 197, 0));
        m.put("sltu", new InstType(0, 198, 0));
        m.put("sra", new InstType(12, 200, 0));
        m.put("srav", new InstType(13, 201, 0));
        m.put("srl", new InstType(12, 202, 0));
        m.put("srlv", new InstType(13, 203, 0));
        m.put("sub", new InstType(0, 205, 0));
        m.put("subu", new InstType(0, 207, 0));
        m.put("sw", new InstType(2, 208, 0));
        m.put("syscall", new InstType(8, 219, 0));
        m.put("teq", new InstType(6, 220, 0));
        m.put("teqi", new InstType(4, 221, 0));
        m.put("tge", new InstType(6, 222, 0));
        m.put("tgei", new InstType(4, 223, 0));
        m.put("tgeiu", new InstType(4, 224, 0));
        m.put("tgeu", new InstType(6, 225, 0));
        m.put("tlt", new InstType(6, 233, 0));
        m.put("tlti", new InstType(4, 234, 0));
        m.put("tltiu", new InstType(4, 235, 0));
        m.put("tltu", new InstType(6, 236, 0));
        m.put("tne", new InstType(6, 237, 0));
        m.put("tnei", new InstType(4, 238, 0));
        m.put("xor", new InstType(0, 243, 0));
        m.put("xori", new InstType(1, 244, 0));
    }

    private int get_inst_type(String s) {
        InstType t = m.get(s.toLowerCase());
        return t == null ? -1 : t.type;
    }

    private int get_inst_opcode(String s) {
        InstType t = m.get(s.toLowerCase());
        return t == null ? -1 : t.opcode;
    }

    private int sign_extend(int v, int bit) {
        v <<= 32 - bit;
        return v >>= 32 - bit;
    }

    static {
        ATTR_BUFFER = Attributes.forIntegerRange((String)"buflen", (StringGetter)Strings.getter("SPIMBufferLengthAttr"), (int)1, (int)256);
        pat1 = Pattern.compile("\\s*,\\s*");
    }

    private class Stage {
        protected Instruction inst;
        protected int PC;

        public Stage() {
            this.inst = new Instruction("NOP");
            this.PC = -4;
        }
    }

    private class Fetch
    extends Stage {
        public boolean stall = false;

        public Fetch() {
            this.PC = -4;
        }

        public void step(Instruction inst, SPIMData data, Decode decode) {
            if (!this.stall) {
                if (decode.branch_taken) {
                    SPIM.p(new String[]{"branch_taken!"});
                    this.PC = decode.btarget;
                } else if (decode.jump) {
                    if (SPIM.execute.inst.is_ji()) {
                        this.PC = decode.jitarget;
                        SPIM.p(new String[]{"branch to jitarget:" + Integer.toHexString(decode.jitarget)});
                    } else if (SPIM.execute.inst.is_jr()) {
                        this.PC = decode.jrtarget;
                        SPIM.p(new String[]{"branch to jrtarget:" + Integer.toHexString(decode.jrtarget)});
                    }
                } else {
                    this.PC += 4;
                    SPIM.p(new String[]{"PC increment " + Integer.toHexString(this.PC)});
                }
                if (inst.valid()) {
                    this.inst = inst;
                    inst.flush = false;
                }
            } else {
                SPIM.p(new String[]{"pc = decode pc"});
                this.PC = decode.PC;
                if (inst.valid()) {
                    this.inst = inst;
                    inst.flush = false;
                }
            }
        }
    }

    private class Decode
    extends Stage {
        private Vector<Integer> hazardList;
        private Instruction instructionSave;
        private int savePC;
        private boolean isStall;
        public boolean nop;
        public int btarget;
        public int jitarget;
        public int jrtarget;
        public boolean branch_taken;
        public boolean jump;
        private boolean rs_ex_hazard;
        private boolean rt_ex_hazard;
        private boolean rs_mem_hazard;
        private boolean rt_mem_hazard;
        private boolean rs_wb_hazard;
        private boolean rt_wb_hazard;
        private boolean ld_ex_load_use;
        private boolean ld_mem_load_use;

        public Decode() {
            this.instructionSave = new Instruction("NOP");
            this.hazardList = new Vector(3);
            this.hazardList.addElement(new Integer(0));
            this.hazardList.addElement(new Integer(0));
            this.hazardList.addElement(new Integer(0));
        }

        public void step(SPIMData data, Memory mem, WriteBack wb, Fetch fetch, Execute execute) {
            this.rs_ex_hazard = false;
            this.rt_ex_hazard = false;
            this.rs_mem_hazard = false;
            this.rt_mem_hazard = false;
            this.rs_wb_hazard = false;
            this.rt_wb_hazard = false;
            if (!execute.inst.flush && this.inst.rs == this.hazardList.elementAt(0) && this.hazardList.elementAt(0) != 0) {
                this.rs_ex_hazard = true;
            }
            if (!execute.inst.flush && this.inst.rt == this.hazardList.elementAt(0) && this.hazardList.elementAt(0) != 0) {
                this.rt_ex_hazard = true;
            }
            if (!mem.inst.flush && this.inst.rs == this.hazardList.elementAt(1) && this.hazardList.elementAt(1) != 0) {
                this.rs_mem_hazard = true;
            }
            if (!mem.inst.flush && this.inst.rt == this.hazardList.elementAt(1) && this.hazardList.elementAt(1) != 0) {
                this.rt_mem_hazard = true;
            }
            if (!wb.inst.flush && this.inst.rs == this.hazardList.elementAt(2) && this.hazardList.elementAt(2) != 0) {
                this.rs_wb_hazard = true;
            }
            if (!wb.inst.flush && this.inst.rt == this.hazardList.elementAt(2) && this.hazardList.elementAt(2) != 0) {
                this.rt_wb_hazard = true;
            }
            this.hazardList.setElementAt(this.hazardList.elementAt(1), 2);
            this.hazardList.setElementAt(this.hazardList.elementAt(0), 1);
            this.hazardList.setElementAt(new Integer(this.inst.rd), 0);
            if (fetch.stall) {
                this.instructionSave = this.inst;
                this.savePC = this.PC;
                this.isStall = true;
                this.inst = new Instruction("NOP");
                this.inst.rsValue = 0L;
                this.inst.rtValue = 0L;
                this.inst.rdValue = 0L;
            } else if (this.isStall) {
                this.isStall = false;
                this.inst = this.instructionSave;
                this.PC = this.savePC;
            }
        }

        public void step_level(SPIMData data, Memory mem, WriteBack wb, Fetch fetch, Execute execute) {
            SPIM.p(new String[]{"---step level---"});
            if (SPIM.decode.nop) {
                this.inst = new Instruction("NOP");
                this.inst.rsValue = 0L;
                this.inst.rtValue = 0L;
            }
            if (this.inst.opcode == 143) {
                switch (this.inst.rd) {
                    case 8: {
                        this.inst.rdValue = data.regs[34].toIntValue();
                        break;
                    }
                    case 12: {
                        this.inst.rdValue = data.regs[35].toIntValue();
                        break;
                    }
                    case 13: {
                        this.inst.rdValue = data.regs[36].toIntValue();
                        break;
                    }
                    case 14: {
                        this.inst.rdValue = data.regs[37].toIntValue();
                    }
                }
                return;
            }
            if (this.rs_ex_hazard) {
                this.inst.rsValue = execute.inst.rdValue;
            } else if (this.rs_mem_hazard) {
                this.inst.rsValue = mem.inst.rdValue;
                SPIM.p(new String[]{"forwarded rsV with rdValue 0x" + Long.toHexString(mem.inst.rdValue)});
            } else if (this.rs_wb_hazard) {
                this.inst.rsValue = wb.inst.rdValue;
            } else {
                Value _vrs = data.regs[this.inst.rs];
                this.inst.rsValue = _vrs.toIntValue();
                SPIM.p(new String[]{"load rsV=" + Long.toHexString(this.inst.rsValue)});
            }
            if (this.rt_ex_hazard) {
                this.inst.rtValue = execute.inst.rdValue;
            } else if (this.rt_mem_hazard) {
                this.inst.rtValue = mem.inst.rdValue;
            } else if (this.rt_wb_hazard) {
                this.inst.rtValue = wb.inst.rdValue;
            } else {
                if (this.inst.is_immediate()) {
                    this.inst.rtValue = this.inst.immediate;
                } else {
                    Value _vrt = data.regs[this.inst.rt];
                    this.inst.rtValue = _vrt.toIntValue();
                }
                SPIM.p(new String[]{"load rtV=" + Long.toHexString(this.inst.rtValue)});
            }
            Value _vrd = data.regs[this.inst.rd];
            this.inst.rdValue = _vrd.toIntValue();
            SPIM.p(new String[]{"hazard: rs - ex, mem, wb: " + this.rs_ex_hazard + " " + this.rs_mem_hazard + " " + this.rs_wb_hazard});
            SPIM.p(new String[]{"hazard: rt - ex, mem, wb: " + this.rt_ex_hazard + " " + this.rt_mem_hazard + " " + this.rt_wb_hazard});
            this.branch_calc();
            this.jump_calc();
        }

        private void branch_calc() {
            int offset = SPIM.this.sign_extend(this.inst.immediate, 18);
            this.btarget = this.PC + offset;
            switch (this.inst.opcode) {
                case 39: {
                    this.branch_taken = true;
                    break;
                }
                case 40: {
                    this.branch_taken = true;
                    this.inst.rd = 31;
                    this.inst.rdValue = this.PC + 8;
                    break;
                }
                case 55: {
                    this.branch_taken = this.inst.rsValue == this.inst.rtValue;
                    break;
                }
                case 58: {
                    this.branch_taken = this.inst.rsValue >= 0L;
                    break;
                }
                case 64: {
                    this.branch_taken = this.inst.rsValue > 0L;
                    break;
                }
                case 67: {
                    this.branch_taken = this.inst.rsValue <= 0L;
                    break;
                }
                case 70: {
                    this.branch_taken = this.inst.rsValue < 0L;
                    break;
                }
                case 76: {
                    this.branch_taken = this.inst.rsValue != this.inst.rtValue;
                    break;
                }
                default: {
                    this.branch_taken = false;
                    this.btarget = 0;
                }
            }
            SPIM.p(new String[]{"branch_taken: " + this.branch_taken + " " + Integer.toHexString(this.btarget)});
        }

        private void jump_calc() {
            switch (this.inst.opcode) {
                case 115: {
                    this.jitarget = this.PC & 0xF0000000 | this.inst.immediate;
                    this.jump = true;
                    SPIM.p(new String[]{"jitarget: " + Integer.toHexString(this.jitarget)});
                    break;
                }
                case 116: {
                    this.jitarget = this.PC & 0xF0000000 | this.inst.immediate << 2;
                    this.inst.rd = 31;
                    this.inst.rdValue = this.PC + 8;
                    this.jump = true;
                    SPIM.p(new String[]{"jitarget: " + Integer.toHexString(this.jitarget)});
                    break;
                }
                case 117: {
                    this.jrtarget = (int)(this.inst.rsValue & 0xFFFFFFFFL);
                    this.inst.rdValue = this.PC + 8;
                    this.jump = true;
                    SPIM.p(new String[]{"jrtarget: " + Integer.toHexString(this.jrtarget)});
                    break;
                }
                case 119: {
                    this.jrtarget = (int)(this.inst.rsValue & 0xFFFFFFFFL);
                    this.jump = true;
                    SPIM.p(new String[]{"jrtarget: " + Integer.toHexString(this.jrtarget)});
                    break;
                }
                default: {
                    this.jump = false;
                    this.jitarget = 0;
                    this.jrtarget = 0;
                }
            }
        }
    }

    private class Execute
    extends Stage {
        public void step(SPIMData data, Fetch fetch, Decode decode) {
            switch (this.inst.opcode) {
                case 31: {
                    this.inst.rdValue = this.inst.rsValue + this.inst.rtValue;
                    break;
                }
                case 34: {
                    this.inst.immediate <<= 16;
                    this.inst.immediate >>= 16;
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue + (long)this.inst.immediate;
                    break;
                }
                case 35: {
                    this.inst.immediate <<= 16;
                    this.inst.immediate >>= 16;
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue + (long)this.inst.immediate;
                    break;
                }
                case 36: {
                    this.inst.rdValue = this.inst.rsValue + this.inst.rtValue;
                    break;
                }
                case 37: {
                    this.inst.rdValue = this.inst.rsValue & this.inst.rtValue;
                    break;
                }
                case 38: {
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue & (long)this.inst.immediate;
                    break;
                }
                case 39: {
                    break;
                }
                case 40: {
                    break;
                }
                case 55: {
                    break;
                }
                case 59: {
                    break;
                }
                case 64: {
                    break;
                }
                case 67: {
                    break;
                }
                case 70: {
                    break;
                }
                case 71: {
                    break;
                }
                case 76: {
                    fetch.inst.flush = true;
                    decode.inst.flush = false;
                    break;
                }
                case 79: {
                    break;
                }
                case 95: {
                    break;
                }
                case 99: {
                    break;
                }
                case 103: {
                    break;
                }
                case 109: {
                    this.inst.rdValue = (this.inst.rsValue & 0xFFL) / (this.inst.rtValue & 0xFFL);
                    break;
                }
                case 112: {
                    this.inst.rdValue = (this.inst.rsValue & 0xFFL) / (this.inst.rtValue & 0xFFL);
                    break;
                }
                case 113: {
                    fetch.PC = data.regs[37].toIntValue();
                    fetch.inst.flush = true;
                    decode.inst.flush = true;
                    break;
                }
                case 115: {
                    fetch.PC = (int)((long)this.inst.immediate & 0xFFFFFFFFL);
                    fetch.inst.flush = true;
                    decode.inst.flush = false;
                    break;
                }
                case 116: {
                    this.inst.rd = 31;
                    this.inst.rdValue = this.PC + 8;
                    fetch.PC = (int)((long)this.inst.immediate & 0xFFFFFFFFL);
                    fetch.inst.flush = true;
                    decode.inst.flush = false;
                    break;
                }
                case 117: {
                    this.inst.rdValue = this.PC + 8;
                    fetch.PC = (int)(this.inst.rsValue & 0xFFFFFFFFL);
                    fetch.inst.flush = true;
                    decode.inst.flush = false;
                    break;
                }
                case 119: {
                    fetch.PC = (int)(this.inst.rsValue & 0xFFFFFFFFL);
                    fetch.inst.flush = true;
                    decode.inst.flush = false;
                    break;
                }
                case 121: {
                    break;
                }
                case 122: {
                    break;
                }
                case 125: {
                    break;
                }
                case 126: {
                    break;
                }
                case 127: {
                    break;
                }
                case 129: {
                    this.inst.rdValue = this.inst.rtValue = (long)(this.inst.immediate << 16);
                    break;
                }
                case 130: {
                    break;
                }
                case 143: {
                    SPIM.p(new String[]{"handle MFC0"});
                    break;
                }
                case 152: {
                    if (this.inst.rtValue == 0L) break;
                    this.inst.rdValue = this.inst.rsValue;
                    break;
                }
                case 158: {
                    if (this.inst.rtValue == 0L) {
                        this.inst.rdValue = this.inst.rsValue;
                    }
                    this.inst.rdValue = this.inst.rdValue;
                    break;
                }
                case 163: {
                    break;
                }
                case 169: {
                    this.inst.rdValue = (this.inst.rsValue & 0xFFL) * (this.inst.rtValue & 0xFFL);
                    break;
                }
                case 174: {
                    break;
                }
                case 175: {
                    this.inst.rdValue = (this.inst.rsValue | this.inst.rtValue) ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 176: {
                    this.inst.rdValue = this.inst.rsValue | this.inst.rtValue;
                    break;
                }
                case 177: {
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue | (long)this.inst.immediate;
                    break;
                }
                case 185: {
                    break;
                }
                case 192: {
                    break;
                }
                case 193: {
                    this.inst.rdValue = this.inst.rtValue << this.inst.immediate;
                    break;
                }
                case 194: {
                    this.inst.rdValue = this.inst.rtValue << (int)(this.inst.rsValue & 0x1FL);
                    break;
                }
                case 195: {
                    this.inst.rdValue = this.inst.rsValue < this.inst.rtValue ? 1L : 0L;
                    break;
                }
                case 196: {
                    this.inst.immediate <<= 16;
                    this.inst.immediate >>= 16;
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue < (long)this.inst.immediate ? 1L : 0L;
                    break;
                }
                case 197: {
                    this.inst.immediate <<= 16;
                    this.inst.immediate >>= 16;
                    this.inst.rdValue = this.inst.rtValue = (this.inst.rsValue & 0xFFFFFFFFL) < ((long)this.inst.immediate & 0xFFFFFFFFL) ? 1L : 0L;
                    break;
                }
                case 198: {
                    this.inst.rdValue = (this.inst.rsValue & 0xFFFFFFFFL) < (this.inst.rtValue & 0xFFFFFFFFL) ? 1L : 0L;
                    break;
                }
                case 200: {
                    this.inst.rdValue = this.inst.rtValue >> this.inst.immediate;
                    break;
                }
                case 201: {
                    this.inst.rdValue = this.inst.rtValue >> (int)(this.inst.rsValue & 0x1FL);
                    break;
                }
                case 202: {
                    this.inst.rtValue <<= 32;
                    this.inst.rtValue >>>= this.inst.immediate;
                    this.inst.rtValue >>= 32;
                    this.inst.rdValue = this.inst.rtValue;
                    break;
                }
                case 203: {
                    this.inst.rdValue = (this.inst.rtValue & 0xFFFFFFFFL) >>> (int)(this.inst.rsValue & 0x1FL);
                    break;
                }
                case 205: {
                    this.inst.rdValue = this.inst.rsValue - this.inst.rtValue;
                    break;
                }
                case 207: {
                    this.inst.rdValue = this.inst.rsValue - this.inst.rtValue;
                    break;
                }
                case 208: {
                    this.inst.rdValue = this.inst.rtValue;
                    break;
                }
                case 219: {
                    break;
                }
                case 220: {
                    break;
                }
                case 221: {
                    break;
                }
                case 222: {
                    break;
                }
                case 223: {
                    break;
                }
                case 224: {
                    break;
                }
                case 225: {
                    break;
                }
                case 233: {
                    break;
                }
                case 234: {
                    break;
                }
                case 235: {
                    break;
                }
                case 236: {
                    break;
                }
                case 237: {
                    break;
                }
                case 238: {
                    break;
                }
                case 243: {
                    this.inst.rdValue = this.inst.rsValue ^ this.inst.rtValue;
                    break;
                }
                case 244: {
                    this.inst.rdValue = this.inst.rtValue = this.inst.rsValue ^ (long)this.inst.immediate;
                }
            }
        }
    }

    private class Memory
    extends Stage {
        private int memAddr = -1;

        public void step(InstanceState state) {
            int sel = 15;
            boolean str = false;
            boolean ld = false;
            long val_to_mem = 0L;
            if (this.inst.flush) {
                this.inst.wbFlush = true;
                return;
            }
            this.inst.wbFlush = false;
            if (this.is_mem_write()) {
                this.memAddr = (int)((this.inst.rsValue & 0xFFFFFFFFL) + (long)this.inst.immediate);
                if (this.is_byte_access()) {
                    SPIM.p(new String[]{"byte access"});
                    val_to_mem = (this.inst.rtValue & 0xFFL) << 8 * (this.memAddr & 3);
                    sel = 1 << (this.memAddr & 3);
                } else if (this.is_half_word_access()) {
                    SPIM.p(new String[]{"half word access"});
                    val_to_mem = (this.inst.rtValue & 0xFFFFL) << 16 * (this.memAddr & 3);
                    sel = 3 << (this.memAddr & 3);
                } else {
                    SPIM.p(new String[]{"word access"});
                    val_to_mem = this.inst.rtValue & 0xFFFFFFFFL;
                    sel = 15;
                }
                SPIM.p(new String[]{"tomem: " + Long.toHexString(val_to_mem)});
                if (this.is_byte_access()) {
                    this.memAddr >>= 2;
                } else if (this.is_half_word_access()) {
                    this.memAddr >>= 1;
                }
                state.setPort(3, Value.createKnown((BitWidth)BitWidth.create((int)24), (int)this.memAddr), 1);
                state.setPort(4, Value.createKnown((BitWidth)BitWidth.create((int)32), (int)((int)val_to_mem)), 1);
                state.setPort(6, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 20);
                state.setPort(8, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 20);
                state.setPort(7, Value.createKnown((BitWidth)BitWidth.create((int)4), (int)sel), 10);
            } else if (this.is_mem_read()) {
                sel = 15;
                SPIM.p(new String[]{"read memory!"});
                if (this.is_byte_access()) {
                    this.memAddr = (int)(this.inst.rsValue + (((long)this.inst.immediate & 0xFFFFFFFCL) << 48 >> 48));
                } else if (this.is_half_word_access()) {
                    this.memAddr = (int)(this.inst.rsValue + (((long)this.inst.immediate & 0xFFFFFFFEL) << 48 >> 48));
                } else {
                    this.memAddr = (int)(this.inst.rsValue + (long)(this.inst.immediate << 48 >> 48));
                    SPIM.p(new String[]{"word access: " + Integer.toHexString(this.memAddr)});
                }
                state.setPort(3, Value.createKnown((BitWidth)BitWidth.create((int)24), (int)this.memAddr), 1);
                state.setPort(6, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 1);
                state.setPort(8, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 1);
                state.setPort(7, Value.createKnown((BitWidth)BitWidth.create((int)4), (int)sel), 1);
            } else {
                state.setPort(6, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
                state.setPort(8, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
                state.setPort(7, Value.createKnown((BitWidth)BitWidth.create((int)4), (int)0), 0);
            }
        }

        public void step_level(InstanceState state) {
            boolean forwardflag = false;
            long val_from_mem = 0L;
            if ((long)this.memAddr == SPIM.wb.inst.rsValue && SPIM.wb.inst.opcode == 208) {
                forwardflag = true;
            }
            if (this.is_mem_read()) {
                val_from_mem = forwardflag ? SPIM.wb.inst.rtValue : (long)state.getPort(5).toIntValue();
                if (this.is_byte_access()) {
                    val_from_mem &= (long)(255 << 8 * (this.inst.immediate & 3));
                    if (this.is_zero_extend()) {
                        val_from_mem >>= 8 * (this.inst.immediate & 3);
                    } else {
                        val_from_mem <<= 56 - 8 * (this.inst.immediate & 3);
                        val_from_mem >>= 56 - 8 * (this.inst.immediate & 3);
                    }
                } else if (this.is_half_word_access()) {
                    val_from_mem &= (long)(65535 << 16 * (this.inst.immediate & 3));
                    if (this.is_zero_extend()) {
                        val_from_mem >>= 16 * ((this.inst.immediate & 3) >> 1);
                    } else {
                        val_from_mem <<= 48 - 16 * ((this.inst.immediate & 3) >> 1);
                        val_from_mem >>= 48 - 16 * ((this.inst.immediate & 3) >> 1);
                    }
                }
                this.inst.rtValue = val_from_mem;
            }
        }

        private boolean is_mem_write() {
            return this.inst.opcode == 185 || this.inst.opcode == 192 || this.inst.opcode == 208;
        }

        private boolean is_mem_read() {
            return this.inst.opcode == 121 || this.inst.opcode == 122 || this.inst.opcode == 125 || this.inst.opcode == 126 || this.inst.opcode == 130;
        }

        private boolean is_byte_access() {
            return this.inst.opcode == 121 || this.inst.opcode == 122 || this.inst.opcode == 185;
        }

        private boolean is_half_word_access() {
            return this.inst.opcode == 125 || this.inst.opcode == 126 || this.inst.opcode == 192;
        }

        private boolean is_zero_extend() {
            return this.inst.opcode == 122 || this.inst.opcode == 126;
        }
    }

    private class WriteBack
    extends Stage {
        private boolean done = false;

        public void step(SPIMData data, boolean allNOPs) {
            block0 : switch (this.inst.optype) {
                case 0: 
                case 3: 
                case 9: 
                case 12: 
                case 13: {
                    if (this.inst.rd == 0 || this.inst.flush) break;
                    if (this.inst.rd < 32) {
                        Value v;
                        data.regs[this.inst.rd] = v = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)((int)this.inst.rdValue));
                        SPIM.p(new String[]{"Reg[" + this.inst.rd + "]=" + Long.toHexString(this.inst.rdValue & 0xFFFFFFFFL)});
                        break;
                    }
                    throw new IllegalArgumentException("Write address invalid: email hwang@cs and tell him!");
                }
                case 1: 
                case 2: 
                case 11: {
                    Value v;
                    if (this.inst.rt == 0 || this.inst.flush || this.inst.rt >= 32) break;
                    data.regs[this.inst.rt] = v = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)((int)this.inst.rtValue));
                    SPIM.p(new String[]{"Reg[" + this.inst.rt + "]=" + Long.toHexString(this.inst.rtValue & 0xFFFFFFFFL)});
                    break;
                }
                case 7: {
                    Value v;
                    if (this.inst.opcode == 163) {
                        if (this.inst.rt == 0 || this.inst.flush) break;
                        Value v2 = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)((int)this.inst.rtValue));
                        switch (this.inst.rd) {
                            case 8: {
                                data.regs[34] = v2;
                                break block0;
                            }
                            case 12: {
                                data.regs[35] = v2;
                                break block0;
                            }
                            case 13: {
                                data.regs[36] = v2;
                                break block0;
                            }
                        }
                        SPIM.p(new String[]{"nothing"});
                        break;
                    }
                    if (this.inst.opcode != 143 || this.inst.rd == 0 || this.inst.flush) break;
                    data.regs[this.inst.rt] = v = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)((int)this.inst.rdValue));
                    break;
                }
            }
        }
    }

    private class ExceptionUnit {
        private boolean handle_exception = false;

        public void step(Fetch f, Decode d, Execute e, Memory m, WriteBack w, InstanceState state, SPIMData data) {
            int status = data.regs[35].toIntValue();
            int irq_enable = status &= 1;
            this.handle_exception = irq_enable > 0 ? state.getPort(9).toIntValue() == 1 : false;
            if (this.handle_exception) {
                data.regs[37] = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)f.PC);
                SPIM.p(new String[]{"Status =" + Integer.toHexString(status)});
                SPIM.p(new String[]{"Status =" + Integer.toHexString(status &= 0xFFFFFFFE)});
                data.regs[35] = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)status);
                f.PC = 0x800000;
            }
        }
    }

    private class Staller {
        private boolean _id_ex_load_use = false;
        private boolean id_ex_load_use = false;
        private boolean id_mem_load_use = false;

        public void step(Fetch fetch, Decode decode, Execute execute, Memory mem) {
            this.id_ex_load_use = this._id_ex_load_use;
            if ((decode.inst.rs == execute.inst.rd || decode.inst.rt == execute.inst.rd && !decode.inst.is_immediate()) && execute.inst.is_load() && execute.inst.rd != 0) {
                this._id_ex_load_use = true;
                SPIM.p(new String[]{"staller: id_ex_load_use TRUE!"});
            } else {
                this._id_ex_load_use = false;
            }
            this.id_mem_load_use = (decode.inst.rs == mem.inst.rd || decode.inst.rt == mem.inst.rd && !decode.inst.is_immediate()) && mem.inst.is_load() && mem.inst.rd != 0;
            if (this.id_ex_load_use || this.id_mem_load_use || this._id_ex_load_use) {
                SPIM.p(new String[]{"staller:" + this.id_ex_load_use + " " + this._id_ex_load_use + " " + this.id_mem_load_use});
                fetch.stall = true;
                decode.nop = true;
            } else {
                fetch.stall = false;
                decode.nop = false;
            }
        }
    }

    private class Instruction {
        public int opcode;
        public int optype;
        public int rs;
        public int rt;
        public int rd;
        public int immediate;
        public long rdValue;
        public long rsValue;
        public long rtValue;
        public String instructionString;
        private boolean ok;
        public boolean flush;
        public boolean wbFlush;
        public boolean forwardRsFlag;
        public boolean forwardRtFlag;
        private boolean isImmediateInstruction;

        Instruction(String temp) {
            block25: {
                StringTokenizer tokens = new StringTokenizer(temp, " ");
                String op = "";
                String t1 = "";
                String t2 = "";
                String t3 = "";
                this.rdValue = 0L;
                this.rsValue = 0L;
                this.rtValue = 0L;
                this.isImmediateInstruction = false;
                this.ok = true;
                this.instructionString = temp;
                this.flush = false;
                this.forwardRsFlag = false;
                this.forwardRtFlag = false;
                if (temp.equals("NOP")) {
                    this.instructionString = "NOP";
                    this.rd = 0;
                    this.rt = 0;
                    this.rs = 0;
                    this.immediate = 0;
                    this.opcode = 0;
                    return;
                }
                try {
                    op = tokens.nextToken();
                    this.optype = SPIM.this.get_inst_type(op);
                    if (tokens.hasMoreTokens()) {
                        t1 = tokens.nextToken();
                    }
                    if (tokens.hasMoreTokens()) {
                        t2 = tokens.nextToken();
                    }
                    if (tokens.hasMoreTokens()) {
                        t3 = tokens.nextToken();
                    }
                    switch (this.optype) {
                        case 0: {
                            this.rd = Integer.parseInt(t1.substring(1));
                            this.rs = Integer.parseInt(t2.substring(1));
                            this.rt = Integer.parseInt(t3.substring(1));
                            break;
                        }
                        case 1: {
                            this.rt = Integer.parseInt(t1.substring(1));
                            this.rs = Integer.parseInt(t2.substring(1));
                            this.rd = this.rt;
                            this.isImmediateInstruction = true;
                            this.immediate = Integer.parseInt(t3.substring(2), 16);
                            break;
                        }
                        case 2: {
                            this.rt = Integer.parseInt(t1.substring(1));
                            this.rs = Integer.parseInt(t2.substring(t2.indexOf("$") + 1, t2.indexOf(")")));
                            this.immediate = Integer.parseInt(t2.substring(2, t2.indexOf("(")), 16);
                            this.rd = this.rt;
                            break;
                        }
                        case 3: {
                            this.immediate = Integer.parseInt(t1.substring(2), 16);
                            break;
                        }
                        case 4: {
                            this.rs = Integer.parseInt(t1.substring(1));
                            this.immediate = Integer.parseInt(t2.substring(2), 16);
                            this.opcode = SPIM.this.get_inst_opcode(op);
                            break;
                        }
                        case 5: {
                            this.rt = Integer.parseInt(t1.substring(1));
                            this.rs = Integer.parseInt(t2.substring(1));
                            this.immediate = Integer.parseInt(t3.substring(2), 16);
                            break;
                        }
                        case 6: {
                            this.rs = Integer.parseInt(t1.substring(1));
                            this.rt = Integer.parseInt(t2.substring(1));
                            break;
                        }
                        case 7: {
                            this.rt = Integer.parseInt(t1.substring(1));
                            this.rd = Integer.parseInt(t2.substring(1));
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            if (t2 != "") {
                                this.rd = Integer.parseInt(t1.substring(1));
                                this.rs = Integer.parseInt(t2.substring(1));
                                break;
                            }
                            this.rs = Integer.parseInt(t1.substring(1));
                            this.rd = 31;
                            break;
                        }
                        case 10: {
                            this.rs = Integer.parseInt(t1.substring(1));
                            break;
                        }
                        case 11: {
                            this.rd = this.rt = Integer.parseInt(t1.substring(1));
                            this.isImmediateInstruction = true;
                            this.immediate = Integer.parseInt(t2.substring(2), 16);
                            break;
                        }
                        case 12: {
                            this.rd = Integer.parseInt(t1.substring(1));
                            this.rt = Integer.parseInt(t2.substring(1));
                            this.immediate = Integer.parseInt(t3);
                            break;
                        }
                        case 13: {
                            this.rd = Integer.parseInt(t1.substring(1));
                            this.rt = Integer.parseInt(t2.substring(1));
                            this.rs = Integer.parseInt(t3.substring(1));
                            break;
                        }
                        default: {
                            this.ok = false;
                            break block25;
                        }
                    }
                    this.opcode = SPIM.this.get_inst_opcode(op);
                }
                catch (NumberFormatException e) {
                    System.out.println(e.toString());
                    this.ok = false;
                }
                catch (NoSuchElementException e) {
                    System.out.println(e.toString());
                    this.ok = false;
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.out.println(e.toString());
                    this.ok = false;
                }
            }
        }

        public boolean valid() {
            return this.ok;
        }

        public boolean is_immediate() {
            return this.isImmediateInstruction;
        }

        public boolean is_load() {
            return this.opcode == 121 || this.opcode == 122 || this.opcode == 125 || this.opcode == 126 || this.opcode == 130;
        }

        public boolean is_ji() {
            return this.opcode == 115 || this.opcode == 116;
        }

        public boolean is_jr() {
            return this.opcode == 117 || this.opcode == 119;
        }

        public String toString() {
            return this.instructionString;
        }
    }

    private class InstType {
        public int type;
        public int opcode;
        public int supported;

        InstType(int t, int n, int s) {
            this.type = t;
            this.opcode = n;
            this.supported = s;
        }
    }
}

