/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.hex.HexModel;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs3410.ClockState;
import edu.cornell.cs3410.Mem;
import edu.cornell.cs3410.MemContents;
import edu.cornell.cs3410.MemState;
import edu.cornell.cs3410.SimpleStringGetter;
import edu.cornell.cs3410.Strings;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamIO
extends Mem {
    private static final int DATA_ATTR = 32;
    private static final BitWidth dataBits = BitWidth.create((int)32);
    private static Attribute<?>[] ATTRIBUTES = new Attribute[]{Mem.ADDR_ATTR};
    private static Object[] DEFAULTS = new Object[]{BitWidth.create((int)20)};
    private static final int OE = 3;
    private static final int CLR = 4;
    private static final int CLK = 5;
    private static final int WE = 6;
    private static final int DIN = 7;
    private static final int TTY = 8;
    private static final int TE = 9;
    private static final int TCLR = 10;
    private static final int KEYB = 11;
    private static final int KAVAIL = 12;
    private static final int KREAD = 13;
    private static final int IRQ_OUT = 14;
    private static int cntr = 0;
    private static Object[][] logOptions = new Object[9][];
    static final Value[] vmask = new Value[]{Value.createUnknown((BitWidth)BitWidth.create((int)32)), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(16, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)16)).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(16, Value.UNKNOWN).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)24), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)24)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(16, Value.FALSE).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)16)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(16, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)32), (int)0)};

    public RamIO() {
        super("MIPS RAM and IO", new SimpleStringGetter("MIPS RAM and IO Controller"), 3);
        this.setInstanceLogger(Logger.class);
        this.setOffsetBounds(Bounds.create((int)-140, (int)-40, (int)240, (int)180));
    }

    private static <printabletostring> void p(printabletostring ... args) {
        for (printabletostring pts : args) {
            System.out.print(pts);
        }
        System.out.println();
    }

    private static <printabletostring> void pf(String format, printabletostring ... args) {
        System.out.format(format, args);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        super.configureNewInstance(instance);
        instance.addAttributeListener();
    }

    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        super.instanceAttributeChanged(instance, attr);
        this.configurePorts(instance);
    }

    @Override
    void configurePorts(Instance instance) {
        boolean asynch = false;
        boolean separate = true;
        int portCount = 3;
        portCount = asynch ? (portCount += 9) : (separate ? (portCount += 12) : (portCount += 10));
        Port[] ps = new Port[portCount];
        ps[1] = new Port(-140, -20, "input", ADDR_ATTR);
        ps[1].setToolTip(Strings.getter("memAddrTip"));
        ps[0] = new Port(-140, 20, "inout", 32);
        ps[0].setToolTip(Strings.getter("memDataTip"));
        ps[2] = new Port(-140, 60, "input", 4);
        ps[2].setToolTip((StringGetter)new SimpleStringGetter("Byte selects: each 0 disables access to one byte of the addressed word."));
        ps[3] = new Port(-140, 80, "input", 1);
        ps[3].setToolTip(Strings.getter("ramOETip"));
        ps[4] = new Port(-140, 100, "input", 1);
        ps[4].setToolTip(Strings.getter("ramClrTip"));
        if (!asynch) {
            ps[5] = new Port(-140, 120, "input", 1);
            ps[5].setToolTip(Strings.getter("ramClkTip"));
        }
        if (separate) {
            ps[7] = new Port(-140, 0, "input", 32);
            ps[6] = new Port(-140, 40, "input", 1);
            ps[6].setToolTip(Strings.getter("ramWETip"));
            ps[7].setToolTip(Strings.getter("ramInTip"));
        } else {
            ps[0].setToolTip(Strings.getter("ramBusTip"));
        }
        ps[8] = new Port(100, 0, "output", 7);
        ps[9] = new Port(100, 20, "output", 1);
        ps[10] = new Port(100, 40, "output", 1);
        ps[11] = new Port(100, 80, "input", 7);
        ps[12] = new Port(100, 100, "input", 1);
        ps[13] = new Port(100, 120, "output", 1);
        ps[14] = new Port(-100, 140, "output", 1);
        instance.setPorts(ps);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return AttributeSets.fixedSet(ATTRIBUTES, (Object[])DEFAULTS);
    }

    @Override
    MemState getState(InstanceState state) {
        BitWidth addrBits = (BitWidth)state.getAttributeValue(ADDR_ATTR);
        RamState myState = (RamState)state.getData();
        if (myState == null) {
            MemContents contents = MemContents.create(addrBits.getWidth(), dataBits.getWidth());
            Instance instance = state.getInstance();
            myState = new RamState(instance, contents, new Mem.MemListener(instance));
            state.setData((InstanceData)myState);
        } else {
            myState.setRam(state.getInstance());
        }
        return myState;
    }

    @Override
    MemState getState(Instance instance, CircuitState state) {
        BitWidth addrBits = (BitWidth)instance.getAttributeValue(ADDR_ATTR);
        RamState myState = (RamState)instance.getData(state);
        if (myState == null) {
            MemContents contents = MemContents.create(addrBits.getWidth(), dataBits.getWidth());
            myState = new RamState(instance, contents, new Mem.MemListener(instance));
            instance.setData(state, (InstanceData)myState);
        } else {
            myState.setRam(instance);
        }
        return myState;
    }

    @Override
    HexFrame getHexFrame(Project proj, Instance instance, CircuitState circState) {
        RamState state = (RamState)this.getState(instance, circState);
        return state.getHexFrame(proj);
    }

    @Override
    public void propagate(InstanceState state) {
        boolean shouldClear;
        RamState myState = (RamState)this.getState(state);
        boolean asynch = false;
        boolean separate = true;
        Value addrValue = state.getPort(1);
        Value maskValue = state.getPort(2);
        boolean triggered = asynch || myState.setClock(state.getPort(5), StdAttr.TRIG_RISING);
        boolean outputEnabled = state.getPort(3) != Value.FALSE;
        boolean bl = shouldClear = state.getPort(4) == Value.TRUE;
        if (shouldClear) {
            myState.getContents().clear();
        }
        if (triggered) {
            RamIO.p("----read------");
            int rcr = 0xFF0000;
            int rdr = 0xFF0004;
            int _rcr = myState.getContents().get(rcr);
            RamIO.p("rcr value=" + Integer.toHexString(_rcr));
            int _rdr = myState.getContents().get(rdr);
            RamIO.p("rdr value=" + Integer.toHexString(_rdr));
            Value ka_value = state.getPort(12);
            Value irq_pending = state.getPort(14);
            if (ka_value.toIntValue() == 1 && irq_pending.toIntValue() != 1) {
                Value kv = state.getPort(11);
                myState.getContents().set((long)rdr, kv.toIntValue());
                state.setPort(13, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 0);
                state.setPort(14, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 0);
            } else {
                state.setPort(13, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
            }
            if (state.getPort(3).toIntValue() == 1 && state.getPort(1).toIntValue() == 0xFF0004) {
                state.setPort(14, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
            }
        }
        if (triggered) {
            RamIO.p("----write-----");
            int tcr = 0xFF0008;
            int tdr = 0xFF000C;
            int _tcr = myState.getContents().get(tcr);
            int _tdr = myState.getContents().get(tdr);
            RamIO.p("tcr value = " + Integer.toHexString(_tcr));
            RamIO.p("tdr value = " + Integer.toHexString(_tdr));
            if ((_tcr & 1) > 0) {
                if ((_tdr & 0xFF) > 0) {
                    state.setPort(8, Value.createKnown((BitWidth)BitWidth.create((int)7), (int)_tdr), 0);
                    state.setPort(9, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 0);
                    _tcr ^= 1;
                    cntr = 0;
                }
            } else {
                if (cntr > 20) {
                    myState.getContents().set((long)tcr, _tcr |= 1);
                } else {
                    ++cntr;
                }
                state.setPort(9, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
            }
            if ((_tcr & 4) > 0) {
                state.setPort(10, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)1), 0);
                myState.getContents().set((long)tcr, _tcr ^= 4);
            } else {
                state.setPort(10, Value.createKnown((BitWidth)BitWidth.create((int)1), (int)0), 0);
            }
        }
        int mask = 0;
        int bmask = 0;
        if (maskValue.get(0) != Value.FALSE) {
            mask |= 1;
            bmask |= 0xFF;
        }
        if (maskValue.get(1) != Value.FALSE) {
            mask |= 2;
            bmask |= 0xFF00;
        }
        if (maskValue.get(2) != Value.FALSE) {
            mask |= 4;
            bmask |= 0xFF0000;
        }
        if (maskValue.get(3) != Value.FALSE) {
            mask |= 8;
            bmask |= 0xFF000000;
        }
        if (mask == 0) {
            myState.setCurrent(-1L, 0);
            state.setPort(0, Value.createUnknown((BitWidth)dataBits), 10);
            return;
        }
        int addr = addrValue.toIntValue();
        if (!addrValue.isFullyDefined() || addr < 0) {
            return;
        }
        if ((long)addr != myState.getCurrent()) {
            myState.setCurrent(addr, mask);
            myState.scrollToShow(addr);
        } else if (mask != myState.getCurrentMask()) {
            myState.setCurrent(addr, mask);
        }
        if (!shouldClear && triggered) {
            boolean shouldStore;
            if (separate) {
                shouldStore = state.getPort(6) != Value.FALSE;
            } else {
                boolean bl2 = shouldStore = !outputEnabled;
            }
            if (shouldStore) {
                Value dataValue = state.getPort(separate ? 7 : 0);
                int newVal = dataValue.toIntValue();
                int oldVal = myState.getContents().get(addr);
                newVal = newVal & bmask | oldVal & ~bmask;
                myState.getContents().set((long)addr, newVal);
            }
        }
        if (outputEnabled) {
            int val = myState.getContents().get(addr);
            Value[] vals = vmask[mask].getAll();
            for (int i = 0; i < 4; ++i) {
                if ((mask & 1 << i) == 0) continue;
                int j = 0;
                int pos = i * 8;
                while (j < 8) {
                    if ((val & 1 << pos) != 0) {
                        vals[pos] = Value.TRUE;
                    }
                    ++j;
                    ++pos;
                }
            }
            state.setPort(0, Value.create((Value[])vals), 10);
        } else {
            state.setPort(0, vmask[0], 10);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        painter.drawBounds();
        if (painter.getShowState()) {
            MemState state = this.getState((InstanceState)painter);
            state.paint(painter.getGraphics(), bds.getX(), bds.getY());
        } else {
            BitWidth addr = (BitWidth)painter.getAttributeValue(ADDR_ATTR);
            int addrBits = addr.getWidth();
            int bytes = 1 << addrBits + 2;
            String label = addrBits >= 30 ? StringUtil.format((String)Strings.get("ramGigabyteLabel"), (String)("" + (bytes >>> 30))) : (addrBits >= 20 ? StringUtil.format((String)Strings.get("ramMegabyteLabel"), (String)("" + (bytes >> 20))) : (addrBits >= 10 ? StringUtil.format((String)Strings.get("ramKilobyteLabel"), (String)("" + (bytes >> 10))) : StringUtil.format((String)Strings.get("ramByteLabel"), (String)("" + bytes))));
            GraphicsUtil.drawCenteredText((Graphics)g, (String)label, (int)(bds.getX() + bds.getWidth() / 2), (int)(bds.getY() + bds.getHeight() / 2));
        }
        g.drawRect(bds.getX() + bds.getWidth() / 3 * 2, bds.getY() + 30, bds.getWidth() / 3, bds.getHeight() / 2 - 30);
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"TTY", (int)(bds.getX() + bds.getWidth() / 4 * 3), (int)(bds.getY() + 5 + bds.getHeight() / 4));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"CNTL", (int)(bds.getX() + bds.getWidth() / 4 * 3), (int)(bds.getY() + 25 + bds.getHeight() / 4));
        g.drawRect(bds.getX() + bds.getWidth() / 3 * 2, bds.getY() + bds.getHeight() / 2 + 20, bds.getWidth() / 3, bds.getHeight() / 2 - 30);
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"KEYB", (int)(bds.getX() + bds.getWidth() / 4 * 3), (int)(bds.getY() + bds.getHeight() / 4 * 3 - 5));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"CNTL", (int)(bds.getX() + bds.getWidth() / 4 * 3), (int)(bds.getY() + bds.getHeight() / 4 * 3 + 15));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"RAM + IO CNTL", (int)(bds.getX() + bds.getWidth() / 4 + 25), (int)(bds.getY() + bds.getHeight() / 2 + 15));
        painter.drawPort(0, Strings.get("ramDataLabel"), Direction.EAST);
        painter.drawPort(1, Strings.get("ramAddrLabel"), Direction.EAST);
        g.setColor(Color.GRAY);
        painter.drawPort(2, Strings.get("ramCSLabel"), Direction.EAST);
        boolean asynch = false;
        boolean separate = true;
        if (!asynch) {
            painter.drawClock(5, Direction.EAST);
        }
        painter.drawPort(3, Strings.get("ramOELabel"), Direction.EAST);
        painter.drawPort(4, Strings.get("ramClrLabel"), Direction.EAST);
        if (separate) {
            painter.drawPort(6, Strings.get("ramWELabel"), Direction.EAST);
            painter.getGraphics().setColor(Color.BLACK);
            painter.drawPort(7, Strings.get("ramDataLabel"), Direction.EAST);
        }
        painter.drawPort(8, "TD", Direction.WEST);
        painter.drawPort(9, "TE", Direction.WEST);
        painter.drawPort(10, "TC", Direction.WEST);
        painter.drawPort(11, "KD", Direction.WEST);
        painter.drawPort(12, "KA", Direction.WEST);
        painter.drawPort(13, "KR", Direction.WEST);
        painter.drawPort(14, "IRQ_OUT", Direction.SOUTH);
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Font old = g.getFont();
        g.setFont(old.deriveFont(9.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"RAM", (int)10, (int)9);
        g.setFont(old);
        g.drawRect(0, 4, 19, 12);
        for (int dx = 2; dx < 20; dx += 5) {
            g.drawLine(dx, 2, dx, 4);
            g.drawLine(dx, 16, dx, 18);
        }
    }

    public static class Logger
    extends InstanceLogger {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getLogOptions(InstanceState state) {
            int addrBits = ((BitWidth)state.getAttributeValue(Mem.ADDR_ATTR)).getWidth();
            if (addrBits >= logOptions.length) {
                addrBits = logOptions.length - 1;
            }
            Object[][] objectArray = logOptions;
            synchronized (objectArray) {
                Object[] ret = logOptions[addrBits];
                if (ret == null) {
                    ret = new Object[1 << addrBits];
                    logOptions[addrBits] = ret;
                    for (int i = 0; i < ret.length; ++i) {
                        ret[i] = i;
                    }
                }
                return ret;
            }
        }

        public String getLogName(InstanceState state, Object option) {
            if (option instanceof Integer) {
                String disp = "MIPSRAM";
                Location loc = state.getInstance().getLocation();
                return disp + loc + "[" + option + "]";
            }
            return null;
        }

        public Value getLogValue(InstanceState state, Object option) {
            if (option instanceof Integer) {
                MemState s = (MemState)state.getData();
                int addr = (Integer)option;
                return Value.createKnown((BitWidth)BitWidth.create((int)s.getDataBits()), (int)s.getContents().get(addr));
            }
            return Value.NIL;
        }
    }

    private static class RamState
    extends MemState
    implements InstanceData,
    AttributeListener {
        private Instance parent;
        private Mem.MemListener listener;
        private HexFrame hexFrame = null;
        private ClockState clockState;

        RamState(Instance parent, MemContents contents, Mem.MemListener listener) {
            super(contents);
            this.parent = parent;
            this.listener = listener;
            this.clockState = new ClockState();
            if (parent != null) {
                parent.getAttributeSet().addAttributeListener((AttributeListener)this);
            }
            contents.addHexModelListener(listener);
        }

        void setRam(Instance value) {
            if (this.parent == value) {
                return;
            }
            if (this.parent != null) {
                this.parent.getAttributeSet().removeAttributeListener((AttributeListener)this);
            }
            this.parent = value;
            if (value != null) {
                value.getAttributeSet().addAttributeListener((AttributeListener)this);
            }
        }

        public RamState clone() {
            RamState ret = (RamState)super.clone();
            ret.parent = null;
            ret.clockState = this.clockState.clone();
            ret.getContents().addHexModelListener(this.listener);
            return ret;
        }

        public HexFrame getHexFrame(Project proj) {
            if (this.hexFrame == null) {
                this.hexFrame = new HexFrame(proj, (HexModel)this.getContents());
                this.hexFrame.addWindowListener((WindowListener)new WindowAdapter(){

                    public void windowClosed(WindowEvent e) {
                        RamState.this.hexFrame = null;
                    }
                });
            }
            return this.hexFrame;
        }

        public boolean setClock(Value newClock, Object trigger) {
            return this.clockState.updateClock(newClock, trigger);
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
            AttributeSet attrs = e.getSource();
            BitWidth addrBits = (BitWidth)attrs.getValue(Mem.ADDR_ATTR);
            this.getContents().setDimensions(addrBits.getWidth(), dataBits.getWidth());
        }
    }
}

