/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.WindowMenuItemManager;
import edu.cornell.cs3410.ProgramAssembler;
import edu.cornell.cs3410.ProgramState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ProgramFrame32
extends JFrame {
    private static final long serialVersionUID = 5437583663643692635L;
    private WindowMenuManager windowManager = new WindowMenuManager();
    private MyListener myListener = new MyListener();
    private ProgramAssembler.Listing code;
    private ListingModel model;
    private JTable listing;
    private Project proj;
    private JButton load = new JButton();
    private JButton close = new JButton();

    public ProgramFrame32(ProgramAssembler.Listing code, Project proj) {
        this.setDefaultCloseOperation(1);
        this.code = code;
        this.proj = proj;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.load);
        buttonPanel.add(this.close);
        this.load.addActionListener(this.myListener);
        this.close.addActionListener(this.myListener);
        this.setTitle("MIPS Program Listing");
        this.load.setText("Load Program...");
        this.close.setText("Close Window");
        this.model = new ListingModel();
        this.listing = new JTable(this.model);
        Font font = new Font("Monospaced", 0, 12);
        this.listing.setFont(font);
        FontMetrics fm = this.listing.getFontMetrics(font);
        int w = fm.stringWidth("00000000");
        this.listing.setAutoResizeMode(3);
        TableColumn tc = this.listing.getColumnModel().getColumn(0);
        tc.setMaxWidth(w + 10);
        tc.setMinWidth(w + 10);
        tc = this.listing.getColumnModel().getColumn(1);
        tc.setMaxWidth(w + 10);
        tc.setMinWidth(w + 10);
        this.listing.setShowHorizontalLines(false);
        this.listing.setShowVerticalLines(true);
        JScrollPane scroll = new JScrollPane(this.listing, 22, 31);
        scroll.setPreferredSize(new Dimension(400, 300));
        Container contents = this.getContentPane();
        contents.add((Component)scroll, "Center");
        contents.add((Component)buttonPanel, "South");
        this.pack();
    }

    public void setVisible(boolean value) {
        if (value && !this.isVisible()) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class ListingModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4373473477588858456L;

        private ListingModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return ProgramFrame32.this.code.getLineCount();
        }

        public Object getValueAt(int row, int col) {
            try {
                if (col == 0) {
                    int i = ProgramFrame32.this.code.getAddressOf(row);
                    if (i == -1) {
                        return "";
                    }
                    return StringUtil.toHexString((int)32, (int)i);
                }
                if (col == 1) {
                    int i = ProgramFrame32.this.code.getAddressOf(row);
                    if (i == -1) {
                        return "";
                    }
                    int instr = ProgramFrame32.this.code.instr(i / 4);
                    return StringUtil.toHexString((int)32, (int)instr);
                }
                return ProgramFrame32.this.code.getLine(row);
            }
            catch (Exception e) {
                return "???";
            }
        }

        public void fireChanged() {
            this.fireTableStructureChanged();
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Address";
                }
                case 1: {
                    return "Binary";
                }
            }
            return "Assembly";
        }
    }

    private class MyListener
    implements ActionListener {
        private File lastFile = null;

        private MyListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == ProgramFrame32.this.load) {
                JFileChooser chooser = new JFileChooser();
                if (this.lastFile != null) {
                    chooser.setSelectedFile(this.lastFile);
                }
                chooser.setDialogTitle("Load MIPS Program");
                int choice = chooser.showOpenDialog(ProgramFrame32.this);
                if (choice == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        String oldsrc = ProgramFrame32.this.code.getSource();
                        ProgramFrame32.this.code.load(f);
                        this.lastFile = f;
                        String newsrc = ProgramFrame32.this.code.getSource();
                        ProgramState state = ProgramFrame32.this.code.getState();
                        if (state != null) {
                            state.codeChanged();
                            Project proj = state.getProject();
                            if (proj != null) {
                                proj.doAction((Action)new Change(oldsrc, newsrc));
                            }
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(ProgramFrame32.this, e.getMessage(), "Error loading MIPS program", 0);
                    }
                }
            } else if (src == ProgramFrame32.this.close) {
                WindowEvent e = new WindowEvent(ProgramFrame32.this, 201);
                ProgramFrame32.this.processWindowEvent(e);
            }
        }
    }

    private class Change
    extends Action {
        String oldsrc;
        String newsrc;
        File file;
        boolean completed = false;

        Change(String oldsrc, String newsrc) {
            this.oldsrc = oldsrc;
            this.newsrc = newsrc;
        }

        public String getName() {
            return "Load MIPS Program";
        }

        public void doIt(Project proj) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            try {
                ProgramFrame32.this.code.setSource(this.newsrc);
            }
            catch (IOException e) {
                // empty catch block
            }
            ProgramState state = ProgramFrame32.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame32.this.model.fireChanged();
        }

        public void undo(Project proj) {
            if (!this.completed) {
                return;
            }
            this.completed = false;
            try {
                ProgramFrame32.this.code.setSource(this.oldsrc);
            }
            catch (IOException e) {
                // empty catch block
            }
            ProgramState state = ProgramFrame32.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame32.this.model.fireChanged();
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager {
        WindowMenuManager() {
            super("MIPS Program Listing", false);
        }

        public JFrame getJFrame(boolean create) {
            return ProgramFrame32.this;
        }
    }
}

