/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.KeyConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs3410.MemMenu;
import edu.cornell.cs3410.MemPoker;
import edu.cornell.cs3410.MemState;
import edu.cornell.cs3410.SimpleStringGetter;
import edu.cornell.cs3410.Strings;
import java.awt.Color;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;

abstract class Mem
extends InstanceFactory {
    public static final Attribute<BitWidth> ADDR_ATTR = Attributes.forBitWidth((String)"addrWidth", (StringGetter)Strings.getter("ramAddrWidthAttr"), (int)2, (int)24);
    private static final int DATA_ATTR = 32;
    static final int DATA = 0;
    static final int ADDR = 1;
    static final int CS = 2;
    static final int MEM_INPUTS = 3;
    static final int DELAY = 10;
    private WeakHashMap<Instance, File> currentInstanceFiles = new WeakHashMap();

    Mem(String name, StringGetter desc, int extraPorts) {
        super(name, desc);
        this.setInstancePoker(MemPoker.class);
        this.setKeyConfigurator((KeyConfigurator)new BitWidthConfigurator(ADDR_ATTR, 2, 24, 0));
        this.setOffsetBounds(Bounds.create((int)-140, (int)-40, (int)140, (int)80));
    }

    abstract void configurePorts(Instance var1);

    public abstract AttributeSet createAttributeSet();

    abstract MemState getState(InstanceState var1);

    abstract MemState getState(Instance var1, CircuitState var2);

    abstract HexFrame getHexFrame(Project var1, Instance var2, CircuitState var3);

    public abstract void propagate(InstanceState var1);

    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
    }

    void configureStandardPorts(Instance instance, Port[] ps) {
        ps[0] = new Port(0, 0, "inout", 32);
        ps[1] = new Port(-140, 0, "input", ADDR_ATTR);
        ps[2] = new Port(-90, 40, "input", 4);
        ps[0].setToolTip(Strings.getter("memDataTip"));
        ps[1].setToolTip(Strings.getter("memAddrTip"));
        ps[2].setToolTip((StringGetter)new SimpleStringGetter("Byte selects: each 0 disables access to one byte of the addressed word."));
    }

    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        painter.drawBounds();
        if (painter.getShowState()) {
            MemState state = this.getState((InstanceState)painter);
            state.paint(painter.getGraphics(), bds.getX(), bds.getY());
        } else {
            BitWidth addr = (BitWidth)painter.getAttributeValue(ADDR_ATTR);
            int addrBits = addr.getWidth();
            int bytes = 1 << addrBits + 2;
            String label = addrBits >= 30 ? StringUtil.format((String)Strings.get("ramGigabyteLabel"), (String)("" + (bytes >>> 30))) : (addrBits >= 20 ? StringUtil.format((String)Strings.get("ramMegabyteLabel"), (String)("" + (bytes >> 20))) : (addrBits >= 10 ? StringUtil.format((String)Strings.get("ramKilobyteLabel"), (String)("" + (bytes >> 10))) : StringUtil.format((String)Strings.get("ramByteLabel"), (String)("" + bytes))));
            GraphicsUtil.drawCenteredText((Graphics)g, (String)label, (int)(bds.getX() + bds.getWidth() / 2), (int)(bds.getY() + bds.getHeight() / 2));
        }
        painter.drawPort(0, Strings.get("ramDataLabel"), Direction.WEST);
        painter.drawPort(1, Strings.get("ramAddrLabel"), Direction.EAST);
        g.setColor(Color.GRAY);
        painter.drawPort(2, Strings.get("ramCSLabel"), Direction.SOUTH);
    }

    File getCurrentImage(Instance instance) {
        return this.currentInstanceFiles.get(instance);
    }

    void setCurrentImage(Instance instance, File value) {
        this.currentInstanceFiles.put(instance, value);
    }

    public void loadImage(InstanceState instanceState, File imageFile) throws IOException {
        MemState s = this.getState(instanceState);
        HexFile.open((HexModel)s.getContents(), (File)imageFile);
        this.setCurrentImage(instanceState.getInstance(), imageFile);
    }

    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return new MemMenu(this, instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    static class MemListener
    implements HexModelListener {
        Instance instance;

        MemListener(Instance instance) {
            this.instance = instance;
        }

        public void metainfoChanged(HexModel source) {
        }

        public void bytesChanged(HexModel source, long start, long numBytes, int[] values) {
            this.instance.fireInvalidated();
        }
    }
}

