using namespace std;
#include "gba.h"
#include "Sprites.h"


//Shadow for Object Attrubite Memory
OAMEntry sprites[128];
		
//Copies OAM Shadow to Hardware's OAM
void CopyOAM() {
  u16 loop;
  u16* pSprites;
  pSprites = (u16*)sprites;
  for(loop = 0; loop < 128*4; loop++) {
    OAM_Mem[loop] = pSprites[loop];
  }
}
		
//Makes the sprites coded in Sprites.h available to the sprite
// rendering system by copying them to OAM_Data
void InitializeSprites() {
  u16 loop;
  //transfer palette data into memory (16 colors)
  //only 5 are used in this sprite set
  for(loop = 0; loop < 5; loop++){
    OBJ_PaletteMem[loop] = sprite_palette[loop];
  }
			
  //transfer ball sprite into memory (2x8)
  //loop starts at 16 (after pallete data)
  u16* temp_alphabet;
  temp_alphabet = (u16*)alphabet;
			
  for (loop = 16; loop < (16 + (26*32)); loop++) {
    OAM_Data[loop] = temp_alphabet[loop-16];
  }

}
		
int main () {
			
  SetMode(MODE_1 | OBJ_ENABLE | OBJ_MAP_1D | BG2_ENABLE);
		
  InitializeSprites();

  // S
  sprites[0].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[0].attribute1 = SIZE_8 | 92;
  sprites[0].attribute2 = 5;
  // U
  sprites[5].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[5].attribute1 = SIZE_8 | 98;
  sprites[5].attribute2 = 7;
  // C
  sprites[6].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[6].attribute1 = SIZE_8 | 104;
  sprites[6].attribute2 = 1;
  // C
  sprites[2].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[2].attribute1 = SIZE_8 | 110;
  sprites[2].attribute2 = 1;
  // E
  sprites[7].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[7].attribute1 = SIZE_8 | 116;
  sprites[7].attribute2 = 3;
  // S
  sprites[8].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[8].attribute1 = SIZE_8 | 122;
  sprites[8].attribute2 = 5;
  // S
  sprites[9].attribute0 = COLOR_256 | SQUARE | 74;
  sprites[9].attribute1 = SIZE_8 | 128;
  sprites[9].attribute2 = 5;

      //wait for screen to draw
      vsync();
      //Update VRAM
      CopyOAM();
	
}
