(princ "-- Loading init.dyl from cs212 --")
(princ newline)

(define reduce (method ((f <function>) (l <list>))
		       (cond ((null? l) '())
			     ((null? (tail l)) (head l))
			     (else: (f (head l) (reduce f (tail l)))))))

(define + (method (#rest r) (reduce binary+ r)))
(define - (method ((o <number>) #rest r) (if (null? r) (unary- o) (binary- o (head r)))))
(define * (method (#rest r) (reduce binary* r)))
(define / (method ((o <number>) #rest r) (if (null? r) (unary/ o) (binary/ o (head r)))))
(define tan (method ((n <float>)) (/ (sin n) (cos n))))
(define = binary=)
(define > binary>)
(define /= (method ((x <object>) (y <object>)) (not (= x y))))
(define <= (method ((x <object>) (y <object>)) (not (> x y))))
(define >= (method ((x <object>) (y <object>)) (or (> x y) (= x y))))
(define < (method ((x <object>) (y <object>)) (and (/= x y) (not (> x y)))))
(define inc (method (x) (binary+ x 1)))
(define dec (method (x) (binary- x 1)))
(define zero? (method ((x <number>)) (= x 0)))
(define positive? (method ((x <number>)) (> x 0)))
(define negative? (method ((x <number>)) (< x 0)))
(define abs (method ((x <number>)) (if (< x 0) (unary- x) x)))
(define sqrt (method ((x <number>)) (^ x 0.5)))
(define (modulo <function>)
  (method ((a <integer>) (b <integer>))
          (bind ((remainder (- a (* b (/ a b)))))
                (if (= 0 remainder)
                    0
                    (if (= (positive? b) (positive? remainder))
                        remainder
                        (+ remainder b))))))
(define not (method (x) (if x #f #t)))
(define even? (method ((x <integer>)) (= (modulo x 2) 0)))
(define odd? (method ((x <integer>)) (not (even? x))))


(princ "-- Arithmetic primitives defined --")
(princ newline)

(define car head)
(define cdr tail)
(define first head)
(define second (method (x) (head (tail x))))
(define third (method (x) (head (tail (tail x)))))
(define cons pair)

;(define cons (method ((x <object>) (y <list>)) (pair x y)))
(add-method binary-append (method ((a <list>) (b <list>))
  (if (null? a) b (cons (head a) (binary-append (tail a) b)))))
(define append (method (#rest r) (reduce binary-append r)))
(add-method length (method ((l <list>)) (if (null? l) 0 (inc (length (tail l))))))
(add-method index  (method ((l <list>) (i <integer>))
                           (if (= i 0) (head l) (index (tail l) (dec i)))))
(define list (method (#rest r) r))
(define null? (method (x) (instance? x <empty-list>)))

(princ "-- List primitives defined --")
(princ newline)

(define print (method (#rest r)
  (if (null? r)
      (princ newline)
      (begin (princ (head r))
             (apply print (tail r))))))

(define filter (method ((pred <method>) (l <list>))
  (cond ((null? l) l)
        ((pred (head l)) (pair (head l) (filter pred (tail l))))
        (else: (filter pred (tail l))))))

(define do (bind-methods ((map-1 ((f <function>) (l <list>))
  (if (null? l) ()
      (pair (f (head l)) (map-1 f (tail l))))))
  (method ((f <function>) #rest r)
    (if (null? (head r))
      #f
      (begin (apply f   (map-1 head r))
             (apply map (pair f (map-1 tail r))))))))

(define map (bind-methods ((map-1 ((f <function>) (l <list>))
  (if (null? l) ()
      (pair (f (head l)) (map-1 f (tail l))))))
  (method ((f <function>) #rest r)
    (if (null? (head r))
      ()
      (pair (apply f   (map-1 head r))
            (apply map (pair f (map-1 tail r))))))))

(define member? (method ((o <object>) (l <list>))
  (if (null? l)
      #f
      (if (= o (head l))
          #t 
          (member? o (tail l))))))

(define compose (method ((f <function>) (g <function>))
  (method (x) (f (g x)))))

(define make (method ((c <class>) #rest r)
  (bind (((i c) (instantiate c)))
    (bind-methods ((setup ((sets <list>))
      (if (null? sets)
          i
          (begin (set-slot! (head sets) i (head (tail sets)))
                 (setup (tail (tail sets)))))))
      (setup r)))))

(define instance? (method ((obj <object>) (c <class>))
  (super-class? c (object-class obj))))

(define (insert <function>)
  (method ((o <object>) (s <list>))
    (cond ((null? s)      (list o))
          ((> o (head s)) (pair o s))
          (else: (pair (head s) (insert o (tail s)))))))

(define (sort <function>)
  (method ((l <list>))
    (cond ((null? l)        l)
          ((null? (tail l)) l)
          (else: (insert (head l) (sort (tail l)))))))

(define reverse (method ((l <list>))
  (if (null? l)
      ()
      (append (reverse (tail l)) (list (head l))))))

(define (last <function>)
  (method ((l <list>))
    (cond ((null? l) ())
          ((null? (tail l)) (head l))
          (else: (last (tail l))))))

(define vector (method (#rest r) (as <vector> r)))

(define n-vector (method ((n <integer>))
  (cond ((zero? n) [])	
        ((= n 1) [ #f ])
        ((even? n) (append (n-vector (/ n 2)) (n-vector (/ n 2))))
        (else: (append [ #f ] (n-vector (dec n)))))))

(define head-setter
  (method (o (p <pair>))
    (set! (head p) o)))

(define tail-setter
  (method (o (p <pair>))
    (set! (tail p) o)))

(define ps1 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps1.dyl")
(define ps2 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps2.dyl") 
(define ps3 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps3.dyl")
(define ps4 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps4.dyl")
(define ps5 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps5.dyl")
(define ps6 "http://simon.cs.cornell.edu/Info/Courses/Current/CS212/psets/ps6/ps6.dyl")


(princ "-- Initialization complete --")
(princ newline)
(print "--")
