/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanBoolean;
import Dylan.DylanClass;
import Dylan.DylanException;
import Dylan.DylanFrame;
import Dylan.DylanFunction;
import Dylan.DylanGenericFunction;
import Dylan.DylanKeyword;
import Dylan.DylanList;
import Dylan.DylanLocalFrame;
import Dylan.DylanMethod;
import Dylan.DylanObject;
import Dylan.DylanPair;
import Dylan.DylanParameter;
import Dylan.DylanSlotDescriptor;
import Dylan.DylanStack;
import Dylan.DylanSymbol;
import Dylan.DylanUserClass;
import Dylan.DylanUserInstance;
import Dylan.DylanUserMacro;
import Dylan.DylanUserMethod;
import Dylan.Getter;
import Dylan.Interpreter;
import Dylan.Setter;

class SpecialForms {
    static final int kBind = 0;
    static final int kAddMethod = 1;
    static final int kAnd = 2;
    static final int kBegin = 3;
    static final int kBindMethods = 4;
    static final int kCond = 5;
    static final int kDefine = 6;
    static final int kDefineClass = 7;
    static final int kDefineGenericFunction = 8;
    static final int kIf = 9;
    static final int kMacro = 10;
    static final int kMethod = 11;
    static final int kOr = 12;
    static final int kQuote = 13;
    static final int kSetB = 14;
    static final int kWhen = 15;
    static final int kWhile = 16;

    static DylanObject Select(int n, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        switch (n) {
            case 3: {
                return dylanList.EvaluateSequence(dylanFrame, dylanStack, bl);
            }
            case 0: {
                return SpecialForms.Bind(dylanList, dylanFrame, dylanStack, bl);
            }
            case 1: {
                return SpecialForms.AddMethod(dylanList, dylanFrame, dylanStack, bl);
            }
            case 2: {
                return SpecialForms.And(dylanList, dylanFrame, dylanStack, bl);
            }
            case 4: {
                return SpecialForms.BindMethods(dylanList, dylanFrame, dylanStack, bl);
            }
            case 5: {
                return SpecialForms.Cond(dylanList, dylanFrame, dylanStack, bl);
            }
            case 6: {
                return SpecialForms.Define(dylanList, dylanFrame, dylanStack, bl);
            }
            case 7: {
                return SpecialForms.DefineClass(dylanList, dylanFrame, dylanStack, bl);
            }
            case 8: {
                return SpecialForms.DefineGenericFunction(dylanList, dylanFrame, dylanStack, bl);
            }
            case 9: {
                return SpecialForms.If(dylanList, dylanFrame, dylanStack, bl);
            }
            case 10: {
                return SpecialForms.Macro(dylanList, dylanFrame, dylanStack, bl);
            }
            case 11: {
                return SpecialForms.ParseMethod(dylanList, dylanFrame, dylanStack);
            }
            case 12: {
                return SpecialForms.Or(dylanList, dylanFrame, dylanStack, bl);
            }
            case 13: {
                return SpecialForms.Quote(dylanList, dylanFrame, dylanStack, bl);
            }
            case 14: {
                return SpecialForms.SetB(dylanList, dylanFrame, dylanStack, bl);
            }
            case 15: {
                return SpecialForms.When(dylanList, dylanFrame, dylanStack, bl);
            }
            case 16: {
                return SpecialForms.While(dylanList, dylanFrame, dylanStack, bl);
            }
        }
        throw new DylanException(dylanStack, "Bad selector ID=" + n + " in special form apply.");
    }

    static final DylanObject Bind(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (DylanClass.DylanEmptyListClass.Instance(dylanList)) {
            throw new DylanException(dylanStack, "Bind : Required bindings of form (binding1 binding2 binding3).  Each binding must be of the form (Variable Value) or ((Variable Type) Value).");
        }
        DylanObject dylanObject = ((DylanPair)dylanList).mHead;
        if (!DylanClass.DylanListClass.Instance(dylanObject)) {
            throw new DylanException(dylanStack, "Bind : Bindings must be a list.");
        }
        DylanLocalFrame dylanLocalFrame = new DylanLocalFrame("bind", dylanFrame);
        while (DylanClass.DylanPairClass.Instance(dylanObject)) {
            DylanPair dylanPair = (DylanPair)dylanObject;
            SpecialForms.AddBinding(dylanPair.mHead, dylanLocalFrame, dylanStack);
            dylanObject = dylanPair.mTail;
        }
        return ((DylanList)((DylanPair)dylanList).mTail).EvaluateSequence(dylanLocalFrame, dylanStack, bl);
    }

    static void AddBinding(DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (!DylanClass.DylanPairClass.Instance(dylanObject)) {
            throw new DylanException(dylanStack, "Bind : Badly formed binding.  Each binding must be of the form (Variable Value) or ((Variable Type) Value).");
        }
        DylanPair dylanPair = (DylanPair)dylanObject;
        if (dylanPair.Length() != 2) {
            throw new DylanException(dylanStack, "Bind : Badly formed binding.  Each binding must be of the form (Variable Value) or ((Variable Type) Value).");
        }
        DylanParameter dylanParameter = new DylanParameter(dylanPair.mHead, dylanFrame, dylanStack);
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        DylanObject dylanObject2 = dylanPair2.mHead.Evaluate(dylanFrame, dylanStack, false);
        if (dylanParameter.mType.TypeCheck(dylanObject2)) {
            dylanFrame.Bind(dylanParameter.mVariable, dylanObject2);
            return;
        }
        throw new DylanException(dylanStack, dylanObject2, dylanParameter.mType);
    }

    static DylanObject AddMethod(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (dylanList.Length() != 2) {
            throw new DylanException(dylanStack, "Add-Method : Requires generic function name and method.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        DylanObject dylanObject = dylanPair.mHead.Evaluate(dylanFrame, dylanStack, false);
        if (DylanClass.DylanGenericFunctionClass.Instance(dylanObject)) {
            DylanObject dylanObject2 = dylanPair2.mHead.Evaluate(dylanFrame, dylanStack, false);
            if (DylanClass.DylanMethodClass.Instance(dylanObject2)) {
                if (dylanPair.mHead instanceof DylanSymbol) {
                    ((DylanMethod)dylanObject2).mDebugName = ((DylanSymbol)dylanPair.mHead).mValue;
                }
                ((DylanGenericFunction)dylanObject).AddMethod((DylanMethod)dylanObject2);
                return dylanPair.mHead;
            }
            throw new DylanException(dylanStack, "Add-Method : Second arguments must evaluate to a method.");
        }
        throw new DylanException(dylanStack, "Add-Method : First argument must evaluate to a generic function.");
    }

    static DylanObject And(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        DylanObject dylanObject = DylanBoolean.DylanTrue;
        while (DylanClass.DylanPairClass.Instance(dylanList)) {
            dylanObject = ((DylanPair)dylanList).mHead.Evaluate(dylanFrame, dylanStack, false);
            if (dylanObject instanceof DylanBoolean && !dylanObject.mValue) {
                return DylanBoolean.DylanFalse;
            }
            dylanList = (DylanList)((DylanPair)dylanList).mTail;
        }
        return dylanObject;
    }

    static DylanObject Begin(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        return dylanList.EvaluateSequence(dylanFrame, dylanStack, bl);
    }

    static DylanObject BindMethods(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (DylanClass.DylanEmptyListClass.Instance(dylanList)) {
            throw new DylanException(dylanStack, "Bind-Methods : Required bindings of form (binding1 binding2 binding3).  Each binding must be of the form (Name Args Body).");
        }
        DylanObject dylanObject = ((DylanPair)dylanList).mHead;
        if (!DylanClass.DylanListClass.Instance(dylanObject)) {
            throw new DylanException(dylanStack, "Bind-Methods : Bindings must be a list.");
        }
        DylanLocalFrame dylanLocalFrame = new DylanLocalFrame("bind-methods", dylanFrame);
        while (DylanClass.DylanPairClass.Instance(dylanObject)) {
            DylanPair dylanPair = (DylanPair)dylanObject;
            SpecialForms.AddMethodBinding(dylanPair.mHead, dylanLocalFrame, dylanStack);
            dylanObject = dylanPair.mTail;
        }
        return ((DylanList)((DylanPair)dylanList).mTail).EvaluateSequence(dylanLocalFrame, dylanStack, bl);
    }

    static void AddMethodBinding(DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (!DylanClass.DylanPairClass.Instance(dylanObject)) {
            throw new DylanException(dylanStack, "Bind-Methods : Badly formed binding.  Each binding must be of the form (Name Args Body).");
        }
        DylanPair dylanPair = (DylanPair)dylanObject;
        if (dylanPair.Length() < 3) {
            throw new DylanException(dylanStack, "Bind-Methods : Badly formed binding.  Each binding must be of the form (Name Args Body).");
        }
        DylanParameter dylanParameter = new DylanParameter(dylanPair.mHead, dylanFrame, dylanStack);
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        DylanUserMethod dylanUserMethod = SpecialForms.ParseMethod(dylanPair2, dylanFrame, dylanStack);
        dylanFrame.Bind(dylanParameter.mVariable, (DylanObject)dylanUserMethod);
    }

    static DylanObject Cond(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        while (DylanClass.DylanPairClass.Instance(dylanList)) {
            DylanObject dylanObject = ((DylanPair)dylanList).mHead;
            if (!DylanClass.DylanPairClass.Instance(dylanObject)) {
                throw new DylanException(dylanStack, "Cond : Badly formed clause.  Should be of the form (condition consequent1 consequent2 ...).");
            }
            DylanPair dylanPair = (DylanPair)dylanObject;
            DylanObject dylanObject2 = SpecialForms.condIsTrue(dylanPair.mHead, dylanFrame, dylanStack);
            if (dylanObject2 != null) {
                if (!DylanClass.DylanListClass.Instance(dylanPair.mTail)) {
                    throw new DylanException(dylanStack, "Cond : Badly formed clause.  Each clause should be a proper list.");
                }
                if (DylanClass.DylanPairClass.Instance(dylanPair.mTail)) {
                    return ((DylanList)dylanPair.mTail).EvaluateSequence(dylanFrame, dylanStack, bl);
                }
                return dylanObject2;
            }
            dylanList = (DylanList)((DylanPair)dylanList).mTail;
        }
        return DylanBoolean.DylanFalse;
    }

    static DylanObject condIsTrue(DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (dylanObject instanceof DylanKeyword && ((DylanKeyword)dylanObject).mValue.equals("else")) {
            return DylanBoolean.DylanTrue;
        }
        DylanObject dylanObject2 = dylanObject.Evaluate(dylanFrame, dylanStack, false);
        if (!(dylanObject2 instanceof DylanBoolean) || ((DylanBoolean)dylanObject2).mValue) {
            return dylanObject2;
        }
        return null;
    }

    static DylanObject Define(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (dylanList.Length() != 2) {
            throw new DylanException(dylanStack, "Define : Requires variable and value, or (variable type) and value.");
        }
        if (dylanFrame instanceof DylanLocalFrame) {
            throw new DylanException(dylanStack, "Define : Must be performed at the global level.");
        }
        DylanParameter dylanParameter = new DylanParameter(((DylanPair)dylanList).mHead, dylanFrame, dylanStack);
        DylanObject dylanObject = ((DylanPair)((DylanPair)dylanList).mTail).mHead.Evaluate(dylanFrame, dylanStack, false);
        if (!dylanParameter.mType.TypeCheck(dylanObject)) {
            throw new DylanException(dylanStack, dylanObject, dylanParameter.mType);
        }
        if (DylanClass.DylanFunctionClass.Instance(dylanObject)) {
            ((DylanFunction)dylanObject).mDebugName = dylanParameter.mVariable;
        }
        dylanFrame.Bind(dylanParameter, dylanObject);
        return ((DylanPair)dylanList).mHead;
    }

    static DylanObject DefineClass(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (dylanList.Length() < 2) {
            throw new DylanException(dylanStack, "Define-Class : Requires class name and subclass list.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        DylanList dylanList2 = (DylanList)dylanPair2.mTail;
        if (DylanClass.DylanSymbolClass.Instance(dylanPair.mHead)) {
            DylanSymbol dylanSymbol = (DylanSymbol)dylanPair.mHead;
            if (DylanClass.DylanListClass.Instance(dylanPair2.mHead)) {
                DylanClass[] dylanClassArray = SpecialForms.ParseClasses((DylanList)dylanPair2.mHead, dylanFrame, dylanStack);
                DylanSlotDescriptor[] dylanSlotDescriptorArray = SpecialForms.ParseSlots(dylanList2, dylanFrame, dylanStack);
                DylanUserClass dylanUserClass = new DylanUserClass(dylanSymbol.mValue, dylanClassArray, dylanSlotDescriptorArray);
                dylanFrame.Bind(dylanSymbol.mValue, (DylanObject)dylanUserClass);
                SpecialForms.BindAccessors(dylanUserClass, dylanSlotDescriptorArray, dylanFrame, dylanStack);
                return dylanSymbol;
            }
            throw new DylanException(dylanStack, "Define-Class : Requires superclass list as second argument.");
        }
        throw new DylanException(dylanStack, "Define-Class : Requires class name as first argument.");
    }

    static void BindAccessors(DylanUserClass dylanUserClass, DylanSlotDescriptor[] dylanSlotDescriptorArray, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        int n = 0;
        while (n < dylanSlotDescriptorArray.length) {
            SpecialForms.CreateGetMethod(dylanSlotDescriptorArray[n], dylanUserClass, dylanFrame, dylanStack);
            SpecialForms.CreateSetMethod(dylanSlotDescriptorArray[n], dylanUserClass, dylanFrame, dylanStack);
            ++n;
        }
    }

    static void CreateGetMethod(DylanSlotDescriptor dylanSlotDescriptor, DylanUserClass dylanUserClass, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        DylanGenericFunction dylanGenericFunction;
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("instance")};
        if (Interpreter.mGlobalEnvironment.FindTable(dylanSlotDescriptor.mName.toLowerCase()) == null) {
            dylanGenericFunction = new DylanGenericFunction(dylanSlotDescriptor.mName, dylanParameterArray, null);
            Interpreter.mGlobalEnvironment.Bind(dylanSlotDescriptor.mName, (DylanObject)dylanGenericFunction);
        } else {
            DylanObject dylanObject = Interpreter.mGlobalEnvironment.Lookup(dylanSlotDescriptor.mName, dylanFrame, dylanStack);
            if (dylanObject instanceof DylanGenericFunction) {
                dylanGenericFunction = (DylanGenericFunction)dylanObject;
            } else {
                dylanGenericFunction = new DylanGenericFunction(dylanSlotDescriptor.mName, dylanParameterArray, null);
                Interpreter.mGlobalEnvironment.Bind(dylanSlotDescriptor.mName, (DylanObject)dylanGenericFunction);
            }
        }
        dylanGenericFunction.AddMethod(new Getter(dylanSlotDescriptor.mName, dylanUserClass));
    }

    static void CreateSetMethod(DylanSlotDescriptor dylanSlotDescriptor, DylanUserClass dylanUserClass, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        DylanGenericFunction dylanGenericFunction;
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("instance"), new DylanParameter("new-value")};
        if (Interpreter.mGlobalEnvironment.FindTable(dylanSlotDescriptor.mName.toLowerCase() + "-setter") == null) {
            dylanGenericFunction = new DylanGenericFunction(dylanSlotDescriptor.mName + "-setter", dylanParameterArray, null);
            Interpreter.mGlobalEnvironment.Bind(dylanSlotDescriptor.mName + "-setter", (DylanObject)dylanGenericFunction);
        } else {
            DylanObject dylanObject = Interpreter.mGlobalEnvironment.Lookup(dylanSlotDescriptor.mName + "-setter", dylanFrame, dylanStack);
            if (dylanObject instanceof DylanGenericFunction) {
                dylanGenericFunction = (DylanGenericFunction)dylanObject;
            } else {
                dylanGenericFunction = new DylanGenericFunction(dylanSlotDescriptor.mName + "-setter", dylanParameterArray, null);
                Interpreter.mGlobalEnvironment.Bind(dylanSlotDescriptor.mName + "-setter", (DylanObject)dylanGenericFunction);
            }
        }
        dylanGenericFunction.AddMethod(new Setter(dylanSlotDescriptor.mName, dylanUserClass));
    }

    static DylanClass[] ParseClasses(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        DylanClass[] dylanClassArray = new DylanClass[dylanList.Length()];
        int n = 0;
        while (n < dylanClassArray.length) {
            DylanObject dylanObject = ((DylanPair)dylanList).mHead.Evaluate(dylanFrame, dylanStack, false);
            if (!DylanClass.DylanClassClass.Instance(dylanObject)) {
                throw new DylanException(dylanStack, "Define-Class : Superclass list elements must evaluate to type <class>.");
            }
            dylanClassArray[n] = (DylanClass)dylanObject;
            dylanList = (DylanList)((DylanPair)dylanList).mTail;
            ++n;
        }
        return dylanClassArray;
    }

    static DylanSlotDescriptor[] ParseSlots(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        DylanObject[] dylanObjectArray = dylanList.toArray();
        DylanSlotDescriptor[] dylanSlotDescriptorArray = new DylanSlotDescriptor[dylanObjectArray.length];
        int n = 0;
        while (n < dylanSlotDescriptorArray.length) {
            dylanSlotDescriptorArray[n] = SpecialForms.ParseSlot(dylanObjectArray[n], dylanFrame, dylanStack);
            ++n;
        }
        return dylanSlotDescriptorArray;
    }

    static DylanSlotDescriptor ParseSlot(DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (DylanClass.DylanPairClass.Instance(dylanObject)) {
            DylanObject dylanObject2;
            DylanSymbol dylanSymbol;
            DylanPair dylanPair = (DylanPair)dylanObject;
            DylanObject[] dylanObjectArray = dylanPair.toArray();
            if (dylanObjectArray.length >= 2) {
                if (!DylanClass.DylanSymbolClass.Instance(dylanObjectArray[0])) {
                    throw new DylanException(dylanStack, "Define-Class : Slot descriptors must have slot names.");
                }
                dylanSymbol = (DylanSymbol)dylanObjectArray[0];
                dylanObject2 = dylanObjectArray[1].Evaluate(dylanFrame, dylanStack, false);
                if (!DylanClass.DylanClassClass.Instance(dylanObject2)) {
                    throw new DylanException(dylanStack, "Define-Class : Slot descriptors must have type follow slot name.");
                }
            } else {
                throw new DylanException(dylanStack, "Define-CLass : Slot descriptor must be of form (name type) or (name type init-value.");
            }
            DylanClass dylanClass = (DylanClass)dylanObject2;
            if (dylanObjectArray.length == 2) {
                return new DylanSlotDescriptor(dylanSymbol.mValue, dylanClass, null);
            }
            if (dylanObjectArray.length == 3) {
                return new DylanSlotDescriptor(dylanSymbol.mValue, dylanClass, dylanObjectArray[2].Evaluate(dylanFrame, dylanStack, false));
            }
            throw new DylanException(dylanStack, "Define-Class : Slot descriptor must be of form (name type) or (name type init-value.");
        }
        throw new DylanException(dylanStack, "Define-Class : Slot descriptors must be lists.");
    }

    static DylanObject DefineGenericFunction(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        DylanParameter[] dylanParameterArray;
        DylanObject dylanObject;
        if (dylanList.Length() != 2) {
            throw new DylanException(dylanStack, "Define-Generic-Function : Requires name a parameter list.");
        }
        if (dylanFrame instanceof DylanLocalFrame) {
            throw new DylanException(dylanStack, "Define-Generic-Function : Must be performed at the global level.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        if (!DylanClass.DylanSymbolClass.Instance(dylanPair.mHead)) {
            throw new DylanException(dylanStack, "Define-Generic-Function : First argument must be a variable name.");
        }
        DylanObject dylanObject2 = dylanPair2.mHead;
        if (!DylanClass.DylanListClass.Instance(dylanObject2)) {
            throw new DylanException(dylanStack, "Define-Generic=Function : Second argument must be a parameter list.");
        }
        DylanParameter dylanParameter = null;
        DylanObject[] dylanObjectArray = ((DylanList)dylanPair2.mHead).toArray();
        if (dylanObjectArray.length >= 2 && (dylanObject = dylanObjectArray[dylanObjectArray.length - 2]) instanceof DylanSymbol && ((DylanSymbol)dylanObject).mValue.toLowerCase().equals("#rest") && true) {
            dylanParameterArray = new DylanParameter[dylanObjectArray.length - 2];
            int n = 0;
            while (n < dylanObjectArray.length - 2) {
                dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                ++n;
            }
            dylanParameter = new DylanParameter(dylanObjectArray[dylanObjectArray.length - 1], dylanFrame, dylanStack);
        } else {
            dylanParameterArray = new DylanParameter[dylanObjectArray.length];
            int n = 0;
            while (n < dylanObjectArray.length) {
                dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                ++n;
            }
        }
        dylanFrame.Bind(((DylanSymbol)dylanPair.mHead).mValue, (DylanObject)new DylanGenericFunction(((DylanSymbol)dylanPair.mHead).mValue, dylanParameterArray, dylanParameter));
        return dylanPair.mHead;
    }

    static DylanObject If(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (dylanList.Length() != 3) {
            throw new DylanException(dylanStack, "If : Requires condition, consequent, and alternate.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanPair dylanPair2 = (DylanPair)dylanPair.mTail;
        DylanPair dylanPair3 = (DylanPair)dylanPair2.mTail;
        DylanObject dylanObject = dylanPair.mHead.Evaluate(dylanFrame, dylanStack, false);
        if (!(dylanObject instanceof DylanBoolean) || ((DylanBoolean)dylanObject).mValue) {
            return dylanPair2.mHead.Evaluate(dylanFrame, dylanStack, bl);
        }
        return dylanPair3.mHead.Evaluate(dylanFrame, dylanStack, bl);
    }

    static DylanObject Macro(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (DylanClass.DylanPairClass.Instance(dylanList)) {
            DylanObject dylanObject = ((DylanPair)dylanList).mHead;
            if (DylanClass.DylanListClass.Instance(dylanObject)) {
                DylanParameter[] dylanParameterArray;
                DylanObject dylanObject2;
                DylanParameter dylanParameter = null;
                DylanObject[] dylanObjectArray = ((DylanList)dylanObject).toArray();
                if (dylanObjectArray.length >= 2 && (dylanObject2 = dylanObjectArray[dylanObjectArray.length - 2]) instanceof DylanSymbol && ((DylanSymbol)dylanObject2).mValue.toLowerCase().equals("#rest") && true) {
                    dylanParameterArray = new DylanParameter[dylanObjectArray.length - 2];
                    int n = 0;
                    while (n < dylanObjectArray.length - 2) {
                        dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                        ++n;
                    }
                    dylanParameter = new DylanParameter(dylanObjectArray[dylanObjectArray.length - 1], dylanFrame, dylanStack);
                } else {
                    dylanParameterArray = new DylanParameter[dylanObjectArray.length];
                    int n = 0;
                    while (n < dylanObjectArray.length) {
                        dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                        ++n;
                    }
                }
                return new DylanUserMacro("anonymous", dylanParameterArray, dylanParameter, (DylanList)((DylanPair)dylanList).mTail, dylanFrame);
            }
            throw new DylanException(dylanStack, "Macro : Requires properly formed parameter list.");
        }
        throw new DylanException(dylanStack, "Macro : Requires parameter list and body.");
    }

    static boolean isRest(DylanObject dylanObject) {
        return dylanObject instanceof DylanSymbol && ((DylanSymbol)dylanObject).mValue.toLowerCase().equals("#rest");
    }

    static DylanObject Method(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        return SpecialForms.ParseMethod(dylanList, dylanFrame, dylanStack);
    }

    static DylanUserMethod ParseMethod(DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (DylanClass.DylanPairClass.Instance(dylanObject)) {
            DylanObject dylanObject2 = ((DylanPair)dylanObject).mHead;
            if (DylanClass.DylanListClass.Instance(dylanObject2)) {
                DylanParameter[] dylanParameterArray;
                DylanObject dylanObject3;
                DylanParameter dylanParameter = null;
                DylanObject[] dylanObjectArray = ((DylanList)dylanObject2).toArray();
                if (dylanObjectArray.length >= 2 && (dylanObject3 = dylanObjectArray[dylanObjectArray.length - 2]) instanceof DylanSymbol && ((DylanSymbol)dylanObject3).mValue.toLowerCase().equals("#rest") && true) {
                    dylanParameterArray = new DylanParameter[dylanObjectArray.length - 2];
                    int n = 0;
                    while (n < dylanObjectArray.length - 2) {
                        dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                        ++n;
                    }
                    dylanParameter = new DylanParameter(dylanObjectArray[dylanObjectArray.length - 1], dylanFrame, dylanStack);
                } else {
                    dylanParameterArray = new DylanParameter[dylanObjectArray.length];
                    int n = 0;
                    while (n < dylanObjectArray.length) {
                        dylanParameterArray[n] = new DylanParameter(dylanObjectArray[n], dylanFrame, dylanStack);
                        ++n;
                    }
                }
                return new DylanUserMethod("anonymous", dylanParameterArray, dylanParameter, (DylanList)((DylanPair)dylanObject).mTail, dylanFrame);
            }
            throw new DylanException(dylanStack, "Method : Requires properly formed parameter list.");
        }
        throw new DylanException(dylanStack, "Method : Requires parameter list and body.");
    }

    static DylanObject Or(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        while (DylanClass.DylanPairClass.Instance(dylanList)) {
            DylanObject dylanObject = ((DylanPair)dylanList).mHead.Evaluate(dylanFrame, dylanStack, false);
            if (!(dylanObject instanceof DylanBoolean) || ((DylanBoolean)dylanObject).mValue) {
                return dylanObject;
            }
            dylanList = (DylanList)((DylanPair)dylanList).mTail;
        }
        return DylanBoolean.DylanFalse;
    }

    static DylanObject Quote(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (DylanClass.DylanEmptyListClass.Instance(dylanList)) {
            throw new DylanException(dylanStack, "Quote : Requires one argument.");
        }
        if (!DylanClass.DylanEmptyListClass.Instance(((DylanPair)dylanList).mTail)) {
            throw new DylanException(dylanStack, "Quote : Takes only one argument");
        }
        return ((DylanPair)dylanList).mHead;
    }

    static DylanObject SetB(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (dylanList.Length() != 2) {
            throw new DylanException(dylanStack, "Set! : Requires variable and value.");
        }
        DylanObject dylanObject = ((DylanPair)dylanList).mHead;
        DylanObject dylanObject2 = ((DylanPair)((DylanPair)dylanList).mTail).mHead.Evaluate(dylanFrame, dylanStack, false);
        if (DylanClass.DylanSymbolClass.Instance(dylanObject)) {
            dylanFrame.Set(((DylanSymbol)dylanObject).mValue, dylanObject2, dylanFrame, dylanStack);
            return dylanObject2;
        }
        if (DylanClass.DylanPairClass.Instance(dylanObject)) {
            DylanPair dylanPair = (DylanPair)dylanObject;
            if (DylanClass.DylanSymbolClass.Instance(dylanPair.mHead)) {
                String string = ((DylanSymbol)dylanPair.mHead).mValue.toString();
                DylanObject dylanObject3 = ((DylanPair)dylanPair.mTail).mHead.Evaluate(dylanFrame, dylanStack, false);
                if (dylanObject3 instanceof DylanUserInstance) {
                    ((DylanUserInstance)dylanObject3).SetSlot(string, dylanObject2, dylanFrame, dylanStack);
                    return dylanObject2;
                }
                if (dylanObject3 instanceof DylanPair) {
                    if (string.toLowerCase().equals("head")) {
                        ((DylanPair)dylanObject3).mHead = dylanObject2;
                        return dylanObject2;
                    }
                    if (string.toLowerCase().equals("tail")) {
                        ((DylanPair)dylanObject3).mTail = dylanObject2;
                        return dylanObject2;
                    }
                }
            }
        }
        throw new DylanException(dylanStack, "Set! : First argument must be a variable name or (slot-name user-instance).");
    }

    static DylanObject When(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        if (DylanClass.DylanEmptyListClass.Instance(dylanList)) {
            throw new DylanException(dylanStack, "When : Requires condition.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanObject dylanObject = dylanPair.mHead.Evaluate(dylanFrame, dylanStack, false);
        if (!(dylanObject instanceof DylanBoolean) || ((DylanBoolean)dylanObject).mValue) {
            if (DylanClass.DylanEmptyListClass.Instance(dylanPair.mTail)) {
                return dylanObject;
            }
            return ((DylanPair)dylanPair.mTail).EvaluateSequence(dylanFrame, dylanStack, bl);
        }
        return DylanBoolean.DylanFalse;
    }

    static DylanObject While(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        DylanObject dylanObject;
        if (DylanClass.DylanEmptyListClass.Instance(dylanList)) {
            throw new DylanException(dylanStack, "While : Required condition.");
        }
        DylanPair dylanPair = (DylanPair)dylanList;
        DylanObject dylanObject2 = dylanPair.mHead;
        DylanList dylanList2 = (DylanList)dylanPair.mTail;
        DylanObject dylanObject3 = DylanBoolean.DylanFalse;
        while (!((dylanObject = dylanObject2.Evaluate(dylanFrame, dylanStack, false)) instanceof DylanBoolean) || ((DylanBoolean)dylanObject).mValue) {
            dylanObject3 = dylanList2.EvaluateSequence(dylanFrame, dylanStack, false);
        }
        return dylanObject3;
    }

    SpecialForms() {
    }
}

