/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanBoolean;
import Dylan.DylanCharacter;
import Dylan.DylanClass;
import Dylan.DylanEmptyList;
import Dylan.DylanException;
import Dylan.DylanFloat;
import Dylan.DylanFrame;
import Dylan.DylanInteger;
import Dylan.DylanKeyword;
import Dylan.DylanList;
import Dylan.DylanMethod;
import Dylan.DylanObject;
import Dylan.DylanPair;
import Dylan.DylanSimpleError;
import Dylan.DylanSingleton;
import Dylan.DylanStack;
import Dylan.DylanString;
import Dylan.DylanSymbol;
import Dylan.DylanUserClass;
import Dylan.DylanUserInstance;
import Dylan.DylanVector;
import Dylan.Interpreter;
import Dylan.Parser;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

class Primitives {
    static final int kApply = 0;
    static final int kAsCI = 1;
    static final int kAsFI = 2;
    static final int kAsIC = 3;
    static final int kAsSK = 4;
    static final int kAsSL = 5;
    static final int kAsSS = 6;
    static final int kAsVL = 7;
    static final int kBinaryAppendSS = 8;
    static final int kBinaryAppendVV = 9;
    static final int kBinaryEqualOO = 10;
    static final int kBinaryGreaterThanOO = 11;
    static final int kBinaryPlusNN = 12;
    static final int kBinaryTimesNN = 13;
    static final int kBinaryDivideNN = 14;
    static final int kBinaryMinusNN = 15;
    static final int kCos = 16;
    static final int kError = 17;
    static final int kGetSlot = 18;
    static final int kHead = 19;
    static final int kIdQ = 20;
    static final int kIndexS = 21;
    static final int kIndexV = 22;
    static final int kIndexSetterV = 23;
    static final int kInstantiate = 24;
    static final int kLengthS = 25;
    static final int kLengthV = 26;
    static final int kLine = 27;
    static final int kLoad = 28;
    static final int kLoadText = 29;
    static final int kMoveTo = 30;
    static final int kObjectClass = 31;
    static final int kOval = 32;
    static final int kPair = 33;
    static final int kPower = 34;
    static final int kPrinc = 35;
    static final int kRandom = 36;
    static final int kRead = 37;
    static final int kRectangle = 38;
    static final int kSetColor = 39;
    static final int kSetSlot = 40;
    static final int kShowGraphics = 41;
    static final int kSin = 42;
    static final int kSingleton = 43;
    static final int kSuperClassP = 44;
    static final int kTail = 45;
    static final int kTime = 46;
    static final int kTruncate = 47;
    static final int kUnaryMinusN = 48;
    static final int kUnaryDivideN = 49;
    static int mCurrentX;
    static int mCurrentY;

    static DylanObject Select(int n, DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        switch (n) {
            case 0: {
                return Primitives.Apply(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 1: {
                return new DylanCharacter((char)((DylanInteger)dylanObjectArray[1]).mValue);
            }
            case 2: {
                return new DylanFloat(((DylanInteger)dylanObjectArray[1]).mValue);
            }
            case 3: {
                return new DylanInteger(((DylanCharacter)dylanObjectArray[1]).mValue);
            }
            case 4: {
                return new DylanSymbol(((DylanKeyword)dylanObjectArray[1]).mValue);
            }
            case 5: {
                return Primitives.AsSL(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 6: {
                return new DylanSymbol(((DylanString)dylanObjectArray[1]).mValue.toString());
            }
            case 7: {
                return Primitives.AsVL(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 8: {
                return Primitives.BinaryAppendSS(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 9: {
                return Primitives.BinaryAppendVV(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 10: {
                return new DylanBoolean(dylanObjectArray[0].equals(dylanObjectArray[1]));
            }
            case 12: {
                return Primitives.BinaryPlusNN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 13: {
                return Primitives.BinaryTimesNN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 14: {
                return Primitives.BinaryDivideNN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 11: {
                return new DylanBoolean(dylanObjectArray[0].greaterthan(dylanObjectArray[1]));
            }
            case 15: {
                return Primitives.BinaryMinusNN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 16: {
                return new DylanFloat(Math.cos(((DylanFloat)dylanObjectArray[0]).mValue));
            }
            case 17: {
                throw new DylanException(dylanStack, ((DylanString)dylanObjectArray[0]).mValue.toString());
            }
            case 18: {
                return Primitives.GetSlot(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 19: {
                return ((DylanPair)dylanObjectArray[0]).mHead;
            }
            case 20: {
                return new DylanBoolean(dylanObjectArray[0] == dylanObjectArray[1]);
            }
            case 21: {
                return Primitives.IndexS(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 22: {
                return Primitives.IndexV(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 23: {
                return Primitives.IndexSetterV(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 24: {
                if (dylanObjectArray[0] instanceof DylanUserClass) {
                    return new DylanUserInstance((DylanUserClass)dylanObjectArray[0], dylanFrame, dylanStack);
                }
                throw new DylanException(dylanStack, "Instantiate : Cannot use built-in types.");
            }
            case 25: {
                return new DylanInteger(((DylanString)dylanObjectArray[0]).mValue.length());
            }
            case 26: {
                return new DylanInteger(((DylanVector)dylanObjectArray[0]).mValues.size());
            }
            case 27: {
                return Primitives.Line(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 28: {
                return Primitives.Load(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 29: {
                return Primitives.LoadText(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 30: {
                return Primitives.MoveTo(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 31: {
                return dylanObjectArray[0].mClass;
            }
            case 33: {
                return new DylanPair(dylanObjectArray[0], dylanObjectArray[1]);
            }
            case 35: {
                DylanObject dylanObject = dylanObjectArray[0];
                if (dylanObject instanceof DylanString) {
                    String string = ((DylanString)dylanObject).mValue.toString();
                    Interpreter.mOut.appendText(string);
                    Interpreter.mOut.repaint();
                } else {
                    String string = dylanObject.toString();
                    Interpreter.mOut.appendText(string);
                    Interpreter.mOut.repaint();
                }
                return DylanBoolean.DylanTrue;
            }
            case 34: {
                return Primitives.Power(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 36: {
                return new DylanInteger((int)(Math.random() * (double)((DylanInteger)dylanObjectArray[0]).mValue));
            }
            case 37: {
                return Primitives.Read(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 38: {
                return Primitives.Rectangle(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 40: {
                return Primitives.SetSlot(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 41: {
                return Primitives.ShowGraphics(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 42: {
                return new DylanFloat(Math.sin(((DylanFloat)dylanObjectArray[0]).mValue));
            }
            case 43: {
                return new DylanSingleton(dylanObjectArray[0]);
            }
            case 44: {
                return new DylanBoolean(((DylanClass)dylanObjectArray[0]).Superclass((DylanClass)dylanObjectArray[1]));
            }
            case 45: {
                return ((DylanPair)dylanObjectArray[0]).mTail;
            }
            case 46: {
                return new DylanInteger(System.currentTimeMillis() / 1000L);
            }
            case 47: {
                return new DylanInteger((long)((DylanFloat)dylanObjectArray[0]).mValue);
            }
            case 48: {
                return Primitives.UnaryMinusN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
            case 49: {
                return Primitives.UnaryDivideN(dylanObjectArray, dylanList, dylanFrame, dylanStack);
            }
        }
        throw new DylanException(dylanStack, "Bad selector ID in primitive apply.");
    }

    static DylanObject Read(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        Parser parser = null;
        Interpreter.mUserReadPending = true;
        while (Interpreter.mUserReadPending) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        parser = new Parser(Interpreter.mUserRead, dylanStack);
        return parser.Parse();
    }

    static DylanObject Error(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        throw new DylanException(dylanStack, ((DylanString)dylanObjectArray[0]).mValue.toString());
    }

    static DylanObject Apply(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        DylanMethod dylanMethod = (DylanMethod)dylanObjectArray[0];
        DylanList dylanList2 = (DylanList)dylanObjectArray[1];
        DylanObject[] dylanObjectArray2 = new DylanObject[dylanMethod.mRequired.length];
        int n = 0;
        while (n < dylanMethod.mRequired.length) {
            if (dylanList2 instanceof DylanEmptyList) {
                throw new DylanException(dylanStack, "Apply : Too few arguments.");
            }
            dylanObjectArray2[n] = ((DylanPair)dylanList2).mHead;
            dylanList2 = (DylanList)((DylanPair)dylanList2).mTail;
            ++n;
        }
        return dylanMethod.ApplyEvaluated(dylanObjectArray2, dylanList2, dylanFrame, dylanStack);
    }

    static DylanObject AsCI(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanCharacter((char)((DylanInteger)dylanObjectArray[1]).mValue);
    }

    static DylanObject AsFI(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanFloat(((DylanInteger)dylanObjectArray[1]).mValue);
    }

    static DylanObject AsIC(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanInteger(((DylanCharacter)dylanObjectArray[1]).mValue);
    }

    static DylanObject AsSK(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanSymbol(((DylanKeyword)dylanObjectArray[1]).mValue);
    }

    static DylanObject AsSL(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[1] instanceof DylanEmptyList) {
            return new DylanString("");
        }
        StringBuffer stringBuffer = new StringBuffer();
        DylanObject dylanObject = ((DylanPair)dylanObjectArray[1]).mTail;
        stringBuffer.append(((DylanPair)dylanObjectArray[1]).mHead);
        while (DylanClass.DylanPairClass.Instance(dylanObject)) {
            if (!(((DylanPair)dylanObject).mHead instanceof DylanCharacter)) {
                return new DylanSimpleError(dylanStack, "As : List should consist of only characters. Offending element " + ((DylanPair)dylanObject).mHead.toString() + " .");
            }
            stringBuffer.append(((DylanPair)dylanObject).mHead);
            dylanObject = ((DylanPair)dylanObject).mTail;
        }
        if (DylanClass.DylanEmptyListClass.Instance(dylanObject)) {
            return new DylanString(stringBuffer);
        }
        if (DylanClass.DylanCharacterClass.Instance(dylanObject)) {
            return new DylanString(stringBuffer.append(((DylanPair)dylanObject).mHead));
        }
        return new DylanSimpleError(dylanStack, "As : List should consist of only characters. Offending ending element.");
    }

    static DylanObject AsSS(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanSymbol(((DylanString)dylanObjectArray[1]).mValue.toString());
    }

    static DylanObject AsVL(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Vector<DylanObject> vector = new Vector<DylanObject>();
        DylanList dylanList2 = (DylanList)dylanObjectArray[1];
        while (dylanList2 instanceof DylanPair) {
            vector.addElement(((DylanPair)dylanList2).mHead);
            dylanList2 = (DylanList)((DylanPair)dylanList2).mTail;
        }
        return new DylanVector(vector);
    }

    static DylanObject BinaryAppendSS(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        StringBuffer stringBuffer = ((DylanString)dylanObjectArray[0]).mValue;
        StringBuffer stringBuffer2 = ((DylanString)dylanObjectArray[1]).mValue;
        return new DylanString(stringBuffer.toString() + stringBuffer2.toString());
    }

    static DylanObject BinaryAppendVV(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Vector vector = ((DylanVector)dylanObjectArray[0]).mValues;
        Vector vector2 = ((DylanVector)dylanObjectArray[1]).mValues;
        int n = vector2.size();
        int n2 = vector.size();
        Vector vector3 = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            vector3.addElement(vector.elementAt(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            vector3.addElement(vector2.elementAt(n4));
            ++n4;
        }
        return new DylanVector(vector3);
    }

    static DylanObject BinaryEqualOO(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanBoolean(dylanObjectArray[0].equals(dylanObjectArray[1]));
    }

    static DylanObject BinaryGreaterThanOO(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanBoolean(dylanObjectArray[0].greaterthan(dylanObjectArray[1]));
    }

    static DylanObject BinaryPlusNN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[0] instanceof DylanInteger && dylanObjectArray[1] instanceof DylanInteger) {
            DylanInteger dylanInteger = (DylanInteger)dylanObjectArray[0];
            DylanInteger dylanInteger2 = (DylanInteger)dylanObjectArray[1];
            return new DylanInteger(dylanInteger.mValue + dylanInteger2.mValue);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dylanObjectArray[0] instanceof DylanInteger) {
            d = ((DylanInteger)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            d = ((DylanFloat)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanInteger) {
            d2 = ((DylanInteger)dylanObjectArray[1]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanFloat) {
            d2 = ((DylanFloat)dylanObjectArray[1]).mValue;
        }
        return new DylanFloat(d + d2);
    }

    static DylanObject BinaryTimesNN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[0] instanceof DylanInteger && dylanObjectArray[1] instanceof DylanInteger) {
            DylanInteger dylanInteger = (DylanInteger)dylanObjectArray[0];
            DylanInteger dylanInteger2 = (DylanInteger)dylanObjectArray[1];
            return new DylanInteger(dylanInteger.mValue * dylanInteger2.mValue);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dylanObjectArray[0] instanceof DylanInteger) {
            d = ((DylanInteger)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            d = ((DylanFloat)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanInteger) {
            d2 = ((DylanInteger)dylanObjectArray[1]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanFloat) {
            d2 = ((DylanFloat)dylanObjectArray[1]).mValue;
        }
        return new DylanFloat(d * d2);
    }

    static DylanObject BinaryDivideNN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (dylanObjectArray[0] instanceof DylanInteger && dylanObjectArray[1] instanceof DylanInteger) {
            DylanInteger dylanInteger = (DylanInteger)dylanObjectArray[0];
            DylanInteger dylanInteger2 = (DylanInteger)dylanObjectArray[1];
            if (dylanInteger2.mValue == 0L) {
                throw new DylanException(dylanStack, "Binary/ : Attempt to divide by zero.");
            }
            return new DylanInteger(dylanInteger.mValue / dylanInteger2.mValue);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dylanObjectArray[0] instanceof DylanInteger) {
            d = ((DylanInteger)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            d = ((DylanFloat)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanInteger) {
            d2 = ((DylanInteger)dylanObjectArray[1]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanFloat) {
            d2 = ((DylanFloat)dylanObjectArray[1]).mValue;
        }
        if (d2 == 0.0) {
            throw new DylanException(dylanStack, "Binary/ : Attempt to divide by zero.");
        }
        return new DylanFloat(d / d2);
    }

    static DylanObject BinaryMinusNN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[0] instanceof DylanInteger && dylanObjectArray[1] instanceof DylanInteger) {
            DylanInteger dylanInteger = (DylanInteger)dylanObjectArray[0];
            DylanInteger dylanInteger2 = (DylanInteger)dylanObjectArray[1];
            return new DylanInteger(dylanInteger.mValue - dylanInteger2.mValue);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dylanObjectArray[0] instanceof DylanInteger) {
            d = ((DylanInteger)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            d = ((DylanFloat)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanInteger) {
            d2 = ((DylanInteger)dylanObjectArray[1]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanFloat) {
            d2 = ((DylanFloat)dylanObjectArray[1]).mValue;
        }
        return new DylanFloat(d - d2);
    }

    static DylanObject UnaryDivideN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (dylanObjectArray[0] instanceof DylanInteger) {
            if (((DylanInteger)dylanObjectArray[0]).mValue == 0L) {
                throw new DylanException(dylanStack, "Unary/ : Attempt to divide by zero.");
            }
            return new DylanFloat(1L / ((DylanInteger)dylanObjectArray[0]).mValue);
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            if (((DylanFloat)dylanObjectArray[0]).mValue == 0.0) {
                throw new DylanException(dylanStack, "Unary/ : Attempt to divide by zero.");
            }
            return new DylanFloat(1.0 / ((DylanFloat)dylanObjectArray[0]).mValue);
        }
        return new DylanInteger(0L);
    }

    static DylanObject GetSlot(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (!(dylanObjectArray[1] instanceof DylanUserInstance)) {
            throw new DylanException(dylanStack, "Get-Slot : Second argument must be a user instance.");
        }
        return ((DylanUserInstance)dylanObjectArray[1]).GetSlot(((DylanKeyword)dylanObjectArray[0]).mValue, dylanFrame, dylanStack);
    }

    static DylanObject Head(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return ((DylanPair)dylanObjectArray[0]).mHead;
    }

    static DylanObject Tail(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return ((DylanPair)dylanObjectArray[0]).mTail;
    }

    static DylanObject IdQ(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanBoolean(dylanObjectArray[0] == dylanObjectArray[1]);
    }

    static DylanObject Time(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        return new DylanInteger(System.currentTimeMillis() / 1000L);
    }

    static DylanObject Truncate(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanInteger((long)((DylanFloat)dylanObjectArray[0]).mValue);
    }

    static DylanObject UnaryMinusN(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[0] instanceof DylanInteger) {
            return new DylanInteger(-((DylanInteger)dylanObjectArray[0]).mValue);
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            return new DylanFloat(-((DylanFloat)dylanObjectArray[0]).mValue);
        }
        return new DylanInteger(0L);
    }

    static DylanObject SuperClassP(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanBoolean(((DylanClass)dylanObjectArray[0]).Superclass((DylanClass)dylanObjectArray[1]));
    }

    static DylanObject Singleton(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanSingleton(dylanObjectArray[0]);
    }

    static DylanObject ShowGraphics(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Interpreter.mGraphics.resize((int)((DylanInteger)dylanObjectArray[0]).mValue, (int)((DylanInteger)dylanObjectArray[1]).mValue);
        Interpreter.mGraphics.show();
        return DylanBoolean.DylanFalse;
    }

    static DylanObject SetSlot(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (!(dylanObjectArray[1] instanceof DylanUserInstance)) {
            throw new DylanException(dylanStack, "Set-Slot : Second argument must be an instance of a user-defined class.");
        }
        return ((DylanUserInstance)dylanObjectArray[1]).SetSlot(((DylanKeyword)dylanObjectArray[0]).mValue, dylanObjectArray[2], dylanFrame, dylanStack);
    }

    static DylanObject IndexSetterV(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        long l = ((DylanInteger)dylanObjectArray[0]).mValue;
        Vector vector = ((DylanVector)dylanObjectArray[1]).mValues;
        DylanObject dylanObject = dylanObjectArray[2];
        if (l >= 0L && l < (long)vector.size()) {
            vector.setElementAt(dylanObject, (int)l);
            return dylanObject;
        }
        throw new DylanException(dylanStack, "Index-Setter : Attempt to set! beyond bounds.");
    }

    static DylanObject IndexS(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        int n = (int)((DylanInteger)dylanObjectArray[1]).mValue;
        StringBuffer stringBuffer = ((DylanString)dylanObjectArray[0]).mValue;
        if (n >= 0 && n < stringBuffer.length()) {
            return new DylanCharacter(stringBuffer.charAt(n));
        }
        return new DylanSimpleError(dylanStack, "Index : Index " + n + " out of bounds for \"" + stringBuffer + "\".");
    }

    static DylanObject IndexV(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        int n = (int)((DylanInteger)dylanObjectArray[1]).mValue;
        Vector vector = ((DylanVector)dylanObjectArray[0]).mValues;
        if (n >= 0 && n < vector.size()) {
            return (DylanObject)vector.elementAt(n);
        }
        return new DylanSimpleError(dylanStack, "Index : Index " + n + " out of bounds for vector.");
    }

    static DylanObject Instantiate(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        if (dylanObjectArray[0] instanceof DylanUserClass) {
            return new DylanUserInstance((DylanUserClass)dylanObjectArray[0], dylanFrame, dylanStack);
        }
        throw new DylanException(dylanStack, "Instantiate : Cannot use built-in types.");
    }

    static DylanObject LengthS(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanInteger(((DylanString)dylanObjectArray[0]).mValue.length());
    }

    static DylanObject LengthV(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanInteger(((DylanVector)dylanObjectArray[0]).mValues.size());
    }

    static DylanObject Line(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Graphics graphics = Interpreter.mGraphics.getGraphics();
        int n = mCurrentX + (int)((DylanInteger)dylanObjectArray[0]).mValue;
        int n2 = mCurrentY + (int)((DylanInteger)dylanObjectArray[1]).mValue;
        graphics.drawLine(mCurrentX, mCurrentY, n, n2);
        mCurrentX = n;
        mCurrentY = n2;
        return DylanBoolean.DylanTrue;
    }

    static DylanObject Load(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        String string = ((DylanString)dylanObjectArray[0]).mValue.toString();
        try {
            URL uRL = new URL(string);
            Interpreter.Evaluate(uRL);
            return DylanBoolean.DylanTrue;
        }
        catch (MalformedURLException malformedURLException) {
            throw new DylanException(dylanStack, "Load : Badly formed URL.  URL must point to server this applet came from.");
        }
        catch (IOException iOException) {
            throw new DylanException(dylanStack, "Load : There was a problem reading the file.  Make sure the URL is correct.");
        }
        catch (SecurityException securityException) {
            throw new DylanException(dylanStack, "Load : URL must point to the server from which you downloaded the applet.");
        }
    }

    static DylanObject LoadText(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        String string = ((DylanString)dylanObjectArray[0]).mValue.toString();
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            DylanList dylanList2 = new DylanEmptyList();
            String string2 = null;
            while ((string2 = dataInputStream.readLine()) != null) {
                dylanList2 = new DylanPair(new DylanString(string2), dylanList2);
            }
            return dylanList2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new DylanException(dylanStack, "Load-Text : Badly formed URL.  URL must point to server this applet came from.");
        }
        catch (IOException iOException) {
            throw new DylanException(dylanStack, "Load-Text : There was a problem reading the file.  Make sure the URL is correct.");
        }
    }

    static DylanObject ObjectClass(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return dylanObjectArray[0].mClass;
    }

    static DylanObject Oval(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Graphics graphics = Interpreter.mGraphics.getGraphics();
        graphics.drawOval((int)((DylanInteger)dylanObjectArray[0]).mValue, (int)((DylanInteger)dylanObjectArray[1]).mValue, (int)((DylanInteger)dylanObjectArray[2]).mValue, (int)((DylanInteger)dylanObjectArray[3]).mValue);
        return DylanBoolean.DylanTrue;
    }

    static DylanObject Rectangle(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Graphics graphics = Interpreter.mGraphics.getGraphics();
        graphics.drawRect((int)((DylanInteger)dylanObjectArray[0]).mValue, (int)((DylanInteger)dylanObjectArray[1]).mValue, (int)((DylanInteger)dylanObjectArray[2]).mValue, (int)((DylanInteger)dylanObjectArray[3]).mValue);
        return DylanBoolean.DylanTrue;
    }

    static DylanObject SetColor(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Graphics graphics = Interpreter.mGraphics.getGraphics();
        Color color = new Color((int)((DylanInteger)dylanObjectArray[0]).mValue, (int)((DylanInteger)dylanObjectArray[1]).mValue, (int)((DylanInteger)dylanObjectArray[2]).mValue);
        graphics.setColor(color);
        return DylanBoolean.DylanTrue;
    }

    static DylanObject MoveTo(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        Interpreter.mGraphics.getGraphics();
        mCurrentX = (int)((DylanInteger)dylanObjectArray[0]).mValue;
        mCurrentY = (int)((DylanInteger)dylanObjectArray[1]).mValue;
        return DylanBoolean.DylanTrue;
    }

    static DylanObject Pair(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanPair(dylanObjectArray[0], dylanObjectArray[1]);
    }

    static DylanObject Power(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        if (dylanObjectArray[0] instanceof DylanInteger && dylanObjectArray[1] instanceof DylanInteger) {
            DylanInteger dylanInteger = (DylanInteger)dylanObjectArray[0];
            DylanInteger dylanInteger2 = (DylanInteger)dylanObjectArray[1];
            long l = 1L;
            long l2 = 0L;
            while (l2 < dylanInteger2.mValue) {
                l *= dylanInteger.mValue;
                ++l2;
            }
            return new DylanInteger(l);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dylanObjectArray[0] instanceof DylanInteger) {
            d = ((DylanInteger)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[0] instanceof DylanFloat) {
            d = ((DylanFloat)dylanObjectArray[0]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanInteger) {
            d2 = ((DylanInteger)dylanObjectArray[1]).mValue;
        }
        if (dylanObjectArray[1] instanceof DylanFloat) {
            d2 = ((DylanFloat)dylanObjectArray[1]).mValue;
        }
        return new DylanFloat(Math.pow(d, d2));
    }

    static DylanObject Princ(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        DylanObject dylanObject = dylanObjectArray[0];
        if (dylanObject instanceof DylanString) {
            String string = ((DylanString)dylanObject).mValue.toString();
            Interpreter.mOut.appendText(string);
            Interpreter.mOut.repaint();
        } else {
            String string = dylanObject.toString();
            Interpreter.mOut.appendText(string);
            Interpreter.mOut.repaint();
        }
        return DylanBoolean.DylanTrue;
    }

    static DylanObject Random(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanInteger((int)(Math.random() * (double)((DylanInteger)dylanObjectArray[0]).mValue));
    }

    static DylanObject Sin(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanFloat(Math.sin(((DylanFloat)dylanObjectArray[0]).mValue));
    }

    static DylanObject Cos(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) {
        return new DylanFloat(Math.cos(((DylanFloat)dylanObjectArray[0]).mValue));
    }

    Primitives() {
    }
}

