/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanBoolean;
import Dylan.DylanEmptyList;
import Dylan.DylanException;
import Dylan.DylanFloat;
import Dylan.DylanInteger;
import Dylan.DylanKeyword;
import Dylan.DylanObject;
import Dylan.DylanPair;
import Dylan.DylanSimpleError;
import Dylan.DylanStack;
import Dylan.DylanString;
import Dylan.DylanSymbol;
import Dylan.DylanVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Vector;

public class Parser {
    DylanStack mStack;
    InputStream mInput;
    char mHead;
    boolean mDone;

    Parser(String string, DylanStack dylanStack) {
        this(new StringBufferInputStream(string), dylanStack);
    }

    Parser(InputStream inputStream, DylanStack dylanStack) {
        this.mInput = inputStream;
        this.mStack = dylanStack;
        this.mDone = false;
        this.mHead = (char)65535;
    }

    DylanObject Parse() throws DylanException {
        if (this.mHead == '\uffff') {
            this.Advance();
        }
        DylanObject dylanObject = this.ParseObject();
        this.EatWhite();
        return dylanObject;
    }

    void Advance() {
        try {
            this.mHead = (char)this.mInput.read();
        }
        catch (IOException iOException) {
            this.mDone = true;
        }
        this.mDone = this.mHead == '\uffff';
    }

    DylanObject ParseObject() throws DylanException {
        this.EatWhite();
        if (this.mDone) {
            return new DylanSimpleError(this.mStack, "Parse : Unexpected end of text.");
        }
        switch (this.mHead) {
            case '(': {
                this.Advance();
                return this.ParseList();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.ParseNumber();
            }
            case '\'': 
            case '`': {
                return this.ParseQuoted();
            }
            case '\"': {
                return this.ParseString();
            }
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '^': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
            case '~': {
                return this.ParseSymbol();
            }
            case ';': {
                this.EatComment();
                return this.ParseObject();
            }
            case '[': {
                this.Advance();
                return this.ParseVector();
            }
        }
        throw new DylanException(this.mStack, "Parse : Unknown character: 0x" + Integer.toString(this.mHead, 16) + "'.");
    }

    boolean IsSymbol(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '^': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    DylanObject ParseSymbol() {
        return this.ParseSymbol(new StringBuffer());
    }

    DylanObject ParseSymbol(StringBuffer stringBuffer) {
        stringBuffer.append(this.mHead);
        this.Advance();
        while (!this.mDone && this.IsSymbol(this.mHead)) {
            stringBuffer.append(this.mHead);
            this.Advance();
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ':') {
            stringBuffer.setLength(stringBuffer.length() - 1);
            return new DylanKeyword(stringBuffer);
        }
        if (stringBuffer.length() == 2 && stringBuffer.charAt(0) == '#') {
            char c = stringBuffer.charAt(1);
            if (c == 'T' || c == 't') {
                return DylanBoolean.DylanTrue;
            }
            if (c == 'F' || c == 'f') {
                return DylanBoolean.DylanFalse;
            }
        }
        return new DylanSymbol(stringBuffer);
    }

    DylanObject ParseList() throws DylanException {
        this.EatWhite();
        if (this.mDone) {
            throw new DylanException(this.mStack, "Parse : Unterminated list--too few ')')");
        }
        if (this.mHead == ')') {
            this.Advance();
            return new DylanEmptyList();
        }
        DylanObject dylanObject = this.ParseObject();
        DylanObject dylanObject2 = this.ParseList();
        return new DylanPair(dylanObject, dylanObject2);
    }

    DylanObject ParseQuoted() throws DylanException {
        this.Advance();
        this.EatWhite();
        DylanObject dylanObject = this.ParseObject();
        return new DylanPair(new DylanSymbol("quote"), new DylanPair(dylanObject, new DylanEmptyList()));
    }

    long ValueOf(char c) {
        switch (c) {
            case '1': {
                return 1L;
            }
            case '2': {
                return 2L;
            }
            case '3': {
                return 3L;
            }
            case '4': {
                return 4L;
            }
            case '5': {
                return 5L;
            }
            case '6': {
                return 6L;
            }
            case '7': {
                return 7L;
            }
            case '8': {
                return 8L;
            }
            case '9': {
                return 9L;
            }
        }
        return 0L;
    }

    DylanObject ParseNumber() {
        long l = 0L;
        long l2 = 1L;
        if (this.mHead == '-') {
            l2 = -1L;
            this.Advance();
        }
        if (!this.mDone && !Character.isDigit(this.mHead)) {
            if (Character.isSpace(this.mHead)) {
                return new DylanSymbol("-");
            }
            this.ParseSymbol(new StringBuffer("-" + this.mHead));
        }
        while (!this.mDone && Character.isDigit(this.mHead)) {
            l *= 10L;
            l += this.ValueOf(this.mHead);
            this.Advance();
        }
        if (!this.mDone && this.mHead == '.') {
            double d = l;
            double d2 = 0.1;
            this.Advance();
            while (!this.mDone && Character.isDigit(this.mHead)) {
                d += d2 * (double)this.ValueOf(this.mHead);
                d2 /= 10.0;
                this.Advance();
            }
            return new DylanFloat((double)l2 * d);
        }
        return new DylanInteger(l2 * l);
    }

    DylanObject ParseString() throws DylanException {
        this.Advance();
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.mDone && this.mHead != '\"') {
            stringBuffer.append(this.mHead);
            this.Advance();
        }
        if (this.mHead == '\"') {
            this.Advance();
            return new DylanString(stringBuffer);
        }
        throw new DylanException(this.mStack, "Parse : Unterminated string.");
    }

    DylanObject ParseVector() throws DylanException {
        Vector<DylanObject> vector = new Vector<DylanObject>();
        while (!this.mDone && this.mHead != ']') {
            DylanObject dylanObject = this.ParseObject();
            vector.addElement(dylanObject);
            this.EatWhite();
        }
        if (!this.mDone) {
            this.Advance();
            return new DylanVector(vector);
        }
        throw new DylanException(this.mStack, "Parse : Unterminated vector--too few ']'s");
    }

    void EatWhite() {
        while (!this.mDone && Character.isSpace(this.mHead)) {
            this.Advance();
        }
    }

    void EatComment() {
        while (!this.mDone && this.mHead != '\n' && this.mHead != '\r') {
            this.Advance();
        }
    }
}

