/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanClass;
import Dylan.DylanContException;
import Dylan.DylanException;
import Dylan.DylanFrame;
import Dylan.DylanGenericFunction;
import Dylan.DylanMethod;
import Dylan.DylanObject;
import Dylan.DylanParameter;
import Dylan.DylanSimpleError;
import Dylan.DylanSingleton;
import Dylan.DylanStack;
import Dylan.DylanString;
import Dylan.FrameInspector;
import Dylan.Parser;
import Dylan.Primitive;
import Dylan.SpecialForm;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class Interpreter {
    public static DylanFrame mGlobalEnvironment = null;
    public static DylanStack mMainStack = null;
    public static Vector mInput = new Vector();
    static boolean mDebug = true;
    static TextArea mOut = null;
    static Frame mGraphics = null;
    public static DylanContException mCont = new DylanContException();
    public static boolean mUseCont;
    public static String mUserRead;
    public static boolean mUserReadPending;

    public Interpreter(TextArea textArea, String string) {
        DylanClass.InitializeClasses();
        mGlobalEnvironment = new DylanFrame("Global");
        mMainStack = new DylanStack(mGlobalEnvironment, "Main");
        mOut = textArea;
        Frame frame = new Frame("NOODLLE Graphics Console");
        frame.setResizable(true);
        frame.setTitle("NOODLLE Graphics Console");
        mGraphics = frame;
        DylanClass.mClassOrder = 0L;
        Interpreter.InitializeSpecialForms();
        Interpreter.InitializePrimitives();
        Interpreter.InitializeClassValues();
        Interpreter.InitializeInitDotDyl(string);
    }

    public static DylanObject Evaluate(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            return Interpreter.Evaluate(inputStream);
        }
        catch (MalformedURLException malformedURLException) {
            return new DylanSimpleError(mMainStack, "Bad URL in evaluate.");
        }
        catch (IOException iOException) {
            return new DylanSimpleError(mMainStack, "Bad I/O operation in evaluate.");
        }
    }

    public static DylanObject Evaluate(InputStream inputStream) {
        DylanObject dylanObject;
        Parser parser = new Parser(inputStream, mMainStack);
        do {
            try {
                DylanObject dylanObject2 = parser.Parse();
                dylanObject = dylanObject2.Evaluate(mGlobalEnvironment, mMainStack, false);
            }
            catch (DylanException dylanException) {
                new FrameInspector(dylanException.mError);
                return dylanException.mError;
            }
            catch (StackOverflowError stackOverflowError) {
                return new DylanSimpleError(mMainStack, "Java runtime stack overflow.");
            }
        } while (!parser.mDone);
        return dylanObject;
    }

    public static DylanObject Evaluate(String string) {
        return Interpreter.Evaluate(new StringBufferInputStream(string));
    }

    static void Print(String string) {
        mOut.appendText(string);
        mOut.repaint();
    }

    static void Print(DylanObject dylanObject) {
        if (dylanObject instanceof DylanString) {
            String string = ((DylanString)dylanObject).mValue.toString();
            mOut.appendText(string);
            mOut.repaint();
            return;
        }
        String string = dylanObject.toString();
        mOut.appendText(string);
        mOut.repaint();
    }

    static void InitializeSpecialForms() {
        mGlobalEnvironment.Bind("add-method", (DylanObject)new SpecialForm("add-method", 1));
        mGlobalEnvironment.Bind("begin", (DylanObject)new SpecialForm("begin", 3));
        mGlobalEnvironment.Bind("bind", (DylanObject)new SpecialForm("bind", 0));
        mGlobalEnvironment.Bind("bind-methods", (DylanObject)new SpecialForm("bind-methods", 4));
        mGlobalEnvironment.Bind("cond", (DylanObject)new SpecialForm("cond", 5));
        mGlobalEnvironment.Bind("define", (DylanObject)new SpecialForm("define", 6));
        mGlobalEnvironment.Bind("define-class", (DylanObject)new SpecialForm("define-class", 7));
        mGlobalEnvironment.Bind("define-generic-function", (DylanObject)new SpecialForm("define-generic-function", 8));
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("slot", DylanClass.DylanKeywordClass), new DylanParameter("instance")};
        mGlobalEnvironment.Bind("get-slot", (DylanObject)new Primitive("get-slot", dylanParameterArray, null, 18));
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("slot", DylanClass.DylanKeywordClass), new DylanParameter("instance"), new DylanParameter("new-value")};
        mGlobalEnvironment.Bind("set-slot!", (DylanObject)new Primitive("set-slot!", dylanParameterArray2, null, 40));
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{new DylanParameter("i", DylanClass.DylanIntegerClass), new DylanParameter("v", DylanClass.DylanVectorClass), new DylanParameter("o", DylanClass.DylanObjectClass)};
        mGlobalEnvironment.Bind("index-setter!", (DylanObject)new Primitive("index-setter!", dylanParameterArray3, null, 23));
        mGlobalEnvironment.Bind("if", (DylanObject)new SpecialForm("if", 9));
        mGlobalEnvironment.Bind("quote", (DylanObject)new SpecialForm("quote", 13));
        mGlobalEnvironment.Bind("macro", (DylanObject)new SpecialForm("macro", 10));
        mGlobalEnvironment.Bind("method", (DylanObject)new SpecialForm("method", 11));
        mGlobalEnvironment.Bind("set!", (DylanObject)new SpecialForm("set!", 14));
        mGlobalEnvironment.Bind("when", (DylanObject)new SpecialForm("when", 15));
        mGlobalEnvironment.Bind("while", (DylanObject)new SpecialForm("while", 16));
    }

    static void InitializePrimitives() {
        Interpreter.InitializeArithmetic();
        Interpreter.InitializeComparisons();
        Interpreter.InitializeListOperations();
        Interpreter.InitializeGraphics();
        Interpreter.InitializeMath();
        mGlobalEnvironment.Bind("and", (DylanObject)new SpecialForm("and", 2));
        mGlobalEnvironment.Bind("or", (DylanObject)new SpecialForm("or", 12));
        Interpreter.InitializeConversions();
        Interpreter.InitializeCollections();
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("f", DylanClass.DylanFunctionClass), new DylanParameter("args", DylanClass.DylanListClass)};
        mGlobalEnvironment.Bind("apply", (DylanObject)new Primitive("apply", dylanParameterArray, null, 0));
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("URL", DylanClass.DylanStringClass)};
        mGlobalEnvironment.Bind("load", (DylanObject)new Primitive("load", dylanParameterArray2, null, 28));
        mGlobalEnvironment.Bind("load-text", (DylanObject)new Primitive("load-text", dylanParameterArray2, null, 29));
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{};
        mGlobalEnvironment.Bind("read", (DylanObject)new Primitive("read", dylanParameterArray3, null, 37));
        DylanParameter[] dylanParameterArray4 = new DylanParameter[]{new DylanParameter("class", DylanClass.DylanClassClass)};
        mGlobalEnvironment.Bind("instantiate", (DylanObject)new Primitive("instantiate", dylanParameterArray4, null, 24));
        DylanParameter[] dylanParameterArray5 = new DylanParameter[]{new DylanParameter("obj")};
        mGlobalEnvironment.Bind("object-class", (DylanObject)new Primitive("object-class", dylanParameterArray5, null, 31));
        DylanParameter[] dylanParameterArray6 = new DylanParameter[]{new DylanParameter("c1", DylanClass.DylanClassClass), new DylanParameter("c2", DylanClass.DylanClassClass)};
        mGlobalEnvironment.Bind("super-class?", (DylanObject)new Primitive("super-class?", dylanParameterArray6, null, 44));
        DylanParameter[] dylanParameterArray7 = new DylanParameter[]{new DylanParameter("o")};
        DylanMethod[] dylanMethodArray = new DylanMethod[]{new Primitive("princ", dylanParameterArray7, null, 35)};
        mGlobalEnvironment.Bind("princ", (DylanObject)new DylanGenericFunction("princ", dylanParameterArray7, null, dylanMethodArray));
        mGlobalEnvironment.Bind("ps1", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps1.dyl"));
        mGlobalEnvironment.Bind("ps2", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps2.dyl"));
        mGlobalEnvironment.Bind("ps3", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps3.dyl"));
        mGlobalEnvironment.Bind("ps4", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps4.dyl"));
        mGlobalEnvironment.Bind("ps5", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps5.dyl"));
        mGlobalEnvironment.Bind("ps6", (DylanObject)new DylanString("http://dave.cs.cornell.edu/~aferencz/NOODLLE/ps6.dyl"));
        mGlobalEnvironment.Bind("newline", (DylanObject)new DylanString("\n"));
        DylanParameter[] dylanParameterArray8 = new DylanParameter[]{new DylanParameter("max", DylanClass.DylanIntegerClass)};
        mGlobalEnvironment.Bind("random", (DylanObject)new Primitive("random", dylanParameterArray8, null, 36));
        DylanParameter[] dylanParameterArray9 = new DylanParameter[]{new DylanParameter("obj")};
        mGlobalEnvironment.Bind("singleton", (DylanObject)new Primitive("singleton", dylanParameterArray9, null, 43));
        DylanParameter[] dylanParameterArray10 = new DylanParameter[]{};
        mGlobalEnvironment.Bind("time", (DylanObject)new Primitive("time", dylanParameterArray10, null, 46));
        DylanParameter[] dylanParameterArray11 = new DylanParameter[]{new DylanParameter("message", DylanClass.DylanStringClass)};
        mGlobalEnvironment.Bind("error", (DylanObject)new Primitive("error", dylanParameterArray11, null, 17));
    }

    static void InitializeLogical() {
        mGlobalEnvironment.Bind("and", (DylanObject)new SpecialForm("and", 2));
        mGlobalEnvironment.Bind("or", (DylanObject)new SpecialForm("or", 12));
    }

    static void InitializeMath() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("theta", DylanClass.DylanNumberClass)};
        mGlobalEnvironment.Bind("sin", (DylanObject)new Primitive("sin", dylanParameterArray, null, 42));
        mGlobalEnvironment.Bind("cos", (DylanObject)new Primitive("cos", dylanParameterArray, null, 16));
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("theta", DylanClass.DylanNumberClass)};
        mGlobalEnvironment.Bind("truncate", (DylanObject)new Primitive("truncate", dylanParameterArray2, null, 47));
    }

    static void InitializeGraphics() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("width", DylanClass.DylanIntegerClass), new DylanParameter("height", DylanClass.DylanIntegerClass)};
        mGlobalEnvironment.Bind("show-graphics", (DylanObject)new Primitive("show-graphics", dylanParameterArray, null, 41));
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("x", DylanClass.DylanIntegerClass), new DylanParameter("y", DylanClass.DylanIntegerClass)};
        mGlobalEnvironment.Bind("move-to", (DylanObject)new Primitive("move-to", dylanParameterArray2, null, 30));
        new DylanParameter("dx", DylanClass.DylanIntegerClass);
        mGlobalEnvironment.Bind("line", (DylanObject)new Primitive("line-to", dylanParameterArray2, null, 27));
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{new DylanParameter("x1", DylanClass.DylanIntegerClass), new DylanParameter("y1", DylanClass.DylanIntegerClass), new DylanParameter("x2", DylanClass.DylanIntegerClass), new DylanParameter("y2", DylanClass.DylanIntegerClass)};
        mGlobalEnvironment.Bind("rectangle", (DylanObject)new Primitive("rectangle", dylanParameterArray3, null, 38));
        DylanParameter[] dylanParameterArray4 = dylanParameterArray3;
        mGlobalEnvironment.Bind("oval", (DylanObject)new Primitive("oval", dylanParameterArray4, null, 32));
        DylanParameter[] dylanParameterArray5 = new DylanParameter[]{new DylanParameter("r", DylanClass.DylanIntegerClass), new DylanParameter("g", DylanClass.DylanIntegerClass), new DylanParameter("b", DylanClass.DylanIntegerClass)};
        mGlobalEnvironment.Bind("set-color", (DylanObject)new Primitive("set-color", dylanParameterArray5, null, 39));
    }

    static void InitializeArithmetic() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("X"), new DylanParameter("Y")};
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("X")};
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{new DylanParameter("X", DylanClass.DylanNumberClass), new DylanParameter("Y", DylanClass.DylanNumberClass)};
        DylanParameter[] dylanParameterArray4 = new DylanParameter[]{new DylanParameter("X", DylanClass.DylanNumberClass)};
        DylanMethod[] dylanMethodArray = new DylanMethod[]{new Primitive("binary+", dylanParameterArray3, null, 12)};
        DylanMethod[] dylanMethodArray2 = new DylanMethod[]{new Primitive("binary*", dylanParameterArray3, null, 13)};
        DylanMethod[] dylanMethodArray3 = new DylanMethod[]{new Primitive("binary-", dylanParameterArray3, null, 15)};
        DylanMethod[] dylanMethodArray4 = new DylanMethod[]{new Primitive("unary-", dylanParameterArray4, null, 48)};
        DylanMethod[] dylanMethodArray5 = new DylanMethod[]{new Primitive("binary/", dylanParameterArray3, null, 14)};
        DylanMethod[] dylanMethodArray6 = new DylanMethod[]{new Primitive("unary/", dylanParameterArray4, null, 49)};
        mGlobalEnvironment.Bind("binary+", (DylanObject)new DylanGenericFunction("binary+", dylanParameterArray, null, dylanMethodArray));
        mGlobalEnvironment.Bind("binary*", (DylanObject)new DylanGenericFunction("binary*", dylanParameterArray, null, dylanMethodArray2));
        mGlobalEnvironment.Bind("binary-", (DylanObject)new DylanGenericFunction("binary-", dylanParameterArray, null, dylanMethodArray3));
        mGlobalEnvironment.Bind("unary-", (DylanObject)new DylanGenericFunction("unary-", dylanParameterArray2, null, dylanMethodArray4));
        mGlobalEnvironment.Bind("binary/", (DylanObject)new DylanGenericFunction("binary/", dylanParameterArray, null, dylanMethodArray5));
        mGlobalEnvironment.Bind("unary/", (DylanObject)new DylanGenericFunction("unary/", dylanParameterArray2, null, dylanMethodArray6));
        DylanParameter[] dylanParameterArray5 = new DylanParameter[]{new DylanParameter("base", DylanClass.DylanNumberClass), new DylanParameter("exp", DylanClass.DylanNumberClass)};
        mGlobalEnvironment.Bind("^", (DylanObject)new Primitive("^", dylanParameterArray5, null, 34));
    }

    static void InitializeInitDotDyl(String string) {
        try {
            Interpreter.Evaluate(new URL(string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    static void InitializeListOperations() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("P", DylanClass.DylanPairClass)};
        mGlobalEnvironment.Bind("head", (DylanObject)new Primitive("head", dylanParameterArray, null, 19));
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("P"), new DylanParameter("Q")};
        mGlobalEnvironment.Bind("pair", (DylanObject)new Primitive("pair", dylanParameterArray2, null, 33));
        DylanParameter[] dylanParameterArray3 = dylanParameterArray;
        mGlobalEnvironment.Bind("tail", (DylanObject)new Primitive("tail", dylanParameterArray3, null, 45));
    }

    static void InitializeConversions() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("m", DylanClass.DylanClassClass), new DylanParameter("n")};
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanFloatClass)), new DylanParameter("n", DylanClass.DylanIntegerClass)};
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanCharacterClass)), new DylanParameter("n", DylanClass.DylanIntegerClass)};
        DylanParameter[] dylanParameterArray4 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanIntegerClass)), new DylanParameter("n", DylanClass.DylanCharacterClass)};
        DylanParameter[] dylanParameterArray5 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanStringClass)), new DylanParameter("n", DylanClass.DylanListClass)};
        DylanParameter[] dylanParameterArray6 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanSymbolClass)), new DylanParameter("n", DylanClass.DylanStringClass)};
        DylanParameter[] dylanParameterArray7 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanSymbolClass)), new DylanParameter("n", DylanClass.DylanKeywordClass)};
        DylanParameter[] dylanParameterArray8 = new DylanParameter[]{new DylanParameter("m", new DylanSingleton(DylanClass.DylanVectorClass)), new DylanParameter("n", DylanClass.DylanListClass)};
        DylanMethod[] dylanMethodArray = new DylanMethod[]{new Primitive("as", dylanParameterArray2, null, 2), new Primitive("as", dylanParameterArray3, null, 1), new Primitive("as", dylanParameterArray4, null, 3), new Primitive("as", dylanParameterArray5, null, 5), new Primitive("as", dylanParameterArray6, null, 6), new Primitive("as", dylanParameterArray7, null, 4), new Primitive("as", dylanParameterArray8, null, 7)};
        mGlobalEnvironment.Bind("as", (DylanObject)new DylanGenericFunction("as", dylanParameterArray, null, dylanMethodArray));
    }

    static void InitializeCollections() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("c", DylanClass.DylanCollectionClass), new DylanParameter("i", DylanClass.DylanIntegerClass)};
        DylanParameter[] dylanParameterArray2 = new DylanParameter[]{new DylanParameter("c", DylanClass.DylanVectorClass), new DylanParameter("i", DylanClass.DylanIntegerClass)};
        DylanParameter[] dylanParameterArray3 = new DylanParameter[]{new DylanParameter("c", DylanClass.DylanStringClass), new DylanParameter("i", DylanClass.DylanIntegerClass)};
        DylanMethod[] dylanMethodArray = new DylanMethod[]{new Primitive("index", dylanParameterArray2, null, 22), new Primitive("index", dylanParameterArray3, null, 21)};
        mGlobalEnvironment.Bind("index", (DylanObject)new DylanGenericFunction("index", dylanParameterArray, null, dylanMethodArray));
        DylanParameter[] dylanParameterArray4 = new DylanParameter[]{new DylanParameter("c", DylanClass.DylanCollectionClass)};
        DylanParameter[] dylanParameterArray5 = new DylanParameter[]{new DylanParameter("s", DylanClass.DylanStringClass)};
        DylanParameter[] dylanParameterArray6 = new DylanParameter[]{new DylanParameter("v", DylanClass.DylanVectorClass)};
        DylanMethod[] dylanMethodArray2 = new DylanMethod[]{new Primitive("length", dylanParameterArray6, null, 26), new Primitive("length", dylanParameterArray5, null, 25)};
        mGlobalEnvironment.Bind("length", (DylanObject)new DylanGenericFunction("length", dylanParameterArray4, null, dylanMethodArray2));
        DylanParameter[] dylanParameterArray7 = new DylanParameter[]{new DylanParameter("c1", DylanClass.DylanCollectionClass), new DylanParameter("c2", DylanClass.DylanCollectionClass)};
        DylanParameter[] dylanParameterArray8 = new DylanParameter[]{new DylanParameter("c1", DylanClass.DylanVectorClass), new DylanParameter("c2", DylanClass.DylanVectorClass)};
        DylanParameter[] dylanParameterArray9 = new DylanParameter[]{new DylanParameter("c1", DylanClass.DylanStringClass), new DylanParameter("c2", DylanClass.DylanStringClass)};
        DylanMethod[] dylanMethodArray3 = new DylanMethod[]{new Primitive("binary-append", dylanParameterArray8, null, 9), new Primitive("binary-append", dylanParameterArray9, null, 8)};
        mGlobalEnvironment.Bind("binary-append", (DylanObject)new DylanGenericFunction("binary-append", dylanParameterArray7, null, dylanMethodArray3));
    }

    static void InitializeComparisons() {
        DylanParameter[] dylanParameterArray = new DylanParameter[]{new DylanParameter("m"), new DylanParameter("n")};
        DylanMethod[] dylanMethodArray = new DylanMethod[]{new Primitive("binary=", dylanParameterArray, null, 10)};
        mGlobalEnvironment.Bind("binary=", (DylanObject)new DylanGenericFunction("binary=", dylanParameterArray, null, dylanMethodArray));
        mGlobalEnvironment.Bind("id?", (DylanObject)new Primitive("id?", dylanParameterArray, null, 20));
        dylanMethodArray[0] = new Primitive("Binary>", dylanParameterArray, null, 11);
        mGlobalEnvironment.Bind("binary>", (DylanObject)new DylanGenericFunction("binary>", dylanParameterArray, null, dylanMethodArray));
    }

    static void InitializeClassValues() {
        mGlobalEnvironment.Bind("<object>", (DylanObject)DylanClass.DylanObjectClass);
        mGlobalEnvironment.Bind("<type>", (DylanObject)DylanClass.DylanTypeClass);
        mGlobalEnvironment.Bind("<class>", (DylanObject)DylanClass.DylanClassClass);
        mGlobalEnvironment.Bind("<boolean>", (DylanObject)DylanClass.DylanBooleanClass);
        mGlobalEnvironment.Bind("<character>", (DylanObject)DylanClass.DylanCharacterClass);
        mGlobalEnvironment.Bind("<collection>", (DylanObject)DylanClass.DylanCollectionClass);
        mGlobalEnvironment.Bind("<list>", (DylanObject)DylanClass.DylanListClass);
        mGlobalEnvironment.Bind("<pair>", (DylanObject)DylanClass.DylanPairClass);
        mGlobalEnvironment.Bind("<empty-list>", (DylanObject)DylanClass.DylanEmptyListClass);
        mGlobalEnvironment.Bind("<string>", (DylanObject)DylanClass.DylanStringClass);
        mGlobalEnvironment.Bind("<vector>", (DylanObject)DylanClass.DylanVectorClass);
        mGlobalEnvironment.Bind("<error>", (DylanObject)DylanClass.DylanErrorClass);
        mGlobalEnvironment.Bind("<simple-error>", (DylanObject)DylanClass.DylanSimpleErrorClass);
        mGlobalEnvironment.Bind("<type-error>", (DylanObject)DylanClass.DylanTypeErrorClass);
        mGlobalEnvironment.Bind("<function>", (DylanObject)DylanClass.DylanFunctionClass);
        mGlobalEnvironment.Bind("<method>", (DylanObject)DylanClass.DylanMethodClass);
        mGlobalEnvironment.Bind("<generic-function>", (DylanObject)DylanClass.DylanGenericFunctionClass);
        mGlobalEnvironment.Bind("<macro>", (DylanObject)DylanClass.DylanMacroClass);
        mGlobalEnvironment.Bind("<keyword>", (DylanObject)DylanClass.DylanKeywordClass);
        mGlobalEnvironment.Bind("<number>", (DylanObject)DylanClass.DylanNumberClass);
        mGlobalEnvironment.Bind("<integer>", (DylanObject)DylanClass.DylanIntegerClass);
        mGlobalEnvironment.Bind("<float>", (DylanObject)DylanClass.DylanFloatClass);
        mGlobalEnvironment.Bind("<singleton>", (DylanObject)DylanClass.DylanSingletonClass);
        mGlobalEnvironment.Bind("<symbol>", (DylanObject)DylanClass.DylanSymbolClass);
    }

    static {
        mUserRead = null;
    }
}

