/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanError;
import Dylan.DylanFrame;
import Dylan.DylanLocalFrame;
import Dylan.DylanStack;
import Dylan.Interpreter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.util.Enumeration;

public class FrameInspector
extends Frame {
    DylanStack mStackBase;
    DylanFrame mCurrentFrame;
    List mFrameList;
    List mStackList;
    List mBindingList;
    Label mMessage;

    public FrameInspector() {
        this(Interpreter.mMainStack, "Frame Inspector");
    }

    public FrameInspector(DylanError dylanError) {
        this(dylanError.mStack, dylanError.toString());
    }

    public FrameInspector(DylanStack dylanStack, String string) {
        super("Frame Inspector");
        this.mStackBase = dylanStack;
        this.resize(300, 400);
        this.show();
        this.mFrameList = new List(8, false);
        this.mStackList = new List(8, false);
        this.mBindingList = new List(10, false);
        Panel panel = new Panel();
        this.mMessage = new Label(string, 1);
        panel.add(this.mMessage);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", this.mFrameList);
        panel2.add("Center", this.mStackList);
        this.setLayout(new BorderLayout());
        this.add("North", panel);
        this.add("South", panel2);
        this.add("Center", this.mBindingList);
        while (dylanStack.mPrevious != null) {
            this.mStackList.addItem(dylanStack.mDebugName);
            dylanStack = dylanStack.mPrevious;
        }
        this.mStackList.addItem(dylanStack.mDebugName);
        this.mCurrentFrame = this.mStackBase.mEnv;
        this.UpdateFrames(this.mStackBase);
        this.UpdateBindings(this.mCurrentFrame);
        this.show();
    }

    void UpdateFrames(DylanStack dylanStack) {
        this.mFrameList.delItems(0, this.mFrameList.countItems() - 1);
        DylanFrame dylanFrame = dylanStack.mEnv;
        while (dylanFrame instanceof DylanLocalFrame) {
            this.mFrameList.addItem(dylanFrame.mDebugName);
            dylanFrame = ((DylanLocalFrame)dylanFrame).mPrevious;
        }
        this.mFrameList.addItem(dylanFrame.mDebugName);
    }

    void UpdateBindings(DylanFrame dylanFrame) {
        this.mBindingList.delItems(0, this.mBindingList.countItems() - 1);
        Enumeration enumeration = dylanFrame.mBindings.elements();
        Enumeration enumeration2 = dylanFrame.mBindings.keys();
        while (enumeration.hasMoreElements()) {
            this.mBindingList.addItem(enumeration2.nextElement().toString() + " = " + enumeration.nextElement().toString());
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.mFrameList = null;
            this.mBindingList = null;
            this.mMessage = null;
            ((Component)this).hide();
            this.dispose();
        }
        if (event.id == 701 && event.target == this.mFrameList) {
            DylanFrame dylanFrame = this.mCurrentFrame;
            int n = (Integer)event.arg;
            int n2 = 0;
            while (n2 < n) {
                dylanFrame = ((DylanLocalFrame)dylanFrame).mPrevious;
                ++n2;
            }
            this.UpdateBindings(dylanFrame);
            return true;
        }
        if (event.id == 701 && event.target == this.mStackList) {
            DylanStack dylanStack = this.mStackBase;
            int n = (Integer)event.arg;
            int n3 = 0;
            while (n3 < n) {
                dylanStack = dylanStack.mPrevious;
                ++n3;
            }
            this.mCurrentFrame = dylanStack.mEnv;
            this.UpdateFrames(dylanStack);
            this.UpdateBindings(this.mCurrentFrame);
            return true;
        }
        return super.handleEvent(event);
    }
}

