/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanException;
import Dylan.DylanFrame;
import Dylan.DylanObject;
import Dylan.DylanSlot;
import Dylan.DylanSlotDescriptor;
import Dylan.DylanStack;
import Dylan.DylanUserClass;
import java.util.Hashtable;

class DylanUserInstance
extends DylanObject {
    Hashtable mSlots;

    DylanUserInstance(DylanUserClass dylanUserClass, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        this.mClass = dylanUserClass;
        this.mSlots = new Hashtable();
        int n = 0;
        while (n < dylanUserClass.mSlots.size()) {
            DylanSlotDescriptor dylanSlotDescriptor = (DylanSlotDescriptor)dylanUserClass.mSlots.elementAt(n);
            this.mSlots.put(dylanSlotDescriptor.mName, new DylanSlot(dylanSlotDescriptor, dylanFrame, dylanStack));
            ++n;
        }
    }

    DylanObject GetSlot(String string, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        Object v = this.mSlots.get(string = string.toLowerCase());
        if (v != null) {
            if (((DylanSlot)v).mValue != null) {
                return ((DylanSlot)v).mValue;
            }
            throw new DylanException(dylanStack, "Attempt to get value of uninitialized slot.");
        }
        throw new DylanException(dylanStack, "Attempt to get non-existent slot value.");
    }

    DylanObject SetSlot(String string, DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        Object v = this.mSlots.get(string = string.toLowerCase());
        if (v != null) {
            ((DylanSlot)v).SetValue(dylanObject, dylanFrame, dylanStack);
            return dylanObject;
        }
        throw new DylanException(dylanStack, "Attempt to set non-existent slot value.");
    }
}

