/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanClass;
import Dylan.DylanException;
import Dylan.DylanFrame;
import Dylan.DylanFunction;
import Dylan.DylanList;
import Dylan.DylanObject;
import Dylan.DylanPair;
import Dylan.DylanParameter;
import Dylan.DylanStack;
import Dylan.DylanType;
import Dylan.Interpreter;

class DylanMethod
extends DylanFunction {
    DylanParameter[] mRequired;
    DylanParameter[] mKeyword;
    DylanParameter mRest;
    DylanMethod mNextMethod;
    long mSpecificity;

    DylanMethod(String string, DylanParameter[] dylanParameterArray, DylanParameter dylanParameter) {
        super(string);
        this.mClass = DylanClass.DylanMethodClass;
        this.mRequired = dylanParameterArray;
        this.mRest = dylanParameter;
        this.ComputeSpecificity();
    }

    DylanObject Apply(DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack, boolean bl) throws DylanException {
        int n = (dylanList = dylanList.EvalEach(dylanFrame, dylanStack)).Length();
        if (n < this.mRequired.length) {
            throw new DylanException(dylanStack, "Apply : Too few arguments in function " + this);
        }
        DylanObject[] dylanObjectArray = new DylanObject[this.mRequired.length];
        int n2 = 0;
        while (n2 < this.mRequired.length) {
            dylanObjectArray[n2] = ((DylanPair)dylanList).mHead;
            if (!this.mRequired[n2].mType.TypeCheck(dylanObjectArray[n2])) {
                throw new DylanException(dylanStack, dylanObjectArray[n2], this.mRequired[n2].mType);
            }
            dylanList = (DylanList)((DylanPair)dylanList).mTail;
            ++n2;
        }
        if (this.mRest == null && n > this.mRequired.length) {
            throw new DylanException(dylanStack, "Apply : Too many arguments in function " + this);
        }
        if (++DylanFrame.mDepth >= DylanFrame.mFrameLimit) {
            DylanFrame.mDepth = 0;
            throw new DylanException(dylanStack, "Apply : Dylan stack limit exceeded.");
        }
        if (Interpreter.mUseCont && bl) {
            --DylanFrame.mDepth;
            throw Interpreter.mCont.set(this, dylanObjectArray, dylanList);
        }
        DylanObject dylanObject = this.ApplyEvaluated(dylanObjectArray, dylanList, dylanFrame, dylanStack);
        --DylanFrame.mDepth;
        return dylanObject;
    }

    void ComputeSpecificity() {
        this.mSpecificity = 0L;
        long l = 1L;
        int n = this.mRequired.length - 1;
        while (n >= 0) {
            DylanType dylanType = this.mRequired[n].mType;
            this.mSpecificity += dylanType.GetOrder() * l;
            l *= 512L;
            --n;
        }
    }

    boolean Applicable(DylanObject[] dylanObjectArray) {
        boolean bl = true;
        int n = 0;
        while (n < this.mRequired.length) {
            bl = bl && this.mRequired[n].mType.TypeCheck(dylanObjectArray[n]);
            ++n;
        }
        return bl;
    }

    DylanObject ApplyEvaluated(DylanObject[] dylanObjectArray, DylanList dylanList, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        throw new DylanException(dylanStack, "Apply : Bad method in apply.");
    }

    public String toString() {
        String string = "{Method : " + this.mDebugName + " (";
        int n = 0;
        while (n < this.mRequired.length) {
            string = string + this.mRequired[n];
            ++n;
        }
        return string + ")}";
    }
}

