/*
 * Decompiled with CFR 0.152.
 */
package Dylan;

import Dylan.DylanException;
import Dylan.DylanObject;
import Dylan.DylanParameter;
import Dylan.DylanStack;
import java.util.Hashtable;

public class DylanFrame {
    public static int mFrameLimit = 50;
    public static int mDepth;
    String mDebugName;
    Hashtable mBindings;

    public DylanFrame(String string) {
        this.mDebugName = string;
        this.mBindings = new Hashtable();
    }

    void Bind(String string, DylanObject dylanObject) {
        this.mBindings.put(string.toLowerCase(), dylanObject);
    }

    void Bind(DylanParameter dylanParameter, DylanObject dylanObject) {
        this.Bind(dylanParameter.mVariable, dylanObject);
    }

    DylanObject Lookup(String string, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        String string2 = string.toLowerCase();
        Hashtable hashtable = this.FindTable(string2);
        if (hashtable == null) {
            throw new DylanException(dylanStack, "Unbound variable " + string);
        }
        return (DylanObject)hashtable.get(string2);
    }

    Hashtable FindTable(String string) {
        if (this.mBindings.containsKey(string)) {
            return this.mBindings;
        }
        return null;
    }

    void Set(String string, DylanObject dylanObject, DylanFrame dylanFrame, DylanStack dylanStack) throws DylanException {
        String string2 = string.toLowerCase();
        Hashtable hashtable = this.FindTable(string2);
        if (hashtable == null) {
            throw new DylanException(dylanStack, "Attempt to modify contents of unbound variable " + string);
        }
        hashtable.put(string2, dylanObject);
    }
}

