/*
 * Decompiled with CFR 0.152.
 */
import Dylan.Interpreter;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.Window;

public class Dylan
extends Applet
implements Runnable {
    static Interpreter mInterpreter;
    static TextArea mRecord;
    static ParenTextArea mEdit;
    static FrameWindow mCommandFrame;
    static CommandBar mCommand;
    static Thread mThread;
    static Thread mNThread;
    static String mEvalText;
    static String mInit;
    static String mUserName;
    static String mPassword;

    public static void main(String[] stringArray) {
        FrameWindow frameWindow = new FrameWindow("NOODLLE");
        new Window(frameWindow);
        frameWindow.resize(600, 400);
        frameWindow.show();
        Dylan dylan = new Dylan();
        if (stringArray.length == 1) {
            dylan.Go(frameWindow, stringArray[0]);
            return;
        }
        System.out.println("NOODLLE requires a URL pointing to init.dyl.");
    }

    public void init() {
        this.Go(this, this.getParameter("init"));
    }

    public void ClearBuffer() {
        mRecord.setText("");
    }

    public void TextOut(String string) {
        mRecord.appendText(string);
    }

    public String TextIn() {
        String string = mEdit.getText();
        mEdit.setText("");
        return string;
    }

    public void restart() {
        this.TextOut("Interpreter Restarting....\n");
        mInterpreter = new Interpreter(mRecord, mInit);
    }

    public void Go(Container container, String string) {
        mInit = string;
        mRecord = new TextArea();
        this.TextOut("aNother Object Oriented Dynamic Language Learning Environment.v1.03c\n");
        this.TextOut("Melissa Ho (melissa@cs.cornell.edu), Fall 1997\n");
        this.TextOut("CS212 Cornell University Department of Computer Science.\n");
        mRecord.setFont(new Font("Courier", 0, 12));
        mRecord.setEditable(false);
        mInterpreter = new Interpreter(mRecord, string);
        mEdit = new ParenTextArea(3, 80, this);
        mEdit.evalAll();
        mCommand = new CommandBar(this);
        container.setLayout(new BorderLayout());
        container.add("North", mCommand);
        container.add("Center", mRecord);
        container.add("South", mEdit);
        container.show();
    }

    public void Evaluate() {
        if (Interpreter.mUserReadPending) {
            Interpreter.mUserRead = this.TextIn();
            Interpreter.mUserReadPending = false;
            Dylan.mCommand.mEval.enable();
            return;
        }
        this.Evaluate(this.TextIn());
    }

    public void Evaluate(String string) {
        if (mThread != null && mThread.isAlive()) {
            return;
        }
        mEvalText = string;
        mThread = new Thread(this);
        mThread.start();
    }

    public void run() {
        this.TextOut("? " + mEvalText + "\n");
        this.TextOut("==> " + Interpreter.Evaluate(mEvalText) + "\n");
        mEdit.setText("");
    }

    static {
        mEvalText = "";
    }
}

