/*
 * Decompiled with CFR 0.152.
 */
import Dylan.DylanFrame;
import Dylan.FrameInspector;
import Dylan.Interpreter;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Panel;

class CommandBar
extends Panel {
    Dylan mOwner;
    Button mEdit;
    Button mRestart;
    Button mClear;
    Button mEval;
    Button mStop;
    Button mFrames;
    Checkbox mUseCont;
    Choice mFrameLimit;

    public CommandBar(Dylan dylan) {
        this.mOwner = dylan;
        this.mEdit = new Button("Edit");
        this.mRestart = new Button("Restart");
        this.mClear = new Button("Clear");
        this.mEval = new Button("Eval");
        this.mStop = new Button("Stop");
        this.mFrames = new Button("Frames...");
        this.mFrameLimit = new Choice();
        this.mFrameLimit.addItem("50 Stack Limit");
        this.mFrameLimit.addItem("100 Stack Limit");
        this.mFrameLimit.addItem("500 Stack Limit");
        this.mFrameLimit.addItem("1000 Stack Limit");
        this.mFrameLimit.addItem("5000 Stack Limit");
        this.mFrameLimit.select(3);
        this.mUseCont = new Checkbox("Tail Recursion");
        this.add(this.mEdit);
        this.add(this.mClear);
        this.add(this.mEval);
        this.add(this.mStop);
        this.add(this.mRestart);
        this.add(this.mFrames);
        this.add(this.mFrameLimit);
        this.add(this.mUseCont);
        this.mUseCont.setState(true);
        this.DoUseCont();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.mEdit) {
            this.DoEdit();
        } else if (event.target == this.mEval) {
            this.DoEval();
        } else if (event.target == this.mStop) {
            this.DoStop();
        } else if (event.target == this.mRestart) {
            this.DoRestart();
        } else if (event.target == this.mClear) {
            this.DoClear();
        } else if (event.target == this.mFrames) {
            this.DoFrames();
        } else if (event.target == this.mFrameLimit) {
            this.DoFrameLimit();
        } else if (event.target == this.mUseCont) {
            this.DoUseCont();
        } else {
            return false;
        }
        return true;
    }

    public void DoUseCont() {
        boolean bl;
        Interpreter interpreter = Dylan.mInterpreter;
        Interpreter.mUseCont = bl = this.mUseCont.getState();
    }

    public void DoEval() {
        this.mOwner.Evaluate();
    }

    public void DoStop() {
        if (Dylan.mThread != null) {
            Dylan.mThread.stop();
            this.mEval.enable();
        }
    }

    public void DoEdit() {
        new EditWindow(this.mOwner);
    }

    public void DoFrames() {
        new FrameInspector();
    }

    public void DoFrameLimit() {
        int[] nArray = new int[]{50, 100, 500, 1000, 5000};
        DylanFrame.mFrameLimit = nArray[this.mFrameLimit.getSelectedIndex()];
    }

    public void DoRestart() {
        this.mOwner.restart();
    }

    public void DoClear() {
        this.mOwner.ClearBuffer();
    }
}

