package cs2110.assignment3.swing;

import java.io.IOException;

// Used internally by ComparisonGUI.  Manages the contents of a cell in the species grid.
class Cell {

	protected Color currentColor;
	protected Color targetColor;
	protected ScalingImageButton image;

	protected Cell(ScalingImageButton imp) {
		image = imp;
		currentColor = new Color(1,1,1);
		targetColor = currentColor;
	}

	protected void setImageFile(String filename) throws IOException {
		image.loadImage(filename);
	}

	private void setColorImmediate(Color c) {
		currentColor = c;
		image.setBackground(c.toAwt());
	}

	protected void setColor(int red, int green, int blue) {
		setColor(new Color(red,green,blue));
	}

	protected void clearColor() {
		setColor(null);
	}

	protected void setColor(Color c) {
		if(c == null) 
			c = new Color(255,255,255);
		targetColor = c;
	}

	// seconds for color change
	private final static double COLOR_CHANGE_TIME = 0.2;

	protected void advanceColor(double dt) {
		if(currentColor.equals(targetColor)) return;
		setColorImmediate(currentColor.blend(targetColor,dt / COLOR_CHANGE_TIME));
	}
}
