package cs2110.assignment3;

import org.eclipse.swt.widgets.Display;

class ColorThread extends Thread {
	protected boolean running = false;

	private Cell[] cells;
	private Display display;

	public ColorThread(Display display, Cell[] cells) {
		super();
		this.cells = cells;
		this.display = display;
	}

	private int ms = 50;
	private double dt = (double) ms / 1000.0;

	public void run() {
		running = true;

		while(running) {
			try {
				sleep(ms);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				break;
			}
			if(running)
				display.asyncExec(new Runnable() { 
					public void run() {
						for(Cell c : cells) {
							c.advanceColor(dt);
						}
					}
				});

		}
	}
}
