package cs2110.assignment3;

import org.eclipse.swt.widgets.Display;

class Color {
	private double r;
	private double g;
	private double b;
	
	public Color(double red, double green, double blue) {
		this.r = red;
		this.g = green;
		this.b = blue;
	}
	
	public Color(int red, int green, int blue) {
		r = (double) red / 255.0;
		g = (double) green / 255.0;
		b = (double) blue / 255.0;
	}
	
	public boolean equals(Color other) {
		return (r == other.r) && (g == other.g) && (b == other.b);
	}
	
	public org.eclipse.swt.graphics.Color toEclipse(Display d) {
		return new org.eclipse.swt.graphics.Color(d, getRedInt(), getGreenInt(), getBlueInt());
	}
	
	public int getRedInt() {
		return (int) (255 * r);
	}
	
	public int getGreenInt() {
		return (int) (255 * g);
	}

	public int getBlueInt() {
		return (int) (255 * b);
	}

	protected Color blend(Color other, double d) {
		d = Math.min(1.0, d);
		return new Color(r * (1-d) + other.r * d, 
				g * (1-d) + other.g * d,
				b * (1-d) + other.b * d);		
	}

}
