package cs2110.assignment3;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;

class Cell {

	private Label imageLabel;
	private Composite parent;
	private int style;
	private ComparisonGUI app;
	private String imageFile;

	protected Color currentColor;
	protected Color targetColor;

	protected Cell(ComparisonGUI app, Composite parent) {
		this.style = SWT.FLAT;
		this.parent = parent;
		imageLabel = null;
		this.app = app;
		currentColor = new Color(1,1,1);
		targetColor = currentColor;
	}

	protected Label createImage() {
		imageLabel = new Label(parent, style);
		imageLabel.setVisible(true);
		imageLabel.addMouseListener(new CellMouseListener(this));
		return imageLabel;
	}

	protected void setImageFile(String filename) {
		imageFile = filename;
		assert imageLabel != null;

		// Load image
		Image image = new Image(imageLabel.getDisplay(),imageFile);

		// Scale image
		Image scaled = new Image(imageLabel.getDisplay(),
				image.getImageData().scaledTo(ComparisonGUI.CELL_WIDTH,ComparisonGUI.CELL_HEIGHT));

		// doesn't work.. apparently requires Cairo on Linux, don't know if it would work on Windows
		//Image scaled = resizeImage(image, ZooApp.CELL_WIDTH, ZooApp.CELL_HEIGHT);

		imageLabel.setVisible(true);
		imageLabel.setImage(scaled);
	}

	private void setColorImmediate(Color c) {
		currentColor = c;
		imageLabel.setBackground(c.toEclipse(imageLabel.getDisplay()));
	}
	
	public void setColor(int red, int green, int blue) {
		setColor(new Color(red,green,blue));
	}

	protected void clearColor() {
		setColor(null);
	}

	public void setColor(Color c) {
		if(c == null) 
			c = new Color(255,255,255);
		targetColor = c;
	}
	
	// seconds for color change
	private final static double COLOR_CHANGE_TIME = 0.2;
	
	protected void advanceColor(double dt) {
		if(currentColor.equals(targetColor)) return;
		setColorImmediate(currentColor.blend(targetColor,dt / COLOR_CHANGE_TIME));
	}
	
	private class CellMouseListener implements MouseListener {
		private Cell cell;

		public CellMouseListener(Cell cell) {
			this.cell = cell;
		}

		public void mouseDown(MouseEvent e) {
			this.cell.app.selectCell(this.cell);
		}

		public void mouseUp(MouseEvent e) {
			// do nothing
		}

		public void mouseDoubleClick(MouseEvent e) {
			// do nothing
		}
	}

	/* not working on systems without Cairo
	 private static Image resizeImage(Image image, int width, int height) {
	      if (image == null)
	         return null;
	      final Image scaled = new Image(Display.getDefault(), width, height);
	      GC gc = new GC(scaled);
	      gc.setAntialias(SWT.ON);
	      gc.setInterpolation(SWT.HIGH);
	      gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
	      gc.dispose();
	      return scaled;
	   } */
}
