import java.awt.*;
import java.awt.event.*;

/**
 * Dialog that pops up before a new game is started.
 */
class NewGameDialog extends Dialog {
	
	private MainWindow d_mainWindow;
	
	private TextField d_txtRows;
	private TextField d_txtCols;
	
    private CheckboxGroup d_grpPlayer;
    private Checkbox  d_chkPlayer1;
    private Checkbox  d_chkPlayer2;

    private CheckboxGroup d_grpGameType;
    private Checkbox d_chkFIARNormalType;
    private Checkbox d_chkFIARDiagsOnlyType;
	private Checkbox d_chkNoChecking;

	private Button d_btnOK;
	private Button d_btnCancel;
	
	private TextField d_txtMessageDisplay;

	public NewGameDialog(MainWindow w) {
		super(w, "New Game", true);
		d_mainWindow = w;
		
        setLayout(new GridLayout(9,1));

        // Board size info
		Label boardSizeLabel = new Label("Board Size", Label.CENTER);
		boardSizeLabel.setFont(new Font("SansSerif", Font.BOLD, 15));
        add(boardSizeLabel);
        
		Panel p1 = new Panel();
		p1.add(new Label("Rows", Label.CENTER));
		p1.add(new Label("Columns", Label.CENTER));
		add(p1);
		
		Panel p2 = new Panel();
		d_txtRows = new TextField("7");
		d_txtCols = new TextField("7");
		p2.add(d_txtRows);
		p2.add(d_txtCols);
		add(p2);
		
		// Which player goes first?
		Label firstPlayerLabel = new Label("Which player goes first", Label.CENTER);
		firstPlayerLabel.setFont(new Font("SansSerif", Font.BOLD, 15));
        add(firstPlayerLabel);
        
        Panel p3 = new Panel();
        d_grpPlayer = new CheckboxGroup();
        d_chkPlayer1 = new Checkbox("Player 1", d_grpPlayer, true);
        d_chkPlayer2 = new Checkbox("Player 2", d_grpPlayer, false);
        p3.add(d_chkPlayer1);
        p3.add(d_chkPlayer2);
		add(p3);
  
		// Type of Game?
		Label gameTypeLabel = new Label("Game Type", Label.CENTER);
		gameTypeLabel.setFont(new Font("SansSerif", Font.BOLD, 15));
        add(gameTypeLabel);
        
        Panel p4 = new Panel();
        d_grpGameType = new CheckboxGroup();
        d_chkFIARNormalType = new Checkbox("Four in a Row - All directions",
                                            d_grpGameType, true);
        d_chkFIARDiagsOnlyType = new Checkbox("Four in a Row - Diagonals only",
                                               d_grpGameType, false);
		d_chkNoChecking = new Checkbox("No checking", d_grpGameType, false);
        p4.add(d_chkFIARNormalType);
        p4.add(d_chkFIARDiagsOnlyType);
		p4.add(d_chkNoChecking);
		add(p4);

        // Ok and cancel buttons
		Panel p5 = new Panel();
     	d_btnOK = new Button("OK");
		d_btnCancel = new Button("Cancel");
		p5.add(d_btnOK);
		p5.add(d_btnCancel);
        add(p5);
		
		// Message display
		Panel p6 = new Panel();
		d_txtMessageDisplay = new TextField(20);
		d_txtMessageDisplay.setBackground(Color.lightGray);
		d_txtMessageDisplay.setEditable(false);
		p6.add(d_txtMessageDisplay);
        add(p6);
		
		addListeners();
		setBackground(Color.yellow);
		pack();
		show();
	}
	
	/** Add listener objects to appropriate controls.
	 */
	private void addListeners() {
		d_btnOK.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent evt) {

				// check that inputs were valid integers
				int rows = getNumRows();
				if (rows <= 0) {
					printMSG("Illegal Entry for Rows");
					return;
				}
				int cols = getNumCols();
				if (cols <= 0) {
					printMSG("Illegal Entry for Columns");
					return;
				}

                int playerToGoFirst = getPlayerToGoFirst();
                int gameType = getGameType();

				d_mainWindow.startNewGame(rows, cols, playerToGoFirst, gameType);
				setVisible(false);
				dispose();
			}
		});
        
		d_btnCancel.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setVisible(false);
				dispose();
			}
		});
	}

	/** @return int The number of rows desired.
	 */
	private int getNumRows() {
       try {
           return Integer.parseInt(d_txtRows.getText());
       } catch (NumberFormatException nfe) {
           return 0;
       }
    }

	/** @return int The number of columns desired.
	 */
	private int getNumCols() {
       try {
           return Integer.parseInt(d_txtCols.getText());
       } catch (NumberFormatException nfe) {
           return 0;
       }
    }

	/** @return int The player who should go first.
	 */
	private int getPlayerToGoFirst() {
        if (d_chkPlayer1.getState())
            return 1;
        else
            return 2;
	}

	/** @return int The type of game selected.
	 */
	private int getGameType() {
        if (d_chkFIARNormalType.getState())
            return IGameBoard.FIAR_NORMAL_GAMETYPE;
        else if (d_chkFIARDiagsOnlyType.getState())
            return IGameBoard.FIAR_DIAGONALS_ONLY_GAMETYPE;
        else
            return IGameBoard.NO_CHECKING_GAMETYPE;
	}

	/** Add a message to the message field.
	 */
	private void printMSG(String s) {
		d_txtMessageDisplay.setText(s);
	}
}

