/**
  * Interface for implementing a game board
  */
interface IGameBoard {
    /** 
      * Standard FIAR - four in a row, column or diagonal.
      * Program checks for winner.
      */
    int FIAR_NORMAL_GAMETYPE = 0;
    /** 
      * Four in a diagonal only.
      * Program checks for winner.
      */
    int FIAR_DIAGONALS_ONLY_GAMETYPE = 1;
    /** 
      * No checking.
      * Players decide the winner.
      */
    int NO_CHECKING_GAMETYPE = 2;

    /** 
      * @return ISlot[][] The slots in the game board
      */
    ISlot[][] get2DimArrayWithSlots();
    /** 
      * @return True If specified column number is legal for a move
      * on the game board.
      */
    boolean isLegalColumnNumber(int col);
    /** 
      * Inserts a slot in the game board for the specified column and player.
      * The type of slot inserted is dependent on the type of game
      * being played.
      * @return ISlot The slot was inserted. 
      */
    ISlot addPiece(int col, IPlayer p);
    /** 
      * @return int The number of columns in the game board. 
      */
    int getNumColumns();
    /** 
      * @return int The number of rows in the game board. 
      */
    int getNumRows();
}