/**
  * Interface for implementing the game of FIAR
  */
interface IGame {
    /** 
      * Makes the move in the specified column for the specified player
      * @return int The row number in which the move was made if legal move,
      *             otherwise value < 0.
      */
    int makeMove(int col, int playerNum);
    /** 
      * @return IPlayer The player who has this particular number.
      */
    IPlayer getPlayer(int playerNum);
    /** 
      * @return IPlayer The current player who made the last move.
      */
    IPlayer getCurrentPlayer();
    /** 
      * @return IPlayer The player who has won if the game is over,
      *                 otherwise null.
      */
    IPlayer getWinner();
    /** 
      * @return IGameBoard The game board on which the game is being played.
      */
    IGameBoard getGameBoard();
    /** 
      * @return True If the game is over.
      */
    boolean isGameOver();
}