import java.awt.Color;

/**
 * Implementation of IGame for FIAR.
 */
class GameImplementation implements IGame {
	
	private IGameBoard d_gameBoard;
	private IPlayer d_playerOne;
	private IPlayer d_playerTwo;
	private IPlayer d_currentPlayer;
	private IPlayer d_winner;
	
	public GameImplementation(int rows, int cols, int firstPlayer,
                              int gameType) {
		//setup a new game.	
		d_gameBoard = new GameBoard(rows, cols, gameType);
		d_playerOne = new Player(1, Color.red);
		d_playerTwo = new Player(2, Color.blue);
        switch(firstPlayer) {
            case 1: d_currentPlayer = d_playerOne; break;
            case 2: d_currentPlayer = d_playerTwo; break;
        }
	}
	
    /** 
      * @return IGameBoard The game board on which the game is being played.
      */
	public IGameBoard getGameBoard() {
		return d_gameBoard;
	}
	
    /** 
      * Makes the move in the specified column for the specified player
      * @return int The row number in which the move was made if legal move,
      *             otherwise value < 0.
      */
	public int makeMove(int col, int playerNum) {
		if (playerNum == 1) {
			return makeMove(col, d_playerOne);
		} else if (playerNum == 2) {
			return makeMove(col, d_playerTwo);
		} else {
			return -1;
		}
	}

	/** 
      * @return IPlayer The current player who made the last move.
      */
    public IPlayer getCurrentPlayer() {
		return d_currentPlayer;
	}
	
	/** 
      * @return IPlayer The player who has won if the game is over,
      *                 otherwise null.
      */
	public IPlayer getWinner() {
		return d_winner;
	}
	
	/** @return boolean Whether or not the game is over.
      */
    public boolean isGameOver() {
        return (d_winner != null);
    }   
	
    /** 
      * @return IPlayer The player who has this particular number.
      */
	public IPlayer getPlayer(int playerNum) {
		if (playerNum == 1) {
			return d_playerOne;
		} else if (playerNum == 2) {
			return d_playerTwo;
		} else {
			return null;
		}
	}
	
	/** Update the current player.
	 */
	private void changePlayer() {
		if (d_currentPlayer == d_playerOne) {
			d_currentPlayer = d_playerTwo;
		} else if (d_currentPlayer == d_playerTwo) {
			d_currentPlayer = d_playerOne;
		}
	}
	
    /** 
      * Makes the move in the specified column for the specified player
      * @return int The row number in which the move was made if legal move,
      *             otherwise value < 0.
      */
	private int makeMove(int col, IPlayer p) {
		ISlot newSlot = d_gameBoard.addPiece(col, p);
		if (newSlot == null) {
			return -1;
		} else {
            if (newSlot instanceof ISlotCheck) {
                if (((ISlotCheck)newSlot).checkForWinner(d_gameBoard)) {
					d_winner = newSlot.getPlayer();
				}
            }
			changePlayer();
            return newSlot.getRow();
        }
    }
	

}