/**
 * Implementation of an IGameBoard. 
 */
class GameBoard implements IGameBoard {
	
	private ISlot d_slots[][];
	private int d_currentRow[];
	private int d_gameType;
	
	public GameBoard(int width, int height) {
		d_slots = new ISlot[width][height];
		d_currentRow = new int[height];
		d_gameType = 0; //default game
	}
	
	public GameBoard(int width, int height, int gameType) {
		this(width, height);
		d_gameType = gameType;
	}
	
	/** @return ISlot[][] 2D Array of slots for this game board.
	 */
	public ISlot[][] get2DimArrayWithSlots() {
		return d_slots;
	}

	/** @return boolean Whether or not a piece could be added to the passed column.
	 */
	public boolean isLegalColumnNumber(int col) {
		return (col < d_currentRow.length && d_currentRow[col] < d_slots.length);
	}
	
	/** Adds a piece to the board.
	 * @return ISlot A reference to the slot object created.
	 */
	public ISlot addPiece(int col, IPlayer p) {
		if (p != null && isLegalColumnNumber(col)) {
			int row = d_currentRow[col];
			ISlot newSlot;
			switch (d_gameType) {
				case FIAR_NORMAL_GAMETYPE:
						newSlot = new FIARNormalSlot(row, col, p);
						break;
				case FIAR_DIAGONALS_ONLY_GAMETYPE:
						newSlot = new FIARDiagonalsSlot(row, col, p); 
						break;
				case NO_CHECKING_GAMETYPE:
						newSlot = new Slot(row, col, p);
						break;
				default:
						newSlot = new FIARNormalSlot(row, col, p);
			}
			d_slots[d_currentRow[col]][col] = newSlot;
			d_currentRow[col]++;
			return newSlot;
		}
		return null;
	}
	
	/** @return int The number of columns.
	 */
	public int getNumColumns() {
		return d_slots[0].length;
	}
	
	/** @return int The number of rows.
	 */
	public int getNumRows() {
		return d_slots.length;
	}
}
	
