import java.awt.*;

/**
 * Class for displaying contents of an IGameBoard.
 */ 
class GUIGameBoard extends Panel {

	private int d_rows;
	private int d_cols;
	
	private Label d_labelArray[][];
	
	public GUIGameBoard() {
		setBackground(Color.lightGray);
	}

	/** Reset this game board display.
	 */
	public void setNewGUIGameBoard(int rows, int cols) {
        d_rows = rows;
        d_cols = cols;
		layoutPanel();
	}
	
	/** Set up the display.
	 */
	private void layoutPanel() {
		this.removeAll();  //panel needs to be cleared
		setLayout(new GridLayout(d_rows+1, d_cols, 1, 1));
		
		//add column headers
		d_labelArray = new Label[d_rows][d_cols];
		for (int i = 0; i < d_cols; i++) {
			Label l = new Label("" + i);
			l.setAlignment(Label.CENTER);
			add(l);
		}
		
		//add label objects to panel
		for (int i = 0; i < d_rows; i++) {
			for (int j = 0; j < d_cols; j++) {
				d_labelArray[i][j] = new Label("");
				d_labelArray[i][j].setBackground(this.getBackground());
				add(d_labelArray[i][j]);
			}
		}
	}

    /** Drop a piece into the board.
     */
	public void addPiece(int row, int col, Color pieceColor) {
        if (d_labelArray != null)
            d_labelArray[getDisplayRow(row)][col].setBackground(pieceColor);
    }	

    /** While pieces are stored at the top of the array (meaning: if piece
     * a is dropped in a column first, and then piece b, piece a will be in
     * row 0, and piece b in row 1.  When displaying these pieces, we want the
     * earlier pieces to be displayed at the bottom.  The method performs
     * the calculation for that.
     */
    private int getDisplayRow(int row) {
        return d_rows - 1 - row;
    }
	
}