/**
 * This class starts the Game of FIAR and checks in every possible direction for a winner. 
 */
class FIARNormalSlot extends AbstractSlotCheck {

	public FIARNormalSlot(int row, int col, IPlayer p) {
		super(row, col, p);
	}
	
	public boolean checkForWinner(IGameBoard gb) {
		ISlot slots[][] = gb.get2DimArrayWithSlots();
        return (checkForWinnerVerticalSouth(slots) ||
                checkForWinnerHorizontal(slots) ||
                checkForWinnerDiagonals(slots));
	}
}

