/**
  * Abstract class for performing generic checkWinner tasks.
  */
abstract class AbstractSlotCheck extends Slot implements ISlotCheck {
	
	public AbstractSlotCheck(int row, int col, IPlayer p) {
        super(row, col , p);
    }
	
	protected boolean checkForValidNeighbor(int row, int col, ISlot[][] slots) {
	    return ((0 <= row && row < slots.length) &&
	            (0 <= col && col < slots[row].length) &&
	            slots[row][col] != null &&
                slots[row][col].getPlayer() == this.getPlayer());
    }

	protected boolean checkForWinnerVerticalSouth(ISlot[][] slots) {
        // Vertical (south)
        return (checkForValidNeighbor(d_row - 1, d_col, slots) &&
                checkForValidNeighbor(d_row - 2, d_col, slots) &&
                checkForValidNeighbor(d_row - 3, d_col, slots));
    }

	protected boolean checkForWinnerVerticalNorth(ISlot[][] slots) {
        // Vertical (north)
        return (checkForValidNeighbor(d_row + 1, d_col, slots) &&
                checkForValidNeighbor(d_row + 2, d_col, slots) &&
                checkForValidNeighbor(d_row + 3, d_col, slots));
    }

	protected boolean checkForWinnerHorizontal(ISlot[][] slots) {
		// Horizontal
        if (checkForValidNeighbor(d_row, d_col + 1, slots) && 
            checkForValidNeighbor(d_row, d_col + 2, slots) && 
            checkForValidNeighbor(d_row, d_col + 3, slots)) {
            return true;  // 1
        }
        if (checkForValidNeighbor(d_row, d_col + 1, slots) &&
            checkForValidNeighbor(d_row, d_col + 2, slots) &&
            checkForValidNeighbor(d_row, d_col - 1, slots)) {
            return true;  // 2
        }
        if (checkForValidNeighbor(d_row, d_col + 1, slots) &&
            checkForValidNeighbor(d_row, d_col - 1, slots) &&
            checkForValidNeighbor(d_row, d_col - 2, slots)) {
            return true;  // 3
        }
        if (checkForValidNeighbor(d_row, d_col - 1, slots) &&
            checkForValidNeighbor(d_row, d_col - 2, slots) &&
            checkForValidNeighbor(d_row, d_col - 3, slots)) {
            return true;  // 4
        }
        return false;
    }

	protected boolean checkForWinnerDiagonals(ISlot[][] slots) {
        // Diagonal; NW + SE
        if (checkForValidNeighbor(d_row + 1, d_col + 1, slots) && 
            checkForValidNeighbor(d_row + 2, d_col + 2, slots) && 
            checkForValidNeighbor(d_row + 3, d_col + 3, slots)) {
            return true;  // 1
        }
        if (checkForValidNeighbor(d_row + 1, d_col + 1, slots) &&
            checkForValidNeighbor(d_row + 2, d_col + 2, slots) &&
            checkForValidNeighbor(d_row - 1, d_col - 1, slots)) {
            return true;  // 2
        }
        if (checkForValidNeighbor(d_row + 1, d_col + 1, slots) &&
            checkForValidNeighbor(d_row - 1, d_col - 1, slots) &&
            checkForValidNeighbor(d_row - 2, d_col - 2, slots)) {
            return true;  // 3
        }
        if (checkForValidNeighbor(d_row - 1, d_col - 1, slots) &&
            checkForValidNeighbor(d_row - 2, d_col - 2, slots) &&
            checkForValidNeighbor(d_row - 3, d_col - 3, slots)) {
            return true;  // 4
        }
        
        // Diagonal: NE + SW
        if (checkForValidNeighbor(d_row - 1, d_col + 1, slots) && 
            checkForValidNeighbor(d_row - 2, d_col + 2, slots) && 
            checkForValidNeighbor(d_row - 3, d_col + 3, slots)) {
            return true;  // 1
        }
        if (checkForValidNeighbor(d_row - 1, d_col + 1, slots) &&
            checkForValidNeighbor(d_row - 2, d_col + 2, slots) &&
            checkForValidNeighbor(d_row + 1, d_col - 1, slots)) {
            return true;  // 2
        }
        if (checkForValidNeighbor(d_row - 1, d_col + 1, slots) &&
            checkForValidNeighbor(d_row + 1, d_col - 1, slots) &&
            checkForValidNeighbor(d_row + 2, d_col - 2, slots)) {
            return true;  // 3
        }
        if (checkForValidNeighbor(d_row + 1, d_col - 1, slots) &&
            checkForValidNeighbor(d_row + 2, d_col - 2, slots) &&
            checkForValidNeighbor(d_row + 3, d_col - 3, slots)) {
            return true;  // 4
        }
        return false;     
    }
		
	abstract public boolean checkForWinner(IGameBoard gb);

}

