# a4_test.py
# Prof. Lee, April 2020

import a3_classes as a3 # Shorter name for ease of reference
import a4
import testcase

import inspect  # For automatically getting function name
import sys      # For quitting cleanly


# Create some to-do lists

# Todo items I owe to each of my PhD students
owe_s1 = [a3.Task('camera-ready revisions', 8), a3.Task('revise slides', 1)]
owe_s2 = [a3.Task('review proof', 3)]
owe_s3 = []  # Currently I don't owe student3 anything, but tasks may get added

owe_students = [owe_s1, owe_s2, owe_s3]

research_todos = [a3.Task("NSF proposal response", 2),
                  owe_students,
                  a3.Task("Friday practice-talk feedback", 1)]

solncode = [a3.Task("printing", 1),
            a3.Task("counting", 1),
            a3.Task("nesting depth", 1)]

asst4 = [solncode,
      a3.Task("writeup", 6),
      a3.Task("pkg and post", 1),
      a3.Task("grading code and guide", 8)]

course = [asst4, a3.Task("lab 9", 10), a3.Task("A5", 20), a3.Task("lab 10", 11)]

my_todo_list = [research_todos, course]

def test_sum_hours(tl):
    fn_name = inspect.stack()[0][3]
    print("Running " + fn_name + ' .................')

    # format of each element:
    # item 0: tasklist
    # item 1: answer
    # item 2: mnemonic
    testcases = [
        [[], 0, "empty list"],
        [owe_s2, 3, "owe_s2"],
        [owe_students, 12, "owe_students"],
        [research_todos, 15, "research_todos"],
        [asst4, 18, "A4"],
        [course, 59, "course"],
        [my_todo_list, 74, "my_todo_list"]
        ]

    for tc in testcases:
        inputlist = tc[0]
        expected = tc[1]
        mnemonic = tc[2]
        assert isinstance(inputlist, list), "input " + repr(inputlist) + " not a list"

        print("Testing input " + mnemonic)

        output = a4.sum_hours(inputlist)
        testcase.assert_equals(expected, output)


    print("All test cases passed in " + fn_name + "\n")


def test_print_todo_list(verbose):
    fn_name = inspect.stack()[0][3]
    print("Running " + fn_name + ' .................')

    owes1_answer = 'BEGIN\n\tcamera: 8\n\trevise: 1\nEND'
    owes2_answer = 'BEGIN\n\treview: 3\n\tEND'
    owes3_answer = 'BEGIN\nEND'
    owe_students_answer = 'BEGIN\n'
    owe_students_answer += '\tBEGIN\n\t\tcamera: 8\n\t\trevise: 1\n\tEND\n'
    owe_students_answer += '\tBEGIN\n\t\treview: 3\n\tEND\n'
    owe_students_answer += '\tBEGIN\n\tEND\n'
    owe_students_answer += 'END'
    research_answer = 'BEGIN\n'
    research_answer += '\tNSF pr: 2\n'
    research_answer += '\tBEGIN\n'
    research_answer +=  '\t\tBEGIN\n\t\t\tcamera: 8\n\t\t\trevise: 1\n\t\tEND\n'
    research_answer += '\t\tBEGIN\n\t\t\treview: 3\n\t\tEND\n'
    research_answer += '\t\tBEGIN\n\t\tEND\n'
    research_answer += '\tEND\n'
    research_answer += '\tFriday: 1\n'
    research_answer += 'END'
    all_answer = 'BEGIN\n'
    all_answer += '\tBEGIN\n'
    all_answer += '\t\tNSF pr: 2\n'
    all_answer += '\t\tBEGIN\n'
    all_answer += '\t\t\tBEGIN\n'
    all_answer += '\t\t\t\tcamera: 8\n'
    all_answer += '\t\t\t\trevise: 1\n'
    all_answer += '\t\t\tEND\n'
    all_answer += '\t\t\tBEGIN\n'
    all_answer += '\t\t\t\treview: 3\n'
    all_answer += '\t\t\tEND\n'
    all_answer += '\t\t\tBEGIN\n'
    all_answer += '\t\t\tEND\n'
    all_answer += '\t\tEND\n\t\tFriday: 1\n'
    all_answer += '\tEND\n'
    all_answer += '\tBEGIN\n'
    all_answer += '\t\tBEGIN\n'
    all_answer += '\t\t\tBEGIN\n'
    all_answer += '\t\t\t\tprinti: 1\n'
    all_answer += '\t\t\t\tcounti: 1\n'
    all_answer += '\t\t\t\tnestin: 1\n'
    all_answer += '\t\t\tEND\n'
    all_answer += '\t\t\twriteu: 6\n'
    all_answer += '\t\t\tpkg an: 1\n'
    all_answer += '\t\t\tgradin: 8\n'
    all_answer += '\t\tEND\n'
    all_answer += '\t\tlab 9 : 10\n'
    all_answer += '\t\tA5    : 20\n'
    all_answer += '\t\tlab 10: 11\n'
    all_answer += '\tEND\n'
    all_answer += 'END'
    # Format of each item:
    # list with entry 0 == input to function,
    # entry 1 == expected
    # entry 2 == mnemonic for this test case for printout
    testcases = [
        [[], 'BEGIN\nEND', "empty list"],
        [owe_s1, owes1_answer, "owes_s1"],
        [owe_students, owe_students_answer, "owe_students"],
        [research_todos, research_answer, "research_todos"],
        [my_todo_list, all_answer, "my_todo_list"]
    ]

    for tc in testcases:
        inputlist = tc[0]
        expected = tc[1]
        mnemonic = tc[2]
        assert isinstance(inputlist, list), "input " + repr(inputlist) + " not a list"

        print("Testing input " + mnemonic)

        output = a4.todo_list_to_string(inputlist)
        try:
            testcase.assert_equals(expected, output)
            if verbose:
                print('The function was correct on this input, with output:')
                print(repr(output))
                print('Human-readable version:')
                print(output + '\n<output stopped here>\n')
        except:
            print()
            print('************** Error on ' + mnemonic + ' **************')
            print('What SHOULD have been the output:')
            print(repr(expected))
            print('Human-readable version:')
            print(expected)
            print("But the code's output is this:")
            print(repr(output))
            print('Human-readable version:')
            print(output + '\n<output stopped here>\n')

            expected_stripped = ''.join(expected.split())
            output_stripped = ''.join(output.split())
            print('What if we ignore whitespace in the output?')
            msg = 'Then your implementation is '
            if expected_stripped == output_stripped:
                msg += 'CORRECT ignoring spacing ... getting close!'
            else:
                msg += 'UNFORTUNATELY NOT CORRECT even ignoring spacing.'
            print(msg)
            exit()

    print("All test cases passed in " + fn_name + "\n")



def test_indentlines(verbose):
    fn_name = inspect.stack()[0][3]
    print("\nRunning " + fn_name + ' .................')

    # format of each test case:
    # item 0: input string; item 1: expected answer
    testcases = [
        ['abc', '\tabc'],
        ['abc\ndef\nghi', '\tabc\n\tdef\n\tghi'],
        ['\tabc\n\tdef\n\tghi', '\t\tabc\n\t\tdef\n\t\tghi']
    ]

    for tc in testcases:
        inputstr = tc[0]
        expected = tc[1]
        assert isinstance(inputstr, str), "input " + repr(inputstr) + " not a str"

        if verbose:
            print("testing input " + repr(inputstr))
        testcase.assert_equals(expected, a4.indentlines(inputstr))

    print("All test cases passed in " + fn_name + "\n")





def ask_to_quit(verbose):
    """Ask if user wishes to keep testing, terminate execution if not.
    Does nothing if `verbose` is False"""
    if verbose:
        msg = 'Press q to quit, anything else to start testing the next function. '
        response = input(msg)
        if response == "q":
            print("Remember that you haven't run all the tests in this file.")
            sys.exit()




# STUDENTS: the next line of code,
#     if __name__ == '__main__':
# ensures that the indented lines are only
# executed if this script is run at the command line (i.e., they are NOT run
# if this file is imported as a module)
if __name__ == '__main__':

    is_verbose = False # The staff set this to 'True' to generate examples

    testfns = [test_sum_hours, test_print_todo_list, test_indentlines]

    for testfn in testfns[:-1]:
        testfn(is_verbose)
        ask_to_quit(is_verbose)
    testfns[-1](is_verbose)

    print ("\n*** Got to the end of the testing file, probably good news!")
