# a4.py
# PUT YOUR NETID(S) HERE
# Sources/people consulted: FILL IN OR WRITE "NONE"
# PUT DATE YOU COMPLETED THIS HERE
# Skeleton by Prof. Lee and Will Xiao, Apr 21

# UPDATES AS OF APR 25
# (more details in updated handout):
# Fixed example in spec of todo_list_to_string().
# Fixed one-char typo in 3rd example in spec of indentlines().


import a3_classes

"""Functions for processing nested todo lists made up of Tasks and lists of
    Tasks.

    Technical point (don't sweat the details too much here.)
    We assume all (possibly nested, possibly empty) Tasks lists are well-formed,
    meaning, informally, speaking, that they are created by repeatedly making
    up a higher-order Task lists by combining sublists that don't have any
    common Tasks between them, and there's no repeated Tasks within a single list.
    Any sublists (or subsublists, or ...) are allowed to be empty.

    This way, you don't have to worry about things like Tasks occurring more
    than once in the same list
        Illegal for A4, but allowable Python:
            t = Task('a', 1)
            badlisthelper = [t, Task('b'), 2]
            badlist = [t, badlisthelper]
    or lists that contain themselves
        Illegal for A4, but allowable Python
            looplist = [Task('weird', 1)]
            looplist.append(looplist)

"""



# Students, no need to modify this helper function.
def task_to_string(t):
    """
    Returns: string of the form
        <name>[:6]: <lh>
    where t's name is <name> and length is <lh>,
    with spaces padding out the name if necessary.

    Preconditions: t is a Task (and not None)

    Examples:
        task_to_string(a3_classes.Task("write masterpiece", 10))
        --->  "write : 10"
        task_to_string(a3_classes.Task("A5", 20))
        --->  "A5    : 20"
    """
    return (t.name+' '*6)[:6] +  ": " + str(t.length)



def sum_hours(tlist):
    """Returns the number of hours it would take to finish all the tasks contained
    in the (possibly empty, possibly nested) Task list tlist.
    If tlist is empty, returns 0.

    Precondition: tlist is a list, possibly empty and possibly nested, of Tasks,
    and the same is true of any of its sublists, or subsublists, or ...

    Examples:
        owe_s1 = [a3_classes.Task('camera-ready revisions', 8),
                    a3_classes.Task('revise slides', 1)]
        owe_s2 = [a3_classes.Task('review proof', 3)]
        owe_s3 = []
        owe_students = [owe_s1, owe_s2, owe_s3]
        research_todos = [a3_classes.Task("NSF proposal response", 2),
                  owe_students,
                  a3_classes.Task("Friday practice-talk feedback", 1)]

        Then,
            owe_students --> 12
            research_todos --> 15
    """
    # Experience note: the parameter is named `tlist` instead of the
    # shorter "tl" to avoid confusion between "tl" (tee-ell) vs "t1" (tee-one).
    # A recommendation is to avoid having lower-case l ("ell") be the last
    # character in your variable names; tracking down bugs where Python is
    # claiming that "tl"/"t1" is undefined when you KNOW you defined "t1"/"tl"
    # higher up in your code is infuriating, but sadly not uncommon.
    # (Alternately, choose a font where ones and lower-case-ells are easy to
    # distinguish.)

    pass # IMPLEMENT ME.
         # 1. RECURSION MUST BE FUNDAMENTAL TO YOUR SOLUTION.
         # 2. USING `map` IS NOT ALLOWED.
         # 3. YOUR CODE MUST NOT ALTER THE INPUT LIST (IF A USER RUNS THIS
         #    FUNCTION ON A LIST X, X SHOULD REMAIN UNCHANGED AFTER FUNCTION
         #    EXECUTION
         # 4. APPROACHES BASED ON OPERATING ON A 'FLATTENED' VERSION OF `tlist`
         #    ARE NOT ALLOWED.
         #    (That is, for the purposes of this assignment,
         #    for a tlist like [t1, [t2, [t3], [t4, t5]]]
         #    do NOT convert it to or create a version [t1, t2, t3, t4, t5]
         #    and then just work with this flattened version, even if you were
         #    to use recursion to create the flattened version.



def todo_list_to_string(tlist):
    """Returns a string version of a (possibly nested, possibly empty) list of
    todo items tlist,
    each task on a separate line printed via task_to_string,
    each list, including the input `tlist` itself, delimited with a starting string
    'BEGIN\n' and ending string 'END'
    and each (sub)list's contents indented by one tab ('\t') per embedding level.
    When printed, this string shows the indent levels visually.

    Precondition: tlist is a list, possibly empty and possibly nested, of Tasks,
    and the same is true of any of its sublists, or subsublists, or ...


    Example:
    Suppose we set up `owe_students` as follows:
    owe_s1 = [a3_classes.Task('camera-ready revisions', 8),
                    a3_classes.Task('revise slides', 1)]
    owe_s2 = [a3_classes.Task('review proof', 3)]
    owe_s3 = []
    owe_students = [owe_s1, owe_s2, owe_s3]

    Then, the following very long string (broken up by "+" for readability) is
    the result of todo_list_to_string(owe_students):
    'BEGIN\n'
    +'\tBEGIN\n'
    +'\t\tcamera: 8\n'
    +'\t\trevise: 1\n'
    +'\tEND\n'
    +'\tBEGIN\n'
    +'\t\treview: 3\n'
    +'\tEND\n'
    +'\tBEGIN\n'
    +'\tEND\n'
    +'END'
    which, if printed via print(...), looks like this (yes, there's an empty list):
    BEGIN
        BEGIN
            camera: 8
            revise: 1
        END
        BEGIN
            review: 3
        END
        BEGIN
        END
    END
    """
    pass # IMPLEMENT ME.
         # 0. YOUR CODE SHOULD MAKE EFFECTIVE USE OF THE HELPER `indentlines()`
         # 1. RECURSION MUST BE FUNDAMENTAL TO YOUR SOLUTION.
         # 2. USING `map` IS NOT ALLOWED.
         # 3. YOUR CODE MUST NOT ALTER THE INPUT LIST (IF A USER RUNS THIS
         #    FUNCTION ON A LIST X, X SHOULD REMAIN UNCHANGED AFTER FUNCTION
         #    EXECUTION
         # 4. APPROACHES BASED ON OPERATING ON A 'FLATTENED' VERSION OF `tlist`
         #    ARE NOT ALLOWED.
         #    (That is, for the purposes of this assignment,
         #    for a tlist like [t1, [t2, [t3], [t4, t5]]]
         #    do NOT convert it to or create a version [t1, t2, t3, t4, t5]
         #    and then just work with this flattened version, even if you were
         #    to use recursion to create the flattened version
         #
         # Note: partial credit will be allotted if your implementation's
         # output's only problem is with spacing/indentation.
         # Therefore, we ***strongly*** suggest you first work on
         # this function, `todo_list_to_string`,  ***ignoring whether you get the
         # indentation right.***
         # (Our present to you:  Our testing function tells you whether your
         # output is right if whitespace is ignored, so do read its printouts
         # carefully.)
         #
         # When you think you've got the Tasks all getting printed out in the
         # right order, then you can work on indentlines() and then use indentlines
         # appropriately as a helper for this function.
         #
         # Then, re-test this function to see if you can get the output to be
         # perfect even with respect to indentation!
         #



def indentlines(line_str):
    """Returns a new string where each line in line_str has been indented by a tab
    character ('\t').

    Examples:
        'abc'   -->  '\tabc'
        'abc\ndef\nghi'  -->  '\tabc\n\tdef\n\tghi'
        '\tabc\n\tdef\n\tghi' -->    '\t\tabc\n\t\tdef\n\t\tghi'

    This function has the following nice effect, useful for other functions in A4.
    >>> from a4 import indentlines
    >>> s = 'abc\ndef\nghi'
    >>> print(s)
    abc
    def
    ghi
    >>> print(indentlines(s))
        abc
        def
        ghi
    >>> print(indentlines(indentlines(s)))
            abc
            def
            ghi

    Precondition: line_str is a non-empty string with no trailing whitespace
    (no tabs, newlines, or spaces at the end).
    Lines within line_str are delimited by the newline character '\n'.
    None of the lines in line_str are empty or contain only whitespace
    """
    return line_str # FIX ME *AFTER* WORKING ON todo_list_to_string.

    # This non-recursive helper function is worth very little credit;
    # the focus of this assignment is the naturally recursive functions
    # above.

    # HINT: it's possible to use the split() and join() methods as
    # introduced in the last slide of lecture 10 for a one-line solution!
    #
    # Otherwise, use a for-loop to on line_str (see Section 8.3 of the text),
    # copying its characters to a new output string except every time
    # you hit a '\n', add an extra '\t' to the output string.
    #
    # DON'T use recursion; this function isn't a natural fit for it.
    #
    # Note: string concatenation in Python via "+" or "+=" is slow,
    # but in CS1110 we're focusing on concepts, not efficiency.
    # For those curious about faster ways to concatenate many strings
    # together, see
    # https://docs.python.org/3/faq/programming.html
    # and search for "concatenate"

