# hand.py
# Steve Marschner (srm2) and Lillian Lee (ljl2)
# March 27, 2014
"""Lecture demo: class to represent poker hands.
"""

import card
import random

class Hand(object):
    """Instances represent a hand in poker.
    
    Instance variables:
        cards [list of Card]: cards in the hand
        
    This list is sorted according to the ordering defined by the Card class.
    """
    
    HAND_TYPE_NAMES = ["1 pair", "3 of a kind", "2 pair", "straight", "flush",
                       "full house", "4 of a kind", "straight flush"]
    NUM_HAND_TYPES = len(HAND_TYPE_NAMES)

    def __init__(self, deck, n):
        """Draw a hand of n cards.
        Pre: deck is a list of >= n cards.  Deck is shuffled.
        """
        self.cards = []
        for k in range(n):
            self.cards.append(deck.pop(0))
        self.cards.sort()
        
    def is_pair(self):
        """Return: This hand contains a pair."""
        pass

    def is_2pair(self):
        """Return: This hand contains two distinct pairs."""
        pass
    
    def is_3kind(self):
        """Return: This hand contains three of a kind."""
        pass
        
    def is_straight(self):
        """Return: This hand contains a 5-card straight."""
        pass
        
    def is_flush(self):
        """Return: This hand contains a flush."""
        pass
        
    def is_full_house(self):
        """Return: This hand contains a full house."""
        pass
        
    def is_4kind(self):
        """Return: True if this hand is 4 of a kind."""
        pass
    
    def is_straight_flush(self):
        """Return: True if this hand contains a 5-card straight.  That is, if it
        contains five cards that are all in sequence."""
        pass
        
    def get_types(self):
        """Return: a list of booleans indicating whether this hand is or is not
        each of the hand types, indexed like HAND_TYPE_NAMES."""
        return [self.is_pair(), self.is_3kind(), self.is_2pair(),
                self.is_straight(), self.is_flush(), self.is_full_house(),
                self.is_4kind(), self.is_straight_flush()]
        
    def __str__(self):
        return ', '.join(map(str, self.cards))
   





















""" To save typing in lecture:

  *or*
             text is a string of the form '3D 5H KS', consisting of two-
             character codes acceptable to card.Card separated by spaces.
"""
    #def _tally(self):
    #    """Return: a list of length card.MAX_RANK+2 (call it <counts>) in which
    #    counts[r] is the number of cards of rank r in the hand."""
    #    pass
    #
    #def _tally_single_suit(self, s):
    #    """Return: a list of length card.MAX_RANK+2 (call it <counts>) in which
    #    counts[r] is the number of cards of rank r and suit s in the hand."""
    #    pass
    #    
    #def _tally_suits(self):
    #    """Return: a list of length card.NUM_SUITS (call it <counts>) in which
    #    counts[s] is the number of cards of suit s in the hand."""
    #    pass
    

