# poker_probs.py
# Steve Marschner (srm2) and Lillian Lee (ljl2)
# March 27, 2014
"""A program that estimates the probabilities of various poker hands using
a randomized experiment.  Works for any number of cards in the hand.
"""

import sys
import card
import hand
import random

def estimate_probs(num_cards, num_trials):
    counts = [0] * hand.Hand.NUM_HAND_TYPES
    for k in range(num_trials):
        deck = card.full_deck()
        random.shuffle(deck)
        h = hand.Hand(deck, num_cards)
        types = h.get_types()
        for i in range(hand.Hand.NUM_HAND_TYPES):
            counts[i] += types[i]
    for i in range(hand.Hand.NUM_HAND_TYPES):
        print hand.Hand.HAND_TYPE_NAMES[i] + ":", str(100 * counts[i] / float(num_trials)) + '%'

if __name__ == '__main__':
    if 2 <= len(sys.argv) <= 3:
        num_cards = int(sys.argv[1])
        if len(sys.argv) > 2:
            num_trials = int(sys.argv[2])
        else:
            num_trials = 1000
        estimate_probs(num_cards, num_trials)
    else:
        print "Usage: python poker_probs.py <number of cards> [<number of trials>]"