# poker_probs.py
# Steve Marschner (srm2) and Lillian Lee (ljl2)
# March 27, 2014
"""A program that estimates the probabilities of various poker hands using
a randomized experiment.  Works for any number of cards in the hand.
"""

import sys
import card
import hand
import random

def estimate_probs(num_cards, num_trials):
    print "Running experiment with", num_cards, "cards and", num_trials, "trials"
    num_pairs = 0
    num_3kind = 0
    num_fh = 0
    for trial in range(num_trials):
        deck = card.full_deck()
        random.shuffle(deck)
        h = hand.Hand(deck, num_cards)
        if h.is_pair():
            num_pairs += 1
        if h.is_3kind():
            num_3kind += 1
        if h.is_full_house():
            num_fh += 1
    print "one pair: " + str(num_pairs / float(num_trials) * 100) + "%"
    print "3 kind: " + str(num_3kind / float(num_trials) * 100) + "%"
    print "full house: " + str(num_fh / float(num_trials) * 100) + "%"

if __name__ == '__main__':
    if len(sys.argv) == 3:
        estimate_probs(int(sys.argv[1]), int(sys.argv[2]))
    else:
        print "Usage: python poker_probs.py <number of cards> <number of trials>"