/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.util.StringGetter;
import edu.cornell.cs3410.SimpleStringGetter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

class Video
extends InstanceFactory {
    private static final int P_CLK = 0;
    private static final int P_WE = 1;
    private static final int P_X = 2;
    private static final int P_Y = 3;
    private static final int P_DATA = 4;
    private static final int P_RST = 5;
    private static final String BLINK_YES = "Blinking Dot";
    private static final String BLINK_NO = "No Cursor";
    private static final String[] BLINK_OPTIONS = new String[]{"Blinking Dot", "No Cursor"};
    private static final String RESET_ASYNC = "Asynchronous";
    private static final String RESET_SYNC = "Synchronous";
    private static final String[] RESET_OPTIONS = new String[]{"Asynchronous", "Synchronous"};
    private static final Attribute<String> BLINK_OPTION = Attributes.forOption((String)"cursor", (StringGetter)new SimpleStringGetter("Cursor"), (Object[])BLINK_OPTIONS);
    private static final Attribute<String> RESET_OPTION = Attributes.forOption((String)"reset", (StringGetter)new SimpleStringGetter("Reset Behavior"), (Object[])RESET_OPTIONS);

    public Video() {
        super("LCD Video");
        this.setAttributes(new Attribute[]{BLINK_OPTION, RESET_OPTION}, new String[]{BLINK_YES, RESET_ASYNC});
        this.setOffsetBounds(Bounds.create((int)-270, (int)-140, (int)270, (int)270));
        Port[] ports = new Port[]{new Port(-220, 130, "input", 1), new Port(-200, 130, "input", 1), new Port(-140, 130, "input", 7), new Port(-130, 130, "input", 7), new Port(-120, 130, "input", 16), new Port(-240, 130, "input", 1)};
        ports[1].setToolTip((StringGetter)new SimpleStringGetter("Enable: if 1 write pixel to screen"));
        ports[2].setToolTip((StringGetter)new SimpleStringGetter("X coordinate"));
        ports[3].setToolTip((StringGetter)new SimpleStringGetter("Y coordinate"));
        ports[4].setToolTip((StringGetter)new SimpleStringGetter("RGB: in 5-5-5 format"));
        ports[5].setToolTip((StringGetter)new SimpleStringGetter("Reset"));
        this.setPorts(ports);
    }

    private static Value val(InstanceState s, int pin) {
        return s.getPort(pin);
    }

    private static int addr(InstanceState s, int pin) {
        return Video.val(s, pin).toIntValue();
    }

    public void propagate(InstanceState state) {
        Graphics g;
        Data data = Data.get(state);
        int x = Video.addr(state, 2);
        int y = Video.addr(state, 3);
        int color = Video.addr(state, 4);
        data.last_x = x;
        data.last_y = y;
        data.color = color;
        String reset_option = (String)state.getAttributeValue(RESET_OPTION);
        if (reset_option == null) {
            reset_option = RESET_OPTIONS[0];
        }
        if (data.tick(Video.val(state, 0)) && Video.val(state, 1) == Value.TRUE) {
            g = data.img.getGraphics();
            g.setColor(new Color(data.img.getColorModel().getRGB(color)));
            g.fillRect(x * 2, y * 2, 2, 2);
            if (RESET_SYNC.equals(reset_option) && Video.val(state, 5) == Value.TRUE) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, 256, 256);
            }
        }
        if (!RESET_SYNC.equals(reset_option) && Video.val(state, 5) == Value.TRUE) {
            g = data.img.getGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 256, 256);
        }
    }

    public void paintInstance(InstancePainter painter) {
        int size = painter.getBounds().getWidth();
        Data d = Data.get((InstanceState)painter);
        this.drawVideo(painter, painter.getLocation().getX(), painter.getLocation().getY(), d, (String)painter.getAttributeValue(BLINK_OPTION), (String)painter.getAttributeValue(RESET_OPTION));
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRoundRect(0, 0, 15, 15, 3, 3);
        g.setColor(Color.BLUE);
        g.fillRect(3, 3, 10, 10);
        g.setColor(Color.BLACK);
    }

    private boolean blink() {
        long now = System.currentTimeMillis();
        return now / 1000L % 2L == 0L;
    }

    private void drawVideo(InstancePainter painter, int x, int y, Data data, String blink_option, String reset_option) {
        Graphics g = painter.getGraphics();
        g.drawRoundRect(x -= 270, y -= 140, 269, 269, 6, 6);
        for (int i = 1; i <= 5; ++i) {
            painter.drawPort(i);
        }
        g.drawRect(x + 6, y + 6, 257, 257);
        painter.drawClock(0, Direction.NORTH);
        g.drawImage(data.img, x + 7, y + 7, null);
        if (blink_option == null) {
            blink_option = BLINK_OPTIONS[0];
        }
        if (BLINK_YES.equals(blink_option) && this.blink()) {
            g.setColor(new Color(data.img.getColorModel().getRGB(data.color)));
            g.fillRect(x + 7 + data.last_x * 2, y + 7 + data.last_y * 2, 2, 2);
        }
    }

    private static class Data
    implements InstanceData,
    Cloneable {
        public Value lastClock = null;
        public BufferedImage img;
        public int last_x;
        public int last_y;
        public int color;

        public static Data get(InstanceState state) {
            Data ret = (Data)state.getData();
            if (ret == null) {
                ret = new Data(new BufferedImage(256, 256, 9));
                state.setData((InstanceData)ret);
            }
            return ret;
        }

        private Data(BufferedImage img) {
            this.img = img;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        private boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }
}

