/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.hex.HexModel;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import edu.cornell.cs3410.ClockState;
import edu.cornell.cs3410.IntegerFactory;
import edu.cornell.cs3410.Mem;
import edu.cornell.cs3410.MemContents;
import edu.cornell.cs3410.MemState;
import edu.cornell.cs3410.SimpleStringGetter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class Ram
extends Mem {
    private static Attribute[] ATTRIBUTES = new Attribute[]{Mem.ADDR_ATTR};
    private static Object[] DEFAULTS = new Object[]{BitWidth.create((int)20)};
    private static final int OE = 3;
    private static final int CLR = 4;
    private static final int CLK = 5;
    private static final int WE = 6;
    private static final int DIN = 7;
    private static Object[][] logOptions = new Object[9][];
    static final Value[] vmask = new Value[]{Value.createUnknown((BitWidth)BitWidth.create((int)32)), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(16, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)16)).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(16, Value.UNKNOWN).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(24, Value.FALSE).extendWidth(32, Value.UNKNOWN), Value.createKnown((BitWidth)BitWidth.create((int)24), (int)0).extendWidth(32, Value.UNKNOWN), Value.createUnknown((BitWidth)BitWidth.create((int)24)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(16, Value.FALSE).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)16), (int)0).extendWidth(24, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)16)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)8), (int)0).extendWidth(16, Value.UNKNOWN).extendWidth(32, Value.FALSE), Value.createUnknown((BitWidth)BitWidth.create((int)8)).extendWidth(32, Value.FALSE), Value.createKnown((BitWidth)BitWidth.create((int)32), (int)0)};

    public Ram() {
        super("MIPS RAM", new SimpleStringGetter("MIPS RAM"), 3);
        this.setInstanceLogger(Logger.class);
    }

    protected void configureNewInstance(Instance instance) {
        super.configureNewInstance(instance);
        instance.addAttributeListener();
    }

    protected void instanceAttributeChanged(Instance instance, Attribute attr) {
        super.instanceAttributeChanged(instance, attr);
        this.configurePorts(instance);
    }

    void configurePorts(Instance instance) {
        boolean asynch = false;
        boolean separate = true;
        int portCount = 3;
        portCount = asynch ? (portCount += 2) : (separate ? (portCount += 5) : (portCount += 3));
        Port[] ps = new Port[portCount];
        this.configureStandardPorts(instance, ps);
        ps[3] = new Port(-50, 40, "input", 1);
        ps[3].setToolTip((StringGetter)new SimpleStringGetter("Load: if 1 load memory to output"));
        ps[4] = new Port(-30, 40, "input", 1);
        ps[4].setToolTip((StringGetter)new SimpleStringGetter("Clear: 1 resets contents to zero asynchronously"));
        if (!asynch) {
            ps[5] = new Port(-70, 40, "input", 1);
            ps[5].setToolTip((StringGetter)new SimpleStringGetter("Clock: memory value updates on rise from 0 to 1"));
        }
        if (separate) {
            ps[6] = new Port(-110, 40, "input", 1);
            ps[6].setToolTip((StringGetter)new SimpleStringGetter("Store: if 1 store input to memory"));
            ps[7] = new Port(-140, 20, "input", 32);
            ps[7].setToolTip((StringGetter)new SimpleStringGetter("Input: value stored at address"));
        } else {
            ps[0].setToolTip((StringGetter)new SimpleStringGetter("Data: value loaded or stored at address"));
        }
        instance.setPorts(ps);
    }

    public AttributeSet createAttributeSet() {
        return AttributeSets.fixedSet((Attribute[])ATTRIBUTES, (Object[])DEFAULTS);
    }

    MemState getState(InstanceState state) {
        BitWidth addrBits = (BitWidth)state.getAttributeValue(ADDR_ATTR);
        RamState myState = (RamState)state.getData();
        if (myState == null) {
            MemContents contents = MemContents.create(addrBits.getWidth(), 32);
            Instance instance = state.getInstance();
            myState = new RamState(instance, contents, new Mem.MemListener(instance));
            state.setData((InstanceData)myState);
        } else {
            myState.setRam(state.getInstance());
        }
        return myState;
    }

    MemState getState(Instance instance, CircuitState state) {
        BitWidth addrBits = (BitWidth)instance.getAttributeValue(ADDR_ATTR);
        RamState myState = (RamState)instance.getData(state);
        if (myState == null) {
            MemContents contents = MemContents.create(addrBits.getWidth(), 32);
            myState = new RamState(instance, contents, new Mem.MemListener(instance));
            instance.setData(state, (InstanceData)myState);
        } else {
            myState.setRam(instance);
        }
        return myState;
    }

    HexFrame getHexFrame(Project proj, Instance instance, CircuitState circState) {
        RamState state = (RamState)this.getState(instance, circState);
        return state.getHexFrame(proj);
    }

    public void propagate(InstanceState state) {
        boolean shouldClear;
        RamState myState = (RamState)this.getState(state);
        BitWidth dataBits = BitWidth.create((int)32);
        boolean asynch = false;
        boolean separate = true;
        Value addrValue = state.getPort(1);
        Value maskValue = state.getPort(2);
        boolean triggered = asynch || myState.setClock(state.getPort(5), StdAttr.TRIG_RISING);
        boolean outputEnabled = state.getPort(3) != Value.FALSE;
        boolean bl = shouldClear = state.getPort(4) == Value.TRUE;
        if (shouldClear) {
            myState.getContents().clear();
        }
        int mask = 0;
        int bmask = 0;
        if (maskValue.get(0) != Value.FALSE) {
            mask |= 1;
            bmask |= 0xFF;
        }
        if (maskValue.get(1) != Value.FALSE) {
            mask |= 2;
            bmask |= 0xFF00;
        }
        if (maskValue.get(2) != Value.FALSE) {
            mask |= 4;
            bmask |= 0xFF0000;
        }
        if (maskValue.get(3) != Value.FALSE) {
            mask |= 8;
            bmask |= 0xFF000000;
        }
        if (mask == 0) {
            myState.setCurrent(-1L, 0);
            state.setPort(0, Value.createUnknown((BitWidth)dataBits), 10);
            return;
        }
        int addr = addrValue.toIntValue();
        if (!addrValue.isFullyDefined() || addr < 0) {
            return;
        }
        if ((long)addr != myState.getCurrent()) {
            myState.setCurrent(addr, mask);
            myState.scrollToShow(addr);
        } else if (mask != myState.getCurrentMask()) {
            myState.setCurrent(addr, mask);
        }
        if (!shouldClear && triggered) {
            boolean shouldStore;
            if (separate) {
                shouldStore = state.getPort(6) != Value.FALSE;
            } else {
                boolean bl2 = shouldStore = !outputEnabled;
            }
            if (shouldStore) {
                Value dataValue = state.getPort(separate ? 7 : 0);
                int newVal = dataValue.toIntValue();
                int oldVal = myState.getContents().get(addr);
                newVal = newVal & bmask | oldVal & ~bmask;
                myState.getContents().set((long)addr, newVal);
            }
        }
        if (outputEnabled) {
            int val = myState.getContents().get(addr);
            Value v = vmask[mask].xor(Value.createKnown((BitWidth)BitWidth.create((int)32), (int)val));
            state.setPort(0, v, 10);
        } else {
            state.setPort(0, vmask[0], 10);
        }
    }

    public void paintInstance(InstancePainter painter) {
        super.paintInstance(painter);
        boolean asynch = false;
        boolean separate = true;
        if (!asynch) {
            painter.drawClock(5, Direction.NORTH);
        }
        painter.drawPort(3, "ld", Direction.SOUTH);
        painter.drawPort(4, "clr", Direction.SOUTH);
        if (separate) {
            painter.drawPort(6, "str", Direction.SOUTH);
            painter.getGraphics().setColor(Color.BLACK);
            painter.drawPort(7, "D", Direction.EAST);
        }
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Font old = g.getFont();
        g.setFont(old.deriveFont(9.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"RAM", (int)10, (int)9);
        g.setFont(old);
        g.drawRect(0, 4, 19, 12);
        for (int dx = 2; dx < 20; dx += 5) {
            g.drawLine(dx, 2, dx, 4);
            g.drawLine(dx, 16, dx, 18);
        }
    }

    public static class Logger
    extends InstanceLogger {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getLogOptions(InstanceState state) {
            int addrBits = ((BitWidth)state.getAttributeValue(Mem.ADDR_ATTR)).getWidth();
            if (addrBits >= logOptions.length) {
                addrBits = logOptions.length - 1;
            }
            Object[][] objectArray = logOptions;
            synchronized (objectArray) {
                Object[] ret = logOptions[addrBits];
                if (ret == null) {
                    ret = new Object[1 << addrBits];
                    logOptions[addrBits] = ret;
                    for (int i = 0; i < ret.length; ++i) {
                        ret[i] = IntegerFactory.create(i);
                    }
                }
                return ret;
            }
        }

        public String getLogName(InstanceState state, Object option) {
            if (option instanceof Integer) {
                String disp = "MIPSRAM";
                Location loc = state.getInstance().getLocation();
                return disp + loc + "[" + option + "]";
            }
            return null;
        }

        public Value getLogValue(InstanceState state, Object option) {
            if (option instanceof Integer) {
                MemState s = (MemState)state.getData();
                int addr = (Integer)option;
                return Value.createKnown((BitWidth)BitWidth.create((int)s.getDataBits()), (int)s.getContents().get(addr));
            }
            return Value.NIL;
        }
    }

    private static class RamState
    extends MemState
    implements InstanceData,
    AttributeListener {
        private Instance parent;
        private Mem.MemListener listener;
        private HexFrame hexFrame = null;
        private ClockState clockState;

        RamState(Instance parent, MemContents contents, Mem.MemListener listener) {
            super(contents);
            this.parent = parent;
            this.listener = listener;
            this.clockState = new ClockState();
            if (parent != null) {
                parent.getAttributeSet().addAttributeListener((AttributeListener)this);
            }
            contents.addHexModelListener(listener);
        }

        void setRam(Instance value) {
            if (this.parent == value) {
                return;
            }
            if (this.parent != null) {
                this.parent.getAttributeSet().removeAttributeListener((AttributeListener)this);
            }
            this.parent = value;
            if (value != null) {
                value.getAttributeSet().addAttributeListener((AttributeListener)this);
            }
        }

        public Object clone() {
            RamState ret = (RamState)super.clone();
            ret.parent = null;
            ret.clockState = (ClockState)this.clockState.clone();
            ret.getContents().addHexModelListener(this.listener);
            return ret;
        }

        public HexFrame getHexFrame(Project proj) {
            if (this.hexFrame == null) {
                this.hexFrame = new HexFrame(proj, (HexModel)this.getContents());
                this.hexFrame.addWindowListener((WindowListener)new WindowAdapter(){

                    public void windowClosed(WindowEvent e) {
                        RamState.this.hexFrame = null;
                    }
                });
            }
            return this.hexFrame;
        }

        public boolean setClock(Value newClock, Object trigger) {
            return this.clockState.updateClock(newClock, trigger);
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
            AttributeSet attrs = e.getSource();
            BitWidth addrBits = (BitWidth)attrs.getValue(Mem.ADDR_ATTR);
            this.getContents().setDimensions(addrBits.getWidth(), 32);
        }
    }
}

