/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.proj.Project;
import edu.cornell.cs3410.Program32;
import edu.cornell.cs3410.ProgramAssembler;
import edu.cornell.cs3410.ProgramFrame32;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramAttributes
extends AbstractAttributeSet {
    private static List<Attribute<?>> ATTRIBUTES = Arrays.asList(Program32.CONTENTS_ATTR);
    private static WeakHashMap<ProgramAssembler.Listing, ProgramFrame32> windowRegistry = new WeakHashMap();
    private ProgramAssembler.Listing contents = new ProgramAssembler.Listing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProgramFrame32 getProgramFrame(ProgramAssembler.Listing value, Project proj) {
        WeakHashMap<ProgramAssembler.Listing, ProgramFrame32> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            ProgramFrame32 ret = windowRegistry.get(value);
            if (ret == null) {
                ret = new ProgramFrame32(value, proj);
                ret.setLocationRelativeTo(null);
                ret.setLocation(300, 200);
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    ProgramAttributes() {
    }

    protected void copyInto(AbstractAttributeSet dest) {
        ProgramAttributes d = (ProgramAttributes)dest;
        d.contents = (ProgramAssembler.Listing)this.contents.clone();
    }

    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    public <V> V getValue(Attribute<V> attr) {
        if (attr == Program32.CONTENTS_ATTR) {
            return (V)this.contents;
        }
        return null;
    }

    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == Program32.CONTENTS_ATTR) {
            this.contents = (ProgramAssembler.Listing)value;
        }
        this.fireAttributeValueChanged(attr, value);
    }
}

