/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class ALU
extends InstanceFactory {
    public ALU() {
        super("Mips ALU");
        this.setOffsetBounds(Bounds.create((int)-30, (int)-50, (int)60, (int)100));
        this.setPorts(new Port[]{new Port(-30, -30, "input", 32), new Port(-30, 30, "input", 32), new Port(-10, 40, "input", 4), new Port(10, 30, "input", 5), new Port(30, 0, "input", 32)});
    }

    public void propagate(InstanceState state) {
        int A = state.getPort(0).toIntValue();
        int B = state.getPort(1).toIntValue();
        int op = state.getPort(2).toIntValue();
        int shift = state.getPort(3).toIntValue();
        int ans = 0;
        switch (op) {
            case 0: 
            case 1: {
                ans = B << shift;
                break;
            }
            case 2: 
            case 3: {
                ans = A + B;
                break;
            }
            case 4: {
                ans = B >>> shift;
                break;
            }
            case 5: {
                ans = B >> shift;
                break;
            }
            case 6: 
            case 7: {
                ans = A - B;
                break;
            }
            case 8: {
                ans = A & B;
                break;
            }
            case 10: {
                ans = A | B;
                break;
            }
            case 12: {
                ans = A ^ B;
                break;
            }
            case 14: {
                ans = ~(A | B);
                break;
            }
            case 9: {
                ans = A == B ? 1 : 0;
                break;
            }
            case 11: {
                ans = A != B ? 1 : 0;
                break;
            }
            case 13: {
                ans = A > 0 ? 1 : 0;
                break;
            }
            case 15: {
                ans = A <= 0 ? 1 : 0;
            }
        }
        Value out = Value.createKnown((BitWidth)BitWidth.create((int)32), (int)ans);
        state.setPort(4, out, 32);
    }

    public void paintInstance(InstancePainter painter) {
        Bounds bounds = painter.getBounds();
        int x0 = bounds.getX();
        int x1 = x0 + bounds.getWidth();
        int y0 = bounds.getY();
        int y1 = y0 + bounds.getHeight();
        int[] xp = new int[]{x0, x1, x1, x0, x0, x0 + 20, x0};
        int[] yp = new int[]{y0, y0 + 30, y1 - 30, y1, y1 - 40, y1 - 50, y1 - 60};
        GraphicsUtil.switchToWidth((Graphics)painter.getGraphics(), (int)2);
        painter.getGraphics().drawPolygon(xp, yp, 7);
        painter.drawPort(0, "A", Direction.EAST);
        painter.drawPort(1, "B", Direction.EAST);
        painter.drawPort(2, "OP", Direction.SOUTH);
        painter.drawPort(3, "SA", Direction.SOUTH);
        painter.drawPort(4, "C", Direction.WEST);
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.BLACK);
        int[] xp = new int[]{0, 15, 15, 0, 0, 3, 0};
        int[] yp = new int[]{0, 5, 10, 15, 10, 8, 6};
        g.drawPolygon(xp, yp, 7);
    }
}

