package edu.cornell.cs3410; // com.cburch.incr;

import java.util.Arrays;
import java.util.List;

import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;

public class Components extends Library {
    private List tools;

    public Components() {
        tools = Arrays.asList(new Tool[] {
                new AddTool(RegisterFile32.factory),
                new AddTool(Program32.factory),
                new AddTool(ALU.factory),
                new AddTool(Incrementer.factory),
                new AddTool(Video.factory),
                new AddTool(new Ram()),
                //new AddTool(LCD.factory),
                //new AddTool(Keyboard.factory),
                //new AddTool(Joystick.factory),
        });
    }
    
    public String getName() { return Components.class.getName(); }
    public String getDisplayName() { return "cs3410 Components"; }
    public List getTools() { return tools; }
}
